<?php
class Course_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // Insert Course data
    public function insertCourse($data) {
        $this->db->insert('course_master', $data);
        return $this->db->insert_id();
    }

    // Get all Courses with related data
    public function getdetailview()
    {      
        $this->db->select('course_master.Course_id,
                           course_master.fkbranch_id,
                           branch_master.branch_name,
                           course_master.finicial_Year,
                           finiyear_master.fini_Label,
                           course_master.Course_code,
                           course_master.Course_title,
                           course_master.Order_no,
                           course_master.status');

        $this->db->from('course_master');
        $this->db->join('branch_master','course_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('finiyear_master', 'course_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        
        // Branch filtering based on session
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!empty($branchIds)) {
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }
        
        $this->db->where('course_master.is_active', 1);
        $this->db->order_by('course_master.Course_id','DESC');

        $query = $this->db->get();
        return $query->result();      
    }

    // Get single Course by ID
    public function getCourseById($Course_id) {
        $this->db->select('course_master.*,
                           branch_master.branch_name,
                           finiyear_master.fini_Label');
        $this->db->from('course_master');
        $this->db->join('branch_master', 'course_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'course_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->where('course_master.Course_id', $Course_id);
        $this->db->where('course_master.is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

    // Update Course
    public function updateCourse($Course_id, $data) {
        $this->db->where('Course_id', $Course_id);
        return $this->db->update('course_master', $data);
    }

    // Soft Delete Course
    public function deleteCourse($Course_id) {
        $data = array(
            'is_active' => 0,
            'deleted_date' => date('Y-m-d H:i:s'),
            'deleted_by' => $this->session->userdata('userID')
        );
        $this->db->where('Course_id', $Course_id);
        return $this->db->update('course_master', $data);
    }

    // Hard Delete Course (permanent delete)
    public function permanentDeleteCourse($Course_id) {
        $this->db->where('Course_id', $Course_id);
        return $this->db->delete('course_master');
    }

    // Get all branches
    public function getbranch() 
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get all academic years
    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get active academic year
    public function getActiveYear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        $this->db->where('is_active', 1);
        return $this->db->get()->row();
    }
   
}
?>