<?php
  class Enter_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		$this->db->insert('enter_master',$model);
	return $this->db->insert_id();
	} 

public function getdetailview()
{      
    $this->db->select('enter_master.*, finiyear_master.fini_Label, student_reg.FullName,entrepreneurship_type.type_name, license_types.license_type_name, branch_master.branch_name, industry_types.industry_type_name');
    $this->db->from('enter_master');
    $this->db->join('student_reg', 'enter_master.fkStud_id = student_reg.Student_id', 'left');
    $this->db->join('finiyear_master', 'enter_master.fkFiniYear_id = finiyear_master.finiYear_id', 'left');
    $this->db->join('entrepreneurship_type', 'enter_master.fkEnterType_id = entrepreneurship_type.type_id', 'left');
    $this->db->join('license_types', 'enter_master.fkLicType_id = license_types.license_type_id', 'left');
    $this->db->join('branch_master', 'enter_master.fkBranch_id = branch_master.branch_id', 'left');
    $this->db->join('industry_types', 'enter_master.fkInduType_id = industry_types.industry_type_id', 'left');
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    
    $this->db->order_by('enter_master.EnterId', 'DESC');
    $query = $this->db->get();
    return $query->result();
}


      public function get_all_FinalYear()
{
    return $this->db->get('finiyear_master')->result();
}

      public function get_all_Student()
{
    return $this->db->get('student_reg')->result();
}
      public function get_all_EnterType()
{
    return $this->db->get('entrepreneurship_type')->result();
}

      public function get_all_License()
{
    return $this->db->get('license_types')->result();
}

public function getbranch()
     {
      $this->db->select('branch_master.*,');
      // new code
      $branchIds = $this->session->userdata('fkBranch_Id');
 
    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
    // new code end
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function get_all_InduType()
{
    return $this->db->get('industry_types')->result();
}


      public function getbyid($id)
		{
		  $this->db->select("enter_master.*,");
	    $this->db->where('EnterId',$id);
      $query = $this->db->get('enter_master');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('EnterId',$model['EnterId'])->update('enter_master',$model); 
    } 
    
public function getStudentsByBranch($branch_id) {
    return $this->db->where('fkBranch_id', $branch_id)
                    ->get('student_reg')
                    ->result();
}


    // ✅ Insert multiple photos for Entrepreneurship
    public function insertMultiplePhotos($enterId, $file_paths) {
        if (empty($file_paths)) return false;
        $insert_data = [];
        foreach ($file_paths as $path) {
            $insert_data[] = [
                'fkEnterId' => $enterId,   // changed from club_id
                'file_path' => $path
            ];
        }
        return $this->db->insert_batch('enter_photos', $insert_data); // changed table
    }

    // ✅ Get photos by EnterId
    public function getEnterGallery($enterId) {
        return $this->db
            ->select('*')
            ->from('enter_photos')   // changed table
            ->where('fkEnterId', $enterId) // changed column
            ->get()
            ->result();
    }

    // ✅ Delete all photos for an EnterId
    public function deleteImageData($enterId) {
        return $this->db->where('fkEnterId', $enterId) // changed column
                        ->delete('enter_photos');      // changed table
    }

    // ✅ Delete specific photos for an EnterId
    public function deleteSpecificPhotos($enterId, $file_paths) {
        if (empty($file_paths)) return false;
        $this->db->where('fkEnterId', $enterId);   // changed column
        $this->db->where_in('file_path', $file_paths);
        return $this->db->delete('enter_photos');  // changed table
    }

    // ✅ Delete existing photos (DB + physical files)
    public function deleteExistingPhotos($enterId, $removed_photos_array) {
        if (!empty($removed_photos_array)) {
            // Delete from DB
            $this->db->where('fkEnterId', $enterId); // changed column
            $this->db->where_in('file_path', $removed_photos_array);
            $this->db->delete('enter_photos');      // changed table

            // Delete physical files
            foreach ($removed_photos_array as $file_path) {
                $full_path = FCPATH . $file_path; // full server path
                if (file_exists($full_path)) {
                    unlink($full_path);
                }
            }
        }
    }


          public function get_all_institute()
{
    return $this->db->get('institute_master')->result();
}


public function getDataByInstitute($institute_id, $branches = [], $enters = [], $licenses = [], $industries = [], $years = [])
{
    $this->db->select('enter_master.*, 
                       branch_master.branch_name, 
                       student_reg.FullName, 
                       finiyear_master.fini_Label,
                       entrepreneurship_type.type_name,
                       license_types.license_type_name,
                       industry_types.industry_type_name');
    $this->db->from('enter_master');
    $this->db->join('branch_master', 'branch_master.branch_id = enter_master.fkBranch_id', 'left');
    $this->db->join('student_reg', 'enter_master.fkStud_id = student_reg.Student_id', 'left');
    $this->db->join('finiyear_master', 'enter_master.fkFiniYear_id = finiyear_master.finiYear_id', 'left');
    $this->db->join('entrepreneurship_type', 'enter_master.fkEnterType_id = entrepreneurship_type.type_id', 'left');
    $this->db->join('license_types', 'enter_master.fkLicType_id = license_types.license_type_id', 'left');
    $this->db->join('industry_types', 'enter_master.fkInduType_id = industry_types.industry_type_id', 'left');

    // ✅ filter by Institute
    if (!empty($institute_id)) {
        $this->db->where('enter_master.fkInstitute_id', $institute_id);
    }

    // ✅ filter by multi-select Branch
    if (!empty($branches)) {
        $this->db->where_in('enter_master.fkBranch_id', $branches);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
   
    }
// new code end

    // ✅ filter by multi-select Entrepreneurship Type
    if (!empty($enters)) {
        $this->db->where_in('enter_master.fkEnterType_id', $enters);
    }

    // ✅ filter by multi-select License Type
    if (!empty($licenses)) {
        $this->db->where_in('enter_master.fkLicType_id', $licenses);
    }

    // ✅ filter by multi-select Industry Type
    if (!empty($industries)) {
        $this->db->where_in('enter_master.fkInduType_id', $industries);
    }

    // ✅ filter by multi-select Financial Year
    if (!empty($years)) {
        $this->db->where_in('enter_master.fkFiniYear_id', $years);
    }

    // optional ordering (like your reference model)
    $this->db->order_by('enter_master.EnterId', 'DESC');

    $query = $this->db->get();
    return $query->result();
}


 public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("enter_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = enter_master.fkFiniYear_id")
        ->group_by("enter_master.fkFiniYear_id, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}


public function getSingleYearData($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(*) as count")
        ->from("enter_master sc")
        ->join("finiyear_master fy", "fy.finiYear_id = sc.fkFiniYear_id");

    $this->db->where("sc.fkFiniYear_id", $yearId);

    if (!empty($institu)) {
        $this->db->where('sc.fkInstitu_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sc.fkBranch_id', (array)$branches);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('sc.fkBranch_id', $branchIds);
   
    }
// new code end
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sc.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("sc.fkFiniYear_id, fy.fini_Label, fy.finiYear_id");

    return $this->db->get()->result_array();
}

public function getYearwiseTypes($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("sc.EnterId, sc.CompName, sc.fkStud_id, sr.FullName, fy.fini_Label as year")
        ->from("enter_master sc")
        ->join("finiyear_master fy", "fy.finiYear_id = sc.fkFiniYear_id")
        ->join('student_reg sr', 'sc.fkStud_id = sr.Student_id');

    $this->db->where("sc.fkFiniYear_id", $yearId);

    if (!empty($institu)) {
        $this->db->where('sc.fkInstitu_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sc.fkBranch_id', (array)$branches);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('sc.fkBranch_id', $branchIds);
   
    }
// new code end
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sc.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    return $this->db->get()->result_array();
}

    

  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(enter_master.EnterId) as enter_count');
    $this->db->from('branch_master');
    $this->db->join('enter_master', 'branch_master.branch_id = enter_master.fkBranch_id', 'left');

    if (!empty($institu)) {
        $this->db->where('enter_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
   
    }
// new code end
   if (!empty($year) && $year != 0) {
    $this->db->where('enter_master.fkFiniYear_id', $year);
}

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("enter_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');

    return $this->db->get()->result();
}

public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('enter_master.CompName,
                       enter_master.fkStud_id,
                       enter_master.fkBranch_id,
                       branch_master.branch_name,
                       student_reg.FullName,');
    $this->db->from('enter_master');
    $this->db->join('branch_master', 'branch_master.branch_id = enter_master.fkBranch_id', 'left');
     $this->db->join('student_reg', 'enter_master.fkStud_id = student_reg.Student_id', 'left');

//    if (is_array($branch_id)) {
//     $this->db->where_in('enter_master.fkBranch_id', $branch_id);
// } else {
//     $this->db->where('enter_master.fkBranch_id', $branch_id);
// }

if (!empty($branch_id)) {

    if (is_array($branch_id)) {
        $this->db->where_in('enter_master.fkBranch_id', $branch_id);
    } else {
        $this->db->where('enter_master.fkBranch_id', $branch_id);
    }

} else {
    // fallback to session branches
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!is_array($branchIds)) {
        $branchIds = explode(',', $branchIds);
    }

    $this->db->where_in('branch_master.branch_id', $branchIds);
}



    if (!empty($institu)) {
        $this->db->where('enter_master.fkInstitName_id', $institu);
    }
    if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('enter_master.fkFiniYear_id', $year);
    } else {
        $this->db->where('enter_master.fkFiniYear_id', $year);
    }
}
//     if (!empty($year) && $year != 0) {
//     $this->db->where('enter_master.fkFiniYear_id', $year);
// }

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("enter_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    return $this->db->get()->result();
}

public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];

    /* -------------------- 1. Branchwise Count -------------------- */
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.EnterId) AS enter_count');
    $this->db->from('branch_master b');
    $this->db->join('enter_master sr', 'b.branch_id = sr.fkBranch_id', 'left');

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    } else {
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
        $this->db->where_in('b.branch_id', $branchIds);
    }

    if (!empty($years)) {
        $this->db->where_in('sr.fkFiniYear_id', (array)$years);
    }

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where('sr.created_at >=', $startDate);
        $this->db->where('sr.created_at <=', $endDate);
    }

    $this->db->group_by(['b.branch_id', 'b.branch_name']);
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();

    /* -------------------- 2. Yearwise Count -------------------- */
    $this->db->select('fy.finiYear_id AS year_id, fy.fini_Label AS year, COUNT(sr.EnterId) AS count');
    $this->db->from('enter_master sr');
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = sr.fkFiniYear_id');

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('sr.fkBranch_id', (array)$branches);
    } else {
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
        $this->db->where_in('sr.fkBranch_id', $branchIds);
    }

    if (!empty($years)) {
        $this->db->where_in('sr.fkFiniYear_id', (array)$years);
    }

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where('sr.created_at >=', $startDate);
        $this->db->where('sr.created_at <=', $endDate);
    }

    $this->db->group_by(['fy.finiYear_id', 'fy.fini_Label']);
    $this->db->order_by('fy.finiYear_id', 'ASC');
    $response['yearData'] = $this->db->get()->result();

    return $response;
}


}