<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FeedbackFor_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // ==================== MASTER DATA FUNCTIONS ====================

    // Get answer type dropdown for multiselect
    public function getAnswerType()
    {
        $this->db->select('answerTypemaster.answertypeid, answerTypemaster.answertypename');
        $this->db->from('answerTypemaster');
        $this->db->where('answerTypemaster.is_active', 1);
        $this->db->order_by('answerTypemaster.orderno', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // ==================== CRUD FUNCTIONS ====================

    // Get by ID (for edit/update page)
    public function getbyid($id)
    {
        $this->db->select("feedbackfor_master.*");
        $this->db->where('feedbackid', $id);
        $query = $this->db->get('feedbackfor_master');
        return $query->result();
    }

    // Get selected answer types for a feedback for (for edit mode)
    public function getSelectedAnswerTypes($feedbackfor_id)
    {
        $this->db->select('answertypeid');
        $this->db->from('feedbackforanswer');
        $this->db->where('feedbackfor_id', $feedbackfor_id);
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        
        $result = array();
        foreach ($query->result() as $row) {
            $result[] = $row->answertypeid;
        }
        return $result;
    }

    // Insert Feedback For with Answer Types
    public function insertFeedbackFor($data, $answer_types)
    {
        // Start transaction
        $this->db->trans_start();
        
        // Insert into feedbackfor_master
        $insert_data = array(
            'feedbackforname' => $data['feedbackforname'],
            'questionperpage' => $data['questionperpage'],
            'is_default'      => isset($data['is_default']) ? $data['is_default'] : 0,
            'is_on'           => isset($data['is_on']) ? $data['is_on'] : 0,
            'is_active'       => isset($data['is_active']) ? $data['is_active'] : 1,
            'created_date'    => date('Y-m-d H:i:s'),
            'created_by'      => $this->session->userdata('user_id')
        );
        
        $this->db->insert('feedbackfor_master', $insert_data);
        $feedbackfor_id = $this->db->insert_id();
        
        // Insert into feedbackforanswer (multiple rows for each selected answer type)
        if (!empty($answer_types) && is_array($answer_types)) {
            foreach ($answer_types as $answertypeid) {
                $answer_data = array(
                    'feedbackfor_id' => $feedbackfor_id,
                    'answertypeid'   => $answertypeid,
                    'is_active'      => 1,
                    'created_date'   => date('Y-m-d H:i:s'),
                    'created_by'     => $this->session->userdata('user_id')
                );
                $this->db->insert('feedbackforanswer', $answer_data);
            }
        }
        
        // Complete transaction
        $this->db->trans_complete();
        
        if ($this->db->trans_status() === FALSE) {
            return array('status' => false);
        }
        
        return array(
            'status'       => true,
            'feedbackid'   => $feedbackfor_id
        );
    }

    // Update Feedback For with Answer Types
    public function updateFeedbackFor($feedbackfor_id, $data, $answer_types)
    {
        // Start transaction
        $this->db->trans_start();
        
        // Update feedbackfor_master
        $update_data = array(
            'feedbackforname' => $data['feedbackforname'],
            'questionperpage' => $data['questionperpage'],
            'is_default'      => isset($data['is_default']) ? $data['is_default'] : 0,
            'is_on'           => isset($data['is_on']) ? $data['is_on'] : 0,
            'is_active'       => isset($data['is_active']) ? $data['is_active'] : 1,
            'modified_date'   => date('Y-m-d H:i:s'),
            'modified_by'     => $this->session->userdata('user_id')
        );
        
        $this->db->where('feedbackid', $feedbackfor_id);
        $this->db->update('feedbackfor_master', $update_data);
        
        // Delete old answer type mappings
        $this->db->where('feedbackfor_id', $feedbackfor_id);
        $this->db->delete('feedbackforanswer');
        
        // Insert new answer type mappings
        if (!empty($answer_types) && is_array($answer_types)) {
            foreach ($answer_types as $answertypeid) {
                $answer_data = array(
                    'feedbackfor_id' => $feedbackfor_id,
                    'answertypeid'   => $answertypeid,
                    'is_active'      => 1,
                    'created_date'   => date('Y-m-d H:i:s'),
                    'created_by'     => $this->session->userdata('user_id')
                );
                $this->db->insert('feedbackforanswer', $answer_data);
            }
        }
        
        // Complete transaction
        $this->db->trans_complete();
        
        return $this->db->trans_status() !== FALSE;
    }

    // Delete Feedback For
    public function deleteFeedbackFor($feedbackfor_id)
    {
        // Start transaction
        $this->db->trans_start();
        
        // Delete from feedbackforanswer first
        $this->db->where('feedbackfor_id', $feedbackfor_id);
        $this->db->delete('feedbackforanswer');
        
        // Delete from feedbackfor_master
        $this->db->where('feedbackid', $feedbackfor_id);
        $this->db->delete('feedbackfor_master');
        
        // Complete transaction
        $this->db->trans_complete();
        
        return $this->db->trans_status() !== FALSE;
    }

    // Toggle Active Status
    public function toggleActiveStatus($feedbackfor_id, $is_active)
    {
        $data = array(
            'is_active'      => $is_active == 1 ? 1 : 0,
            'modified_date'  => date('Y-m-d H:i:s'),
            'modified_by'    => $this->session->userdata('user_id')
        );
        $this->db->where('feedbackid', $feedbackfor_id);
        return $this->db->update('feedbackfor_master', $data);
    }

    // ==================== LIST FUNCTIONS ====================

    // Get all feedback for with answer types count
    public function getAllFeedbackFor()
    {
        $this->db->select('feedbackfor_master.*, 
                          COUNT(feedbackforanswer.feedbackanswer_id) as answer_types_count');
        $this->db->from('feedbackfor_master');
        $this->db->join('feedbackforanswer', 'feedbackfor_master.feedbackid = feedbackforanswer.feedbackfor_id', 'left');
        $this->db->group_by('feedbackfor_master.feedbackid');
        $this->db->order_by('feedbackfor_master.feedbackid', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get feedback for with answer types (detailed)
    public function getFeedbackForWithAnswerTypes($feedbackfor_id)
    {
        $this->db->select('feedbackfor_master.*, 
                          answerTypemaster.answertypename,
                          feedbackforanswer.answertypeid');
        $this->db->from('feedbackfor_master');
        $this->db->join('feedbackforanswer', 'feedbackfor_master.feedbackid = feedbackforanswer.feedbackfor_id', 'left');
        $this->db->join('answerTypemaster', 'feedbackforanswer.answertypeid = answerTypemaster.answertypeid', 'left');
        $this->db->where('feedbackfor_master.feedbackid', $feedbackfor_id);
        
        $query = $this->db->get();
        return $query->result();
    }

    // Check duplicate
    public function checkDuplicateFeedbackFor($feedbackforname, $feedbackfor_id = null)
    {
        $this->db->select('feedbackid');
        $this->db->from('feedbackfor_master');
        $this->db->where('feedbackforname', $feedbackforname);
        
        if ($feedbackfor_id) {
            $this->db->where('feedbackid !=', $feedbackfor_id);
        }
        
        $query = $this->db->get();
        return $query->num_rows() > 0;
    }
}
?>