<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FeedbackReport_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    /**
     * Get complete feedback report data
     * @param int $url_id
     * @return array Complete data for report
     */
    public function get_report_data($url_id)
    {
        // Get master feedback data with all joins
        $this->db->select('
            cfm.url_id,
            cfm.fkInsitute_id,
            cfm.fkfeedbackforid,
            cfm.fkbranchid,
            cfm.academicyear,
            cfm.generated_url,
            cfm.is_active,
            im.Institu_name,
            fm.feedbackforname,
            bm.branch_name,
            fy.fini_Label
        ');
        $this->db->from('collegefeedback_master cfm');
        $this->db->join('institute_master im', 'cfm.fkInsitute_id = im.Institu_id', 'left');
        $this->db->join('feedbackfor_master fm', 'cfm.fkfeedbackforid = fm.feedbackid', 'left');
        $this->db->join('branch_master bm', 'cfm.fkbranchid = bm.branch_id', 'left');
        $this->db->join('finiyear_master fy', 'cfm.academicyear = fy.finiYear_id', 'left');
        $this->db->where('cfm.url_id', $url_id);
        
        $master_data = $this->db->get()->row();
        
        if (!$master_data) {
            return null;
        }

        // Get heading/logo data
        $this->db->select('subHead1, head, logo, subHead2, subHead3');
        $this->db->from('heading_master');
        $this->db->where('is_active', 1);
        $this->db->limit(1);
        $heading_data = $this->db->get()->row();

        // Get questions
        $this->db->select('questionid, question_name, feedbackid');
        $this->db->from('question_master');
        $this->db->where('feedbackid', $master_data->fkfeedbackforid);
        $this->db->where('is_active', 1);
        $this->db->order_by('questionid', 'ASC');
        $questions = $this->db->get()->result();

        // Get answer options/types
        $this->db->select('
            aft.answertypeid,
            atm.answertypename,
            atm.orderno
        ');
        $this->db->from('feedbackforanswer aft');
        $this->db->join('answerTypemaster atm', 'aft.answertypeid = atm.answertypeid', 'inner');
        $this->db->where('aft.feedbackfor_id', $master_data->fkfeedbackforid);
        $this->db->where('atm.is_active', 1);
        $this->db->order_by('atm.orderno', 'ASC');
        $answer_options = $this->db->get()->result();

        // Get statistics with count and percentage
        $this->db->select('
            cff.questionid,
            qm.question_name,
            cff.answertypeid,
            atm.answertypename,
            COUNT(*) as response_count
        ');
        $this->db->from('collagefeedback_formmaster cff');
        $this->db->join('question_master qm', 'cff.questionid = qm.questionid', 'left');
        $this->db->join('answerTypemaster atm', 'cff.answertypeid = atm.answertypeid', 'left');
        $this->db->where('cff.url_id', $url_id);
        $this->db->where('cff.feedbackforid', $master_data->fkfeedbackforid);
        $this->db->group_by('cff.questionid, cff.answertypeid');
        $this->db->order_by('cff.questionid, atm.orderno', 'ASC');
        $statistics = $this->db->get()->result();

        // Get total submissions - count distinct form submissions
        // Since created_at doesn't exist, we'll count unique combinations
        $this->db->select('COUNT(DISTINCT CONCAT(questionid, "-", answertypeid)) as total');
        $this->db->from('collagefeedback_formmaster');
        $this->db->where('url_id', $url_id);
        $total_result = $this->db->get()->row();
        $total_submissions = $total_result ? $total_result->total : 0;

        // Calculate percentages
        foreach ($statistics as $stat) {
            $stat->percentage = $total_submissions > 0 
                ? round(($stat->response_count / $total_submissions) * 100, 2) 
                : 0;
        }

        // Group statistics by question and answer type
        $question_stats = [];
        foreach ($statistics as $stat) {
            $question_stats[$stat->questionid][$stat->answertypeid] = [
                'count' => $stat->response_count,
                'percentage' => $stat->percentage
            ];
        }

        // Return complete data
        return [
            'master_data' => $master_data,
            'heading_data' => $heading_data,
            'questions' => $questions,
            'answer_options' => $answer_options,
            'statistics' => $statistics,
            'question_stats' => $question_stats,
            'total_submissions' => $total_submissions,
            'url_id' => $url_id
        ];
    }
}
?>