<?php
class File_Download_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    public function getFilesByDateRange($start_date, $end_date)
    {
        $files = [];
        
        // Use consistent path with controller
        $folder_path = FCPATH . 'uploads/';
        
        if (!is_dir($folder_path)) {
            log_message('error', 'Upload folder not found: ' . $folder_path);
            return $files;
        }
        
        $start_timestamp = strtotime($start_date . ' 00:00:00');
        $end_timestamp = strtotime($end_date . ' 23:59:59');
        
        log_message('info', 'Scanning folder: ' . $folder_path);
        log_message('info', 'Date range: ' . date('Y-m-d H:i:s', $start_timestamp) . ' to ' . date('Y-m-d H:i:s', $end_timestamp));
        
        try {
            // Recursively scan all folders inside uploads
            $directory = new RecursiveDirectoryIterator($folder_path, RecursiveDirectoryIterator::SKIP_DOTS);
            $iterator = new RecursiveIteratorIterator($directory);
            
            foreach ($iterator as $file) {
                if ($file->isFile()) {
                    $file_timestamp = $file->getMTime();
                    
                    // Check if file is within date range
                    if ($file_timestamp >= $start_timestamp && $file_timestamp <= $end_timestamp) {
                        // Get the full pathname
                        $full_path = $file->getPathname();
                        
                        // Normalize to forward slashes
                        $full_path = str_replace('\\', '/', $full_path);
                        $folder_path_normalized = str_replace('\\', '/', $folder_path);
                        
                        // Get relative path from uploads folder
                        $relative_path = str_replace($folder_path_normalized, '', $full_path);
                        $relative_path = ltrim($relative_path, '/');
                        
                        // Get folder name (first directory in path)
                        $path_parts = explode('/', $relative_path);
                        $folder_name = isset($path_parts[0]) && !empty($path_parts[0]) ? $path_parts[0] : 'root';
                        
                        $files[] = [
                            'name' => $file->getFilename(),
                            'path' => $full_path,
                            'size' => $file->getSize(),
                            'modified' => date('Y-m-d H:i:s', $file_timestamp),
                            'relative_path' => $relative_path,
                            'folder_name' => $folder_name
                        ];
                        
                        log_message('debug', 'Found file: ' . $relative_path . ' in folder: ' . $folder_name);
                    }
                }
            }
        } catch (Exception $e) {
            log_message('error', 'Error scanning directory: ' . $e->getMessage());
        }
        
        log_message('info', 'Total files found: ' . count($files));
        
        return $files;
    }
}