<?php
class Firstinduction_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // Insert main data into firstinduction_main_master
    public function insertMainData($data) {
        $this->db->insert('firstinduction_main_master', $data);
        return $this->db->insert_id();
    }
    
    // Update main data
    public function updateMainData($data, $id) {
        $this->db->where('Main_id', $id);
        return $this->db->update('firstinduction_main_master', $data);
    }
    
    // Insert data into firstind_sec_master (Tab 2)
    public function insertSecData($data) {
        return $this->db->insert('firstind_sec_master', $data);
    }
    
    // Update data in firstind_sec_master (Tab 2)
    public function updateSecData($data, $id) {
        $this->db->where('Sec_id', $id);
        return $this->db->update('firstind_sec_master', $data);
    }
    
    // Delete specific sec records by IDs
    public function deleteSecByIds($ids) {
        $this->db->where_in('Sec_id', $ids);
        return $this->db->delete('firstind_sec_master');
    }
    
    // Insert data into firstind_third_master (Tab 6)
    public function insertThirdData($data) {
        return $this->db->insert('firstind_third_master', $data);
    }
    
    // Update data in firstind_third_master (Tab 6)
    public function updateThirdData($data, $id) {
        $this->db->where('Third_id', $id);
        return $this->db->update('firstind_third_master', $data);
    }
    
    // Delete specific third records by IDs
    public function deleteThirdByIds($ids) {
        $this->db->where_in('Third_id', $ids);
        return $this->db->delete('firstind_third_master');
    }
    
    // Insert data into firstind_fourth_master (Tab 7)
    public function insertFourthData($data) {
        return $this->db->insert('firstind_fourth_master', $data);
    }
    
    // Update data in firstind_fourth_master (Tab 7)
    public function updateFourthData($data, $id) {
        $this->db->where('Fourth_id', $id);
        return $this->db->update('firstind_fourth_master', $data);
    }
    
    // Delete specific fourth records by IDs
    public function deleteFourthByIds($ids) {
        $this->db->where_in('Fourth_id', $ids);
        return $this->db->delete('firstind_fourth_master');
    }
    
    // Insert data into firstind_fifth_master (Tab 8)
    public function insertFifthData($data) {
        return $this->db->insert('firstind_fifth_master', $data);
    }
    
    // Update data in firstind_fifth_master (Tab 8)
    public function updateFifthData($data, $id) {
        $this->db->where('Fifth_id', $id);
        return $this->db->update('firstind_fifth_master', $data);
    }
    
    // Delete specific fifth records by IDs
    public function deleteFifthByIds($ids) {
        $this->db->where_in('Fifth_id', $ids);
        return $this->db->delete('firstind_fifth_master');
    }
    
    // Get year data
    public function getyear() {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('fini_Label', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get active year
    public function getActiveYear() {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }
    
    // Get all induction records for list view
    public function getdetailview() {
        $this->db->select('m.*, f.fini_Label');
        $this->db->from('firstinduction_main_master m');
        $this->db->join('finiyear_master f', 'm.finicial_Year = f.finiYear_id', 'left');
        $this->db->order_by('m.Main_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get induction record by ID for edit
    public function getInductionById($id) {
        $this->db->select('m.*, f.fini_Label');
        $this->db->from('firstinduction_main_master m');
        $this->db->join('finiyear_master f', 'm.finicial_Year = f.finiYear_id', 'left');
        $this->db->where('m.Main_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get Tab 2 data by Main ID
    public function getSecDataByMainId($id) {
        $this->db->select('*');
        $this->db->from('firstind_sec_master');
        $this->db->where('fkMain_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get Tab 6 data by Main ID
    public function getThirdDataByMainId($id) {
        $this->db->select('*');
        $this->db->from('firstind_third_master');
        $this->db->where('fkMain_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get Tab 7 data by Main ID
    public function getFourthDataByMainId($id) {
        $this->db->select('*');
        $this->db->from('firstind_fourth_master');
        $this->db->where('fkMain_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get Tab 8 data by Main ID
    public function getFifthDataByMainId($id) {
        $this->db->select('*');
        $this->db->from('firstind_fifth_master');
        $this->db->where('fkMain_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    
    // Delete records by Main ID
    public function deleteByMainId($id) {
        // Delete from all child tables
        $this->db->where('fkMain_id', $id);
        $this->db->delete('firstind_sec_master');
        
        $this->db->where('fkMain_id', $id);
        $this->db->delete('firstind_third_master');
        
        $this->db->where('fkMain_id', $id);
        $this->db->delete('firstind_fourth_master');
        
        $this->db->where('fkMain_id', $id);
        $this->db->delete('firstind_fifth_master');
        
        // Delete from main table
        $this->db->where('Main_id', $id);
        return $this->db->delete('firstinduction_main_master');
    }
}