<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Getlink_model extends CI_Model {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Get all active menu items ordered by ArrangeNo
     */
    public function get_active_menus()
    {
        $this->db->select('MenuID, MenuName, MenuURL, MenuIcon, ArrangeNo, menu_master.is_default, menu_master.is_on, menu_master.is_active');
        $this->db->join('useraccess_master', 'menu_master.MenuID = useraccess_master.fkMenu_Id');
        $this->db->from('menu_master');
        $this->db->where('menu_master.is_active', 1);
        $this->db->where('useraccess_master.fkUserID', $this->session->userdata('userID'));
        $this->db->where('menu_master.is_active', 1);
        $this->db->group_by('menu_master.MenuID');
        $this->db->order_by('ArrangeNo', 'ASC');
        $query = $this->db->get();
        
        return $query->result();
    }

    /**
     * Get menu item by ID
     */
    public function get_menu_by_id($menu_id)
    {
        $this->db->where('MenuID', $menu_id);
        $query = $this->db->get('menu_master');
        $this->db->where('menu_master.is_active', 1);
        return $query->row();
    }

    /**
     * Get user details by UserID - NEW METHOD
     */
    public function get_user_by_id($user_id)
    {
        $this->db->select('UserID, UserName');
        $this->db->from('user_master');
        $this->db->where('UserID', $user_id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row();
        }
        return null;
    }
}