<?php
class Grantrec_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
   
public function insertGrantRec($data) {
     $this->db->insert('grantrec_master', $data);
     return $this->db->insert_id();
}

    // Get all ICT Tools with related data
    public function getdetailview()
    {      
        $this->db->select('grantrec_master.Grant_id,
                           grantrec_master.fkfac_id,
                           faculty_master.fac_Fullname,
                           grantrec_master.fkbranch_id,
                           branch_master.branch_name,
                           grantrec_master.Grant_date,
                           grantrec_master.description,
                           grantrec_master.fkgranttype_id,
                           granttype_master.granttype_name,
                           grantrec_master.Amount_rec,
                           grantrec_master.finicial_Year,
                           finiyear_master.fini_Label,
                           grantrec_master.institute,
                           institute_master.Institu_name');
        $this->db->from('grantrec_master');
        $this->db->join('faculty_master', 'grantrec_master.fkfac_id = faculty_master.fac_id', 'left');
        $this->db->join('branch_master','grantrec_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('granttype_master', 'grantrec_master.fkgranttype_id = granttype_master.granttype_id', 'left');
        $this->db->join('finiyear_master', 'grantrec_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->join('institute_master', 'grantrec_master.institute = institute_master.Institu_id', 'left');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->where('grantrec_master.is_active', 1);
        $this->db->order_by('grantrec_master.Grant_id','DESC');

        $query = $this->db->get();
        return $query->result();      
    }

    // ============================================
    // UPDATE & DELETE METHODS - NAYE METHODS
    // ============================================
    
    // Get single ICT Tool by ID
    public function getGrantRecById($Grant_id) {
        $this->db->select('grantrec_master.*,
                           branch_master.branch_name,
                           granttype_master.granttype_name,
                           finiyear_master.fini_Label');
        $this->db->from('grantrec_master');
        $this->db->join('branch_master', 'grantrec_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('granttype_master', 'grantrec_master.fkgranttype_id = granttype_master.granttype_id', 'left');
        $this->db->join('finiyear_master', 'grantrec_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->where('grantrec_master.Grant_id', $Grant_id);
        $this->db->where('grantrec_master.is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

// Update Grant Record
public function updateGrantRec($Grant_id, $data) {
    $this->db->where('Grant_id', $Grant_id);
    return $this->db->update('grantrec_master', $data);
}

// Soft Delete Grant Record
public function deleteGrantRec($Grant_id) {
    $data = array(
        'is_active' => 0,
        'modified_date' => date('Y-m-d H:i:s')
    );
    $this->db->where('Grant_id', $Grant_id);
    return $this->db->update('grantrec_master', $data);
}
    // ============================================
    // MASTER DATA METHODS
    // ============================================



    // Insert new faculty and return ID
    public function insertFaculty($data) {
        if ($this->db->insert('faculty_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new branch and return ID
    public function insertBranch($data) {
        if ($this->db->insert('branch_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new institute and return ID
    public function insertinstitute($data) {
        if ($this->db->insert('institute_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new faculty and return ID
    public function insertGranttype($data) {
        if ($this->db->insert('granttype_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new year and return ID
    public function insertYear($data) {
        if ($this->db->insert('finiyear_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Get faculty data  
    public function getfaculty() {
        $this->db->select('fac_id, fac_Fullname');
        $this->db->from('faculty_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('fac_Fullname', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get branch data
    public function getbranch() {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get institute data
    public function getinstitute() {
        $this->db->select('Institu_id, Institu_name');
        $this->db->from('institute_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Institu_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get faculty data  
    public function getgranttype() {
        $this->db->select('granttype_id, granttype_name');
        $this->db->from('granttype_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('granttype_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get year data  
    public function getyear() {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('fini_Label', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Check if faculty exists by name
    public function facultyExists($faculty_name) {
        $this->db->where('LOWER(fac_Fullname)', strtolower($faculty_name));
        $query = $this->db->get('faculty_master');
        return $query->num_rows() > 0;
    }

    // Check if branch exists by name
    public function branchExists($branch_name) {
        $this->db->where('LOWER(branch_name)', strtolower($branch_name));
        $query = $this->db->get('branch_master');
        return $query->num_rows() > 0;
    }

     // Check if institute exists by name
    public function instituteExists($institute_name) {
        $this->db->where('LOWER(Institu_name)', strtolower($institute_name));
        $query = $this->db->get('institute_master');
        return $query->num_rows() > 0;
    }
    
    
    // Check if faculty exists by name
    public function granttypeExists($granttype_name) {
        $this->db->where('LOWER(granttype_name)', strtolower($granttype_name));
        $query = $this->db->get('granttype_master');
        return $query->num_rows() > 0;
    }
    
    // Check if year exists by name
    public function yearExists($year_name) {
        $this->db->where('LOWER(fini_Label)', strtolower($year_name));
        $query = $this->db->get('finiyear_master');
        return $query->num_rows() > 0;
    }

    // Get faculty ID by name
    public function getFacultyIdByName($faculty_name) {
        $this->db->select('fac_id');
        $this->db->where('LOWER(fac_Fullname)', strtolower($faculty_name));
        $query = $this->db->get('faculty_master');
        if ($query->num_rows() > 0) {
            return $query->row()->fac_id;
        }
        return false;
    }
    
    // Get branch ID by name
    public function getBranchIdByName($branch_name) {
        $this->db->select('branch_id');
        $this->db->where('LOWER(branch_name)', strtolower($branch_name));
        $query = $this->db->get('branch_master');
        if ($query->num_rows() > 0) {
            return $query->row()->branch_id;
        }
        return false;
    }

     // Get institute ID by name
    public function getinstituteIdByName($institute_name) {
        $this->db->select('Institu_id');
        $this->db->where('LOWER(Institu_name)', strtolower($institute_name));
        $query = $this->db->get('institute_master');
        if ($query->num_rows() > 0) {
            return $query->row()->Institu_id;
        }
        return false;
    }
    
   // Get Grant Type ID by name - CORRECTED
public function getGranttypeIdByName($granttype_name) {
    $this->db->select('granttype_id');  // Grant_id se change karke granttype_id
    $this->db->where('LOWER(granttype_name)', strtolower($granttype_name));
    $query = $this->db->get('granttype_master');
    if ($query->num_rows() > 0) {
        return $query->row()->granttype_id;  // Yeh bhi change karo
    }
    return false;
}
    
    // Get year ID by name
    public function getYearIdByName($year_name) {
        $this->db->select('finiYear_id');
        $this->db->where('LOWER(fini_Label)', strtolower($year_name));
        $query = $this->db->get('finiyear_master');
        if ($query->num_rows() > 0) {
            return $query->row()->finiYear_id;
        }
        return false;
    }
}
?>