<?php
  class GuestReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  


public function getGuestDataFiltered($institu_id, $branch_ids = null, $class_ids = null, $year = null, $startdate = null, $enddate = null)
{
    $this->db->select('
        guestlectures_master.Guest_id ,
                       guestlectures_master.Guest_name,
                       guestlectures_master.fkbranch_id,
                       branch_master.branch_name,
                       guestlectures_master.fkclass_id,
                       classmaster.classname,
                       guestlectures_master.fkdesig_id,
                       designation_master.desig_name,
                       guestlectures_master.fkfac_id,
                       faculty_master.fac_Fullname,
                        guestlectures_master.fkSemID,
                        semester_master.Sem_Name,
                       guestlectures_master.Talk_date,
                       guestlectures_master.oraganization,
                       guestlectures_master.No_benefit,
                       guestlectures_master.Expert_topic,
                       guestlectures_master.location,
                        guestlectures_master.start_date,
                       guestlectures_master.end_date,
                       guestlectures_master.Report_photos,
                       guestlectures_master.Remuneration
    ');
    $this->db->from('guestlectures_master');
    $this->db->join('branch_master', 'branch_master.branch_id = guestlectures_master.fkbranch_id', 'left');
    $this->db->join('classmaster', 'classmaster.class_id = guestlectures_master.fkclass_id', 'left');
    $this->db->join('semester_master','guestlectures_master.fkSemID = semester_master.SemID','left');
    $this->db->join('faculty_master', 'guestlectures_master.fkfac_id = faculty_master.fac_id', 'left');
    $this->db->join('designation_master', 'designation_master.desig_id  = guestlectures_master.fkdesig_id', 'left');

    // institute filter
    $this->db->where('guestlectures_master.institute', $institu_id);

    // ✅ branch filter (only if selected)
    if (!empty($branch_ids) && count($branch_ids) > 0) {
        $this->db->where_in('guestlectures_master.fkbranch_id', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

    // ✅ class filter (only if selected)
    if (!empty($class_ids) && count($class_ids) > 0) {
        $this->db->where_in('guestlectures_master.fkclass_id', $class_ids);
    }

    // ✅ financial year filter (only if selected)
    if (!empty($year) && $year != 0) {
        $this->db->where('guestlectures_master.finicial_Year', $year);

    }
    //   // ✅ Date filter condition
    // if (!empty($startdate) && !empty($enddate)) {
    //     $this->db->where('guestlectures_master.start_date >=', $startdate);
    //     $this->db->where('guestlectures_master.end_date <=', $enddate);
    // }

    if (!empty($startdate) && !empty($enddate)) {
    $this->db->where('guestlectures_master.start_date <=', $enddate);
    $this->db->where('guestlectures_master.end_date >=', $startdate);
}

    // $this->db->order_by('guestlectures_master.Guest_id', 'DESC');
    // return $this->db->get()->result();
     $this->db->group_by('guestlectures_master.Guest_id');
    $this->db->order_by('guestlectures_master.Guest_id', 'DESC');

    $query = $this->db->get();
    return $query->result();
}


 
     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }
 
     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }
 
    
      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
 
 
      public function getclass()
     {
      $this->db->select('classmaster.*,');
      $this->db->from('classmaster');
       $query = $this->db->get();
        return $query->result();
     }

     

       public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
} 

// student list 

public function getStudentsByMeetId($fkGuest_id)
{
    return $this->db->select('student_name, fk_branch, prn_no, fk_class')
                    ->from('guestlec_student')
                    ->where('fkGuest_id', $fkGuest_id)
                    ->get()
                    ->result_array();
}

// pai ghraph new 

public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(guestlectures_master.Guest_id) as count")
        ->from("guestlectures_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = guestlectures_master.finicial_Year")
        ->group_by("guestlectures_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(guestlectures_master.Guest_id) as count")
        ->from("guestlectures_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = guestlectures_master.finicial_Year")
        ->where("guestlectures_master.finicial_Year", $yearId);
  

    if (!empty($branches)) {
                $this->db->where_in('guestlectures_master.fkbranch_id', (array)$branches);
            }
             else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('guestlectures_master.fkbranch_id', explode(',', $branchIds));
    }
}

    $this->db->group_by("guestlectures_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
    return $this->db->get()->result_array();
}


 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("guestlectures_master.Guest_id ,
                       guestlectures_master.Guest_name,
                       guestlectures_master.fkbranch_id,
                       branch_master.branch_name,
                       guestlectures_master.fkclass_id,
                       classmaster.classname,
                       guestlectures_master.fkdesig_id,
                       designation_master.desig_name,
                       guestlectures_master.fkfac_id,
                       faculty_master.fac_Fullname,
                        guestlectures_master.fkSemID,
                        semester_master.Sem_Name,
                       guestlectures_master.Talk_date,
                       guestlectures_master.oraganization,
                       guestlectures_master.No_benefit,
                       guestlectures_master.Expert_topic,
                       guestlectures_master.location,
                        guestlectures_master.start_date,
                       guestlectures_master.end_date,
                       guestlectures_master.Report_photos,
                       guestlectures_master.Remuneration,
                       finiyear_master.fini_Label as year")
        
      ->from("guestlectures_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = guestlectures_master.finicial_Year")
        ->join('branch_master','guestlectures_master.fkbranch_id = branch_master.branch_id','left')
       ->join('classmaster', 'classmaster.class_id = guestlectures_master.fkclass_id', 'left')
      ->join('semester_master','guestlectures_master.fkSemID = semester_master.SemID','left')
    ->join('designation_master','guestlectures_master.fkdesig_id = designation_master.desig_id','left')
    ->join('faculty_master','guestlectures_master.fkfac_id = faculty_master.fac_id','left')
        ->where("guestlectures_master.finicial_Year", $yearId);

    if (!empty($branches)) {
        $this->db->where_in('guestlectures_master.fkbranch_id', (array)$branches);
       }
 else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('guestlectures_master.fkbranch_id', explode(',', $branchIds));
    }
}
        return $this->db->get()->result_array();
}
 
 

 

 
// Add these methods to your VAPReport_model class

  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(guestlectures_master.Guest_id) as Guest_count');
    $this->db->from('branch_master');
    $this->db->join('guestlectures_master', 'branch_master.branch_id = guestlectures_master.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('guestlectures_master.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('guestlectures_master.finicial_Year', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("guestlectures_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('guestlectures_master.Guest_name,
                       guestlectures_master.Guest_id,
                       guestlectures_master.fkbranch_id,
                       branch_master.branch_name,
                       guestlectures_master.fkclass_id,
                       classmaster.classname,
                       guestlectures_master.fkdesig_id,
                       designation_master.desig_name,
                       guestlectures_master.fkfac_id,
                       faculty_master.fac_Fullname,
                        guestlectures_master.fkSemID,
                        semester_master.Sem_Name,
                       guestlectures_master.Talk_date,
                       guestlectures_master.oraganization,
                       guestlectures_master.No_benefit,
                       guestlectures_master.location,
                       guestlectures_master.Expert_topic,
                        guestlectures_master.start_date,
                       guestlectures_master.end_date,
                       guestlectures_master.Report_photos,
                       guestlectures_master.Remuneration,
                       guestlectures_master.feedbackDoc,'
                    );
    $this->db->from('guestlectures_master');
    $this->db->join('branch_master', 'branch_master.branch_id = guestlectures_master.fkbranch_id', 'left');
    $this->db->join('classmaster', 'classmaster.class_id = guestlectures_master.fkclass_id', 'left');
    $this->db->join('semester_master','guestlectures_master.fkSemID = semester_master.SemID','left');
    $this->db->join('designation_master','guestlectures_master.fkdesig_id = designation_master.desig_id','left');
    $this->db->join('faculty_master','guestlectures_master.fkfac_id = faculty_master.fac_id','left'); 
 
   if (is_array($branch_id)) {
    $this->db->where_in('guestlectures_master.fkbranch_id', $branch_id);
} else {
    $this->db->where('guestlectures_master.fkbranch_id', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('guestlectures_master.institute', $institu);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('guestlectures_master.finicial_Year', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("guestlectures_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.Guest_id) as Guest_count');
    $this->db->from('branch_master b');
    $this->db->join('guestlectures_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sr.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.Guest_id) as count");
    $this->db->from("guestlectures_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sr.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkbranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sr.fkbranch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
 
}