<?php
class HOD_branchleave_model extends CI_Model {
 public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('leaveapp_master',$model);
			//return $sql->result();
	} 


   public function getActiveBranchFromSession($active_id)
{
    // Step 1: Get fkbranch_id from activeheads_master
    $this->db->select('fkbranch_id');
    $this->db->from('activeheads_master');
    $this->db->where('active_id', $active_id);
    $row = $this->db->get()->row();

    if ($row) {
        $branch_id = $row->fkbranch_id;

        // Step 2: Get branch_name
        $this->db->select('branch_name');
        $this->db->from('branch_master');
        $this->db->where('branch_id', $branch_id);
        $branch_row = $this->db->get()->row();

        if ($branch_row) {
            return [
                'branch_id' => $branch_id,
                'branch_name' => $branch_row->branch_name
            ];
        }
    }

    return [
        'branch_id' => '',
        'branch_name' => ''
    ];
}



    // public function getFacultyByBranch($branch_id) {
    //     $this->db->select('fac_id, fac_Fullname');
    //     $this->db->from('faculty_master');
    //     $this->db->where('fkbranch_id', $branch_id);
    //     return $this->db->get()->result();
    // }

    // public function getyear() {
    //     return $this->db->query("SELECT DISTINCT YEAR(LeaveDate) AS year FROM leave_application ORDER BY year DESC")->result();
    // }


    public function getfaculty($branch_id)
{
    $this->db->select('*');
    $this->db->from('faculty_master');
    $this->db->where('fkbranch_id', $branch_id);
    $query = $this->db->get();
    return $query->result();
}


   public function getyear()
  {      
   
     $this->db->select('finiyear_master.*');
     $this->db->from('finiyear_master');
     $query = $this->db->get();
     return $query->result();

          
  }
   
// public function getAllLeaveByBranch($branch_id)
// {
//     $this->db->select('
//         l.*,
//         f.fac_Fullname AS faculty_name,
//         altf.fac_Fullname AS alternative_faculty_name,
//         leavecat_master.leave_name,
//         hodflag.flag_value AS hod_status,
//         regflag.flag_value AS reg_status,
//         princflag.flag_value AS princ_status,
//         hodflag.flag_color AS hod_color,
//         regflag.flag_color AS reg_color,
//         princflag.flag_color AS princ_color
//     ');
//     $this->db->from('leaveapp_master l');
//     $this->db->join('faculty_master f', 'l.fkfac_id = f.fac_id');
//     $this->db->join('faculty_master altf', 'l.fkAlternative_id = altf.fac_id', 'left');
//     $this->db->join('leavecat_master', 'l.LeaveType = leavecat_master.leaveCat_id', 'left');
//     $this->db->join('flag_master hodflag', 'hodflag.flag_id = l.HOD_Approval', 'left');
//     $this->db->join('flag_master regflag', 'regflag.flag_id = l.REG_Approval', 'left');
//     $this->db->join('flag_master princflag', 'princflag.flag_id = l.Princ_Approval', 'left');

//     if (!empty($branch_id)) {
//         $this->db->where('f.fkbranch_id', $branch_id);
//     }
//     $this->db->order_by('l.Leave_from', 'DESC');
//     return $this->db->get()->result();
// }


public function getAllLeaveByBranch($branch_id)
{
    $this->db->select('
        l.*,
        f.fac_Fullname AS faculty_name,
        altf.fac_Fullname AS alternative_faculty_name,
        leavecat_master.leave_name,
        hod_flag.flag_name AS hod_status,
        reg_flag.flag_name AS reg_status,
        princ_flag.flag_name AS princ_status,
        hod_flag.color_code AS hod_color,
        princ_flag.color_code AS princ_color,
        reg_flag.color_code AS reg_color
    ');
    $this->db->from('leaveapp_master l');
    $this->db->join('faculty_master f', 'l.fkfac_id = f.fac_id');
    $this->db->join('faculty_master altf', 'l.fkAlternative_id = altf.fac_id', 'left');
    $this->db->join('leavecat_master', 'l.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('flag_master hod_flag', 'hod_flag.flag_value = l.HOD_Approval', 'left');
    $this->db->join('flag_master reg_flag', 'reg_flag.flag_value = l.REG_Approval', 'left');
    $this->db->join('flag_master princ_flag', 'princ_flag.flag_value = l.Princ_Approval', 'left');

    if (!empty($branch_id)) {
        $this->db->where('f.fkbranch_id', $branch_id);
    }

    $this->db->order_by('l.Leave_from', 'DESC');

    return $this->db->get()->result();
}

public function getLeaveMonthly($faculty_id, $branch_id, $month)
{
    $this->db->select('l.*, f.fac_Fullname AS faculty_name, altf.fac_Fullname AS alternative_faculty_name, leavecat_master.leave_name,
        hod_flag.flag_name AS hod_status,
        reg_flag.flag_name AS reg_status,
        princ_flag.flag_name AS princ_status,
        hod_flag.color_code AS hod_color,
        princ_flag.color_code AS princ_color,
        reg_flag.color_code AS reg_color');
        
    $this->db->from('leaveapp_master l');
    $this->db->join('faculty_master f', 'l.fkfac_id = f.fac_id');
    $this->db->join('leavecat_master', 'l.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('faculty_master altf', 'l.fkAlternative_id = altf.fac_id', 'left');
    $this->db->join('flag_master hod_flag', 'hod_flag.flag_value = l.HOD_Approval', 'left');
    $this->db->join('flag_master reg_flag', 'reg_flag.flag_value = l.REG_Approval', 'left');
    $this->db->join('flag_master princ_flag', 'princ_flag.flag_value = l.Princ_Approval', 'left');

    if (!empty($faculty_id)) {
        $this->db->where('l.fkfac_id', $faculty_id);
    }

    if (!empty($branch_id)) {
        $this->db->where('f.fkbranch_id', $branch_id);
    }

    // Filter by Leave_from or Leave_to month
    $this->db->group_start();
        $this->db->like('l.Leave_from', $month);
        $this->db->or_like('l.Leave_to', $month);
    $this->db->group_end();
    $this->db->order_by('l.Leave_from', 'DESC');
    return $this->db->get()->result();
}



public function getLeaveYearly($faculty_id, $branch_id, $year_id)
{
    $this->db->select('StartDate, EndDate');
    $this->db->from('finiyear_master');
    $this->db->where('finiYear_id', $year_id);
    $year = $this->db->get()->row();

    if (!$year) return [];

    $start_date = $year->StartDate;
    $end_date   = $year->EndDate;

    $this->db->select('l.*, f.fac_Fullname AS faculty_name, altf.fac_Fullname AS alternative_faculty_name, leavecat_master.leave_name,
        hod_flag.flag_name AS hod_status,
        reg_flag.flag_name AS reg_status,
        princ_flag.flag_name AS princ_status,
        hod_flag.color_code AS hod_color,
        princ_flag.color_code AS princ_color,
        reg_flag.color_code AS reg_color');
        
    $this->db->from('leaveapp_master l');
    $this->db->join('faculty_master f', 'l.fkfac_id = f.fac_id');
    $this->db->join('leavecat_master', 'l.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('faculty_master altf', 'l.fkAlternative_id = altf.fac_id', 'left');
    $this->db->join('flag_master hod_flag', 'hod_flag.flag_value = l.HOD_Approval', 'left');
    $this->db->join('flag_master reg_flag', 'reg_flag.flag_value = l.REG_Approval', 'left');
    $this->db->join('flag_master princ_flag', 'princ_flag.flag_value = l.Princ_Approval', 'left');

    if (!empty($faculty_id)) {
        $this->db->where('l.fkfac_id', $faculty_id);
    }

    if (!empty($branch_id)) {
        $this->db->where('f.fkbranch_id', $branch_id);
    }

    // Filter where leave overlaps with financial year
    $this->db->where('l.Leave_from <=', $end_date);
    $this->db->where('l.Leave_to >=', $start_date);

    $this->db->order_by('l.Leave_from', 'DESC');
    return $this->db->get()->result();
}




public function getLeaveDateRange($faculty_id, $branch_id, $from_date, $to_date)
{
    $this->db->select('l.*, f.fac_Fullname AS faculty_name, altf.fac_Fullname AS alternative_faculty_name, leavecat_master.leave_name,
        hod_flag.flag_name AS hod_status,
        reg_flag.flag_name AS reg_status,
        princ_flag.flag_name AS princ_status,
        hod_flag.color_code AS hod_color,
        princ_flag.color_code AS princ_color,
        reg_flag.color_code AS reg_color');
        
    $this->db->from('leaveapp_master l');
    $this->db->join('faculty_master f', 'l.fkfac_id = f.fac_id');
    $this->db->join('leavecat_master', 'l.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('faculty_master altf', 'l.fkAlternative_id = altf.fac_id', 'left');
    $this->db->join('flag_master hod_flag', 'hod_flag.flag_value = l.HOD_Approval', 'left');
    $this->db->join('flag_master reg_flag', 'reg_flag.flag_value = l.REG_Approval', 'left');
    $this->db->join('flag_master princ_flag', 'princ_flag.flag_value = l.Princ_Approval', 'left');

    if (!empty($faculty_id)) {
        $this->db->where('l.fkfac_id', $faculty_id);
    }

    if (!empty($branch_id)) {
        $this->db->where('f.fkbranch_id', $branch_id);
    }

    
        if (!empty($from_date) && !empty($to_date)) {
        // New logic: any overlap with selected date range
        $this->db->where('l.Leave_from <=', $to_date);
        $this->db->where('l.Leave_to >=', $from_date);
    }
    $this->db->order_by('l.Leave_from', 'DESC');
    return $this->db->get()->result();
}




public function getAllLeaveStatus($fac_id)
{
    $this->db->select("
        abc.leaveCat_id,
        abc.leave_name,
        CASE
            WHEN fy.finiYear_id IS NOT NULL AND fy.Active_Deactive = 1 THEN
                CASE MONTH(f.joining_date)
                    WHEN 1 THEN abc.January
                    WHEN 2 THEN abc.February
                    WHEN 3 THEN abc.March
                    WHEN 4 THEN abc.April
                    WHEN 5 THEN abc.May
                    WHEN 6 THEN abc.June
                    WHEN 7 THEN abc.July
                    WHEN 8 THEN abc.August
                    WHEN 9 THEN abc.September
                    WHEN 10 THEN abc.October
                    WHEN 11 THEN abc.November
                    WHEN 12 THEN abc.December
                END
            ELSE abc.April
        END AS joining_month_value
    ");
    $this->db->from("(SELECT
                        leaveCat_id,
                        leave_name,
                        January,
                        February,
                        March,
                        April,
                        May,
                        June,
                        July,
                        August,
                        September,
                        October,
                        November,
                        December
                     FROM leavecat_master) AS abc");
    $this->db->join('faculty_master f', 'f.fac_id = ' . (int)$fac_id, 'left');
    $this->db->join('finiyear_master fy', 'fy.finiYear_id = f.finicial_Year AND fy.Active_Deactive = 1', 'left');
 
    $leaveCategories = $this->db->get()->result();
 
 
   
    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';
 
 
    $this->db->select('LeaveType, SUM(No_of_days) as total_days');
    $this->db->from('leaveapp_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('HOD_Approval !=', 2);
    $this->db->where('REG_Approval !=', 2);
    $this->db->where('Princ_Approval !=', 2);
    $this->db->where_in('finicial_Year', "($subQuery)", FALSE);
    $this->db->group_by('LeaveType');
    $leaveSums = $this->db->get()->result();
 
    $sums = [];
    foreach ($leaveSums as $row) {
        $sums[$row->LeaveType] = $row->total_days;
    }
 
 
 
    $this->db->select('
        lm.Leave_from,
        lm.Leave_to,
        lm.No_of_days,
        lm.Leave_Reas,
        lm.LeaveType,
        lm.HOD_Approval,
        lm.REG_Approval,
        lm.created_date,
        lm.Princ_Approval,
        lm.ApprovedDays,
        fm.fac_Fullname AS altFaculty
    ');
    $this->db->from('leaveapp_master lm');
    $this->db->join('faculty_master fm', 'lm.fkAlternative_id = fm.fac_id', 'left');
    $this->db->where('lm.fkfac_id', $fac_id);
    $this->db->where_in('lm.finicial_Year', "($subQuery)", FALSE);
    $this->db->order_by('lm.created_date', 'DESC');
 
    $records = $this->db->get()->result();
 
    $recordGrouped = [];
    foreach ($records as $r) {
        $recordGrouped[$r->LeaveType][] = $r;
    }
 
 
 
    $output = [];
    foreach ($leaveCategories as $cat) {
        $cat_id = $cat->leaveCat_id;
        $output[] = [
            'id'      => $cat_id,
            'name'    => $cat->leave_name,
            'max'     => $cat->joining_month_value,
            'used'    => isset($sums[$cat_id]) ? $sums[$cat_id] : 0,
            'records' => isset($recordGrouped[$cat_id]) ? $recordGrouped[$cat_id] : []
        ];
    }
 
    return $output;
}
 
public function getExtraLeaveDays($fac_id)
{
    $this->db->select('fkleaveCat_id, no_of_LeaveDays, Leave_date, LateMark, Lateday');
    $this->db->from('reg_fac_leave_master');
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('is_active', 1);
 
    $subQuery = 'SELECT finiYear_id FROM finiyear_master WHERE Active_Deactive = 1';
    $this->db->where_in('fkfiniYear_id', "($subQuery)", FALSE);
 
    $query = $this->db->get()->result();
 
    $grouped = [];
    foreach ($query as $row) {
        $grouped[$row->fkleaveCat_id][] = $row;
    }
 
    return $grouped;
}

}
