<?php
  class HOD_com_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('studcomp_master',$model);
			//return $sql->result();
	} 

  



public function getComplaintsByDateRange($branch_id, $finiYear_id, $start_date, $end_date)
{
    $this->db->select("
        Stud_name,
        Stud_mailId,
        Stud_mobileNo,
        fkComp_id,
        Comp_Desp,
        complaintcat_master.Comp_name,
        CASE
            WHEN studcomp_master.HOD_Approval = 0 THEN 'HOD Processing'
            WHEN studcomp_master.REG_Approval = 0 THEN 'Registrar Processing'
            WHEN studcomp_master.Princ_Approval = 0 THEN 'Principal Processing'
            ELSE 'Completed'
        END AS status
    ");
    $this->db->from('studcomp_master');
    $this->db->join('complaintcat_master', 'studcomp_master.fkComp_id = complaintcat_master.Comp_id', 'left');
    $this->db->where('fkbranch_id', $branch_id);
    $this->db->where('Financial_Year', $finiYear_id);

    // ✅ Only add date filters if provided
    if (!empty($start_date)) {
        $this->db->where('studcomp_master.created_date >=', $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where('studcomp_master.created_date <=', $end_date);
    }

    $this->db->order_by('studcomp_master.created_date', 'DESC');

    $query = $this->db->get();
    return $query->result();
}




}