<?php
  class HOD_leave_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('studcomp_master',$model);
			//return $sql->result();
	} 

  
public function getAllComplaintsByBranch($branch_id, $finiYear_id, $start_date = null, $end_date = null)
{
    $this->db->select("
        fkfac_id,
        LeaveType,
        No_of_days,
        leaveapp_master.created_date,
        leavecat_master.leave_name,
        faculty_master.fac_Fullname,
        CASE
            WHEN leaveapp_master.HOD_Approval = 0 THEN 'HOD Processing'
            WHEN leaveapp_master.REG_Approval = 0 THEN 'Registrar Processing'
            WHEN leaveapp_master.Princ_Approval = 0 THEN 'Principal Processing'
            ELSE 'Completed'
        END AS status
    ");
    $this->db->from('leaveapp_master');
    $this->db->join('leavecat_master', 'leaveapp_master.LeaveType = leavecat_master.leaveCat_id', 'left');
    $this->db->join('faculty_master', 'leaveapp_master.fkfac_id = faculty_master.fac_id', 'left');
    $this->db->where('faculty_master.fkbranch_id', $branch_id);
    $this->db->where('leaveapp_master.finicial_Year', $finiYear_id);

    if (!empty($start_date)) {
        $this->db->where('leaveapp_master.created_date >=', $start_date);
    }
    if (!empty($end_date)) {
        $this->db->where('leaveapp_master.created_date <=', $end_date);
    }

    $this->db->order_by('leaveapp_master.created_date', 'DESC');
    $query = $this->db->get();
    return $query->result();
}




}