<?php
  class Headmaster_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('activeheads_master',$model);
			//return $sql->result();
	} 

   //   public function getdetailview()
   //   {      
      
   //      $this->db->select('activeheads_master.*,faculty_master.fkbranch_id,institute_master.Institu_name,faculty_master.fkdep_id,designation_master.desig_name,faculty_master.fac_Fullname');
   //      $this->db->from('activeheads_master');
   //      $this->db->join('designation_master','activeheads_master.fkdesig_id = designation_master.desig_id','left');
   //      $this->db->join('faculty_master','activeheads_master.fkfac_id =faculty_master.fac_id','left');
   //      $this->db->join('faculty_master','activeheads_master.fkdep_id =faculty_master.fkdep_id','left');
   //      $this->db->join('faculty_master','activeheads_master.fkbranch_id =faculty_master.fkbranch_id','left');
   //       $this->db->join('institute_master','activeheads_master.fkInstitu_id =institute_master.Institu_id','left');
   //      $this->db->order_by('activeheads_master.active_id','DESC');
   //      $query = $this->db->get();
   //      return $query->result();
             
   //   }

public function getdetailview()
{      
    $this->db->select('
        activeheads_master.*,
        f1.fac_Fullname,
        d.desig_name,
        i.Institu_name,
        dep.dep_name AS department_name,
        br.branch_name AS branch_name
    ');
    $this->db->from('activeheads_master');
    
    // Designation
    $this->db->join('designation_master d', 'activeheads_master.fkdesig_id = d.desig_id', 'left');
    
    // Faculty details
    $this->db->join('faculty_master f1', 'activeheads_master.fkfac_id = f1.fac_id', 'left');
    
    // Department master (based on faculty's fkdep_id)
    $this->db->join('department_master dep', 'f1.fkdep_id = dep.dep_id', 'left');
    
    // Branch master (based on faculty's fkbranch_id)
    $this->db->join('branch_master br', 'f1.fkbranch_id = br.branch_id', 'left');
    
    // Institute
    $this->db->join('institute_master i', 'activeheads_master.fkInstitu_id = i.Institu_id', 'left');

    $this->db->order_by('activeheads_master.active_id','DESC');
    $query = $this->db->get();
    return $query->result();        
}




     public function getmember()
  {      
   
     $this->db->select('designation_master.*');
     $this->db->from('designation_master');
     $query = $this->db->get();
     return $query->result();

          
  }

    public function getFac()
  {      
   
     $this->db->select('faculty_master.*');
     $this->db->from('faculty_master');
     $query = $this->db->get();
     return $query->result();

          
  }

    public function getdepart()
  {      
   
     $this->db->select('faculty_master.*');
     $this->db->from('faculty_master');
     $query = $this->db->get();
     return $query->result();

          
  }

    public function getbranch()
  {      
   
     $this->db->select('faculty_master.*');
     $this->db->from('faculty_master');
     $query = $this->db->get();
     return $query->result();

          
  }

    public function getinstitute()
  {      
   
     $this->db->select('institute_master.*');
     $this->db->from('institute_master');
     $query = $this->db->get();
     return $query->result();

          
  }

  public function getb()
  {      
   
     $this->db->select('branch_master.*');
     $this->db->from('branch_master');
     $query = $this->db->get();
     return $query->result();

          
  }
  public function getd()
  {      
   
     $this->db->select('department_master.*');
     $this->db->from('department_master');
     $query = $this->db->get();
     return $query->result();        
  }


      public function getbyid($id)
		{
		  $this->db->select("activeheads_master.*,");
	    $this->db->where('active_id',$id);
      $query = $this->db->get('activeheads_master');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('active_id',$model['active_id'])->update('activeheads_master',$model); 
    } 


public function getBranchAndDepartmentByFaculty($fac_id)
{
    $this->db->select('
        b.branch_id, b.branch_name,
        d.dep_id, d.dep_name
    ');
    $this->db->from('faculty_master f');
    $this->db->join('branch_master b', 'f.fkbranch_id = b.branch_id', 'left');
    $this->db->join('department_master d', 'f.fkdep_id = d.dep_id', 'left');
    $this->db->where('f.fac_id', $fac_id);
    $query = $this->db->get();
 
    if ($query->num_rows() > 0) {
        return $query->row_array(); // return assoc array
    } else {
        return [];
    }
}

public function checkFacultyExists($fac_id)
{
    $this->db->where('fkfac_id', $fac_id);
    $this->db->where('Active_Deactive', 1); 
    $query = $this->db->get('activeheads_master');
    return $query->num_rows() > 0;
}


// Check if HOD already exists
    public function getActiveHODByBranch($branch_id) {
        $this->db->where('fkbranch_id', $branch_id);
        $this->db->where('fkdesig_id', 1); // HOD designation ID
        $this->db->where('Active_Deactive', 1);
        $query = $this->db->get('activeheads_master');
        return $query->row_array();
    }

    // Deactivate existing HOD for this branch
    public function deactivateHOD($branch_id) {
        $this->db->where('fkbranch_id', $branch_id);
        $this->db->where('fkdesig_id', 1); // HOD designation ID
        $this->db->where('Active_Deactive', 1);
        return $this->db->update('activeheads_master', ['Active_Deactive' => 2]);
    }

public function deactivateHODExcept($branch_id, $exclude_active_id) {
    $this->db->where('fkbranch_id', $branch_id);
    $this->db->where('fkdesig_id', 1); // HOD designation
    $this->db->where('Active_Deactive', 1);
    $this->db->where('active_id !=', $exclude_active_id); // Don't deactivate current record
    return $this->db->update('activeheads_master', ['Active_Deactive' => 2]);
}

}