<?php
class Industrialtran_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    public function insertdata($model)
    {
         $this->db->insert('industrialtrain_master', $model);
         return $this->db->insert_id();
    }
    
    public function insertgallery($model)
    {
        return $this->db->insert('trainerphoto_master', $model);
    }

     public function insertChild($model) {
        return $this->db->insert('industrialtrain_student', $model);
    }

    public function insertFaculty($model) {
    return $this->db->insert('industrialtrain_faculty', $model);
}

    
    public function getdetailview() 
    {
        $this->db->select('industrialtrain_master.*,
                           branch_master.branch_name,
                           company_master.comp_name,
                           internduration_master.duration_type
                       
                          
                         ');
        $this->db->from('industrialtrain_master');
        $this->db->join('branch_master', 'industrialtrain_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('company_master', 'industrialtrain_master.fkcomp_ID = company_master.ID', 'left');
          $this->db->join('internduration_master', 'industrialtrain_master.fkduration_id  = internduration_master.duration_id ', 'left');
          // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->order_by('industrialtrain_master.intrain_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getbranch() 
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getcompany() 
    {
        $this->db->select('ID, comp_name');
        $this->db->from('company_master');
        $query = $this->db->get();
        return $query->result();
    }
    public function getduration() 
    {
        $this->db->select('duration_id, duration_type');
        $this->db->from('internduration_master');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getbyid($id)
    {
        $this->db->select("industrialtrain_master.*");
        $this->db->where('intrain_id', $id);
        $query = $this->db->get('industrialtrain_master');
        return $query->result();
    }
    
    public function update($model)
    {
        return $this->db->where('intrain_id', $model['intrain_id'])->update('industrialtrain_master', $model);
    }
    


    // Delete all images for a VAP record
    public function deleteimagedata($fkintrain_id) 
    {
        return $this->db->where('fkintrain_id', $fkintrain_id)->delete('trainerphoto_master');
    }
    
    // Delete specific photos based on paths
    public function deleteSpecificPhotos($intrain_id, $photo_paths) 
    {
        if (empty($photo_paths) || empty($intrain_id)) return false;
        
        $this->db->where('fkintrain_id', $intrain_id);
        $this->db->where_in('train_photos', $photo_paths);
        return $this->db->delete('trainerphoto_master');
    }
    
    // Insert multiple photos at once
    public function insertMultiplePhotos($intrain_id, $photo_paths) 
    {
        if (empty($photo_paths) || empty($intrain_id)) return false;
        
        $insert_data = [];
        foreach ($photo_paths as $path) {
            $insert_data[] = [
                'fkintrain_id' => $intrain_id,
                'train_photos' => $path
            ];
        }
        
        return $this->db->insert_batch('trainerphoto_master', $insert_data);
    }
    
    // Get selected images for a VAP record
    public function getSelectedimage($intrain_id) 
    {
        if (empty($intrain_id)) return [];
        
        $this->db->select('train_photos');
        $this->db->from('trainerphoto_master');
        $this->db->where('fkintrain_id', $intrain_id);
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return array_column($query->result_array(), 'train_photos');
        }
        
        return [];
    }

    // new code 
 public function getChildByMainId($sub_id) {
        $this->db->select('*');
        $this->db->from('industrialtrain_student');
        $this->db->where('fkintrain_id', $sub_id);
        return $this->db->get()->result();
    }
 
     // Update child record
    public function updateChild($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('industrialtrain_student', $data);
    }
 
    // Delete single child record
    public function deleteChild($id) {
        $this->db->where('id', $id);
        return $this->db->delete('industrialtrain_student');
    }
 
    // Delete child records by main ID (for complete refresh if needed)
    public function deleteChildByMainId($sub_id) {
        $this->db->where('fkintrain_id', $sub_id);
        return $this->db->delete('industrialtrain_student');
    }
 

// new code end 

public function getFacultyByMainId($intrain_id) {
    $this->db->select('*');
    $this->db->from('industrialtrain_faculty');
    $this->db->where('fkintrain_id', $intrain_id);
    return $this->db->get()->result();
}

public function updateFaculty($id, $data) {
    $this->db->where('id', $id);
    return $this->db->update('industrialtrain_faculty', $data);
}

public function deleteFaculty($id) {
    $this->db->where('id', $id);
    return $this->db->delete('industrialtrain_faculty');
}

}