<?php
  class Industry_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('industry_master',$model);
			//return $sql->result();
	} 


 public function getcompany()
     {
      $this->db->select('fk_company');
    $this->db->from('industry_master');
    $this->db->group_by('fk_company');
    // $this->db->order_by('fk_company', 'ASC'); 
    return $this->db->get()->result();
     }

     public function getbranch()
     {
      $this->db->select('branch_master.branch_id,branch_master.branch_name,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
     $this->db->select('institute_master.Institu_id,institute_master.Institu_name,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

    //  public function gettype()
    //  {
    //   $this->db->select('company_type.*,');
    //   $this->db->from('company_type');
    //   $query = $this->db->get();
    //     return $query->result();
    //  }

    //  public function getcat()
    //  {
    //   $this->db->select('company_category.*,');
    //   $this->db->from('company_category');
    //   $query = $this->db->get();
    //     return $query->result();
    //  }


      public function getyear()
     {
     $this->db->select('finiyear_master.finiYear_id,finiyear_master.fini_Label');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getclass()
     {
      $this->db->select('classmaster.class_id,classmaster.classname,');
      $this->db->from('classmaster');
       $query = $this->db->get();
        return $query->result();
     }

 public function getdiv()
     {
      $this->db->select('division_master.div_id,division_master.div_name,');
      $this->db->from('division_master');
       $query = $this->db->get();
        return $query->result();
     }

public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $class_ids = [], $div_ids = [], $company_ids = [])
{
    $this->db->select('
        industry_master.indu_id,
        industry_master.fkbranch_id,
        industry_master.fkclass_id,
        industry_master.fk_company,
        industry_master.fk_div,
        industry_master.fk_sem,
        industry_master.Address,
        industry_master.startdate,
        industry_master.enddate,
        branch_master.branch_name, 
        classmaster.classname, 
        semester_master.Sem_Name,
        division_master.div_name,
        
    ');
    $this->db->from('industry_master');
    $this->db->join('branch_master', 'branch_master.branch_id = industry_master.fkbranch_id', 'left');
    $this->db->join('classmaster', 'industry_master.fkclass_id = classmaster.class_id', 'left');
     $this->db->join('division_master', 'industry_master.fk_div = division_master.div_id', 'left');
                $this->db->join('semester_master', 'industry_master.fk_sem = semester_master.SemID', 'left');
        $this->db->order_by('industry_master.indu_id','ASC');


    $this->db->where('industry_master.Institute', $institute_id);

    if (!empty($branch_ids)) {
        $this->db->where_in('industry_master.fkbranch_id', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

    if (!empty($class_ids)) {
        $this->db->where_in('industry_master.fkclass_id', $class_ids);
    }

   if (!empty($div_ids)) {
    $this->db->where_in('industry_master.fk_div', $div_ids);
}



    
  if (!empty($company_ids)) {
        $this->db->where_in('industry_master.fk_company', $company_ids);
    }


    if (!empty($year_id)) {
    $this->db->where('industry_master.Financial_Year', $year_id);
}


    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

     
// chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(industry_master.indu_id) as count")
        ->from("industry_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industry_master.Financial_Year")
        ->group_by("industry_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("industry_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = industry_master.Financial_Year")
//         ->where("industry_master.Financial_Year", $yearId)
//         ->group_by("industry_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("industry_master.indu_id, industry_master.fk_company, finiyear_master.fini_Label as year,
//     company_master.comp_name,")
//         ->from("industry_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = industry_master.Financial_Year")
//     ->join('company_master', 'company_master.ID = industry_master.fk_company', 'left')
//      ->where("industry_master.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(industry_master.indu_id) as count")
        ->from("industry_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industry_master.Financial_Year")
        ->where("industry_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('industry_master.fkbranch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('industry_master.fkbranch_id', explode(',', $branchIds));
    }
}
  
 
    $this->db->group_by("industry_master.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("industry_master.indu_id, industry_master.fk_company,
                       industry_master.startdate,
                       industry_master.enddate,
                        industry_master.fkbranch_id,
                        industry_master.invite_file,
                       industry_master.approve_file,
                       industry_master.feedback,
                       industry_master.problem_report,
                        industry_master.visit_photo,
    finiyear_master.fini_Label as year,branch_master.branch_name, classmaster.classname, 
        division_master.div_name,")
        ->from("industry_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = industry_master.Financial_Year")
            ->join('branch_master', 'branch_master.branch_id = industry_master.fkbranch_id', 'left')
 ->join('classmaster', 'industry_master.fkclass_id = classmaster.class_id', 'left')
    ->join('division_master', 'industry_master.fk_div = division_master.div_id', 'left')
        ->where("industry_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('industry_master.fkbranch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('industry_master.fkbranch_id', explode(',', $branchIds));
    }
}
    
 
    return $this->db->get()->result_array();
}
 

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(industry_master.indu_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('industry_master', 'branch_master.branch_id = industry_master.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('industry_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    else{
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!is_array($branchIds)) {
        $branchIds = explode(',', $branchIds);
    }

    $this->db->where_in('branch_master.branch_id', $branchIds);
}

    if (!empty($year) && $year != 0) {
        $this->db->where('industry_master.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('industry_master.fk_company,
                       industry_master.indu_id,
                       industry_master.fkbranch_id,
                       industry_master.startdate,
                       industry_master.enddate,
                       industry_master.invite_file,
                       industry_master.approve_file,
                       industry_master.feedback,
                       industry_master.problem_report,
                        industry_master.visit_photo,
                        industry_master.fk_company,
                       branch_master.branch_name,
                        classmaster.classname, 
        division_master.div_name,');
    $this->db->from('industry_master');
    $this->db->join('branch_master', 'branch_master.branch_id = industry_master.fkbranch_id', 'left');
 $this->db->join('classmaster', 'industry_master.fkclass_id = classmaster.class_id', 'left');
     $this->db->join('division_master', 'industry_master.fk_div = division_master.div_id', 'left');
   if (is_array($branch_id)) {
    $this->db->where_in('industry_master.fkbranch_id', $branch_id);
} else {
    $this->db->where('industry_master.fkbranch_id', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('industry_master.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('industry_master.Financial_Year', $year);
    // }

      if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('industry_master.Financial_Year', $year);
    } else {
        $this->db->where('industry_master.Financial_Year', $year);
    }
}



    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("industry_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.indu_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('industry_master sp', 'b.branch_id = sp.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
else{
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.indu_id) as count");
    $this->db->from("industry_master sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fkbranch_id', (array)$branches);
    }
    else{
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fkbranch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}


public function getStudentsByMeetId($fk_induID)
{
    return $this->db->select('student_name, fk_branch, prn_no, fk_class')
                    ->from('industryvisit_student')
                    ->where('fk_induID', $fk_induID)
                    ->get()
                    ->result_array();
}
 
 
 

}