<?php
class InternshipReport_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    public function getInternshipDataFiltered(
       $institu_id, $branch_ids = null, $class_ids = null,
        $cat_ids = null, $company_ids = null, $year = null,
        $start_date = null, $end_date = null
    )
    {
        $this->db->select('
            internshipstud_master.*,
            branch_master.branch_name,
            classmaster.classname AS class_name,
            company_category.category_name,
            company_master.comp_name,
            internshiptype_master.internship_type,
            internduration_master.duration_type,
            finiyear_master.fini_Label
        ');
        $this->db->from('internshipstud_master');
        $this->db->join('branch_master', 'branch_master.branch_id = internshipstud_master.fkbranch_id', 'left');
        $this->db->join('classmaster', 'classmaster.class_id = internshipstud_master.fkclass_id', 'left');
        $this->db->join('company_category', 'company_category.compCat_id = internshipstud_master.fkcompCat_id', 'left');
        $this->db->join('company_master', 'company_master.ID = internshipstud_master.fkcomp_Id', 'left');
        $this->db->join('internshiptype_master', 'internshiptype_master.inter_id = internshipstud_master.fkinter_id', 'left');
        $this->db->join('internduration_master', 'internduration_master.duration_id = internshipstud_master.fkduration_id', 'left');
        $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = internshipstud_master.finicial_Year', 'left');

        $this->db->where('internshipstud_master.institute', $institu_id);

        if (!empty($branch_ids)) {
            $this->db->where_in('internshipstud_master.fkbranch_id', $branch_ids);
        }

        if (!empty($class_ids)) {
            $this->db->where_in('internshipstud_master.fkclass_id', $class_ids);
        }

        if (!empty($cat_ids)) {
            $this->db->where_in('internshipstud_master.fkcompCat_id', $cat_ids);
        }

        if (!empty($company_ids)) {
            $this->db->where_in('internshipstud_master.fkcomp_Id', $company_ids);
        }

        if (!empty($year) && $year != 0) {
            $this->db->where('internshipstud_master.finicial_Year', $year);
        }

        // Date filter
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where('internshipstud_master.start_date >=', $start_date);
            $this->db->where('internshipstud_master.end_date <=', $end_date);
        }

        $this->db->order_by('internshipstud_master.intern_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getcompany()
    {
        $this->db->select('company_master.*');
        $this->db->from('company_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function getinstitu()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function gettype()
    {
        $this->db->select('company_type.*');
        $this->db->from('company_type');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function getcat()
    {
        $this->db->select('company_category.*');
        $this->db->from('company_category');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function getclass()
    {
        $this->db->select('classmaster.*');
        $this->db->from('classmaster');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    } 

    // branch wise year graph new 
    public function getAllYearsData()
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("internshipstud_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = internshipstud_master.finicial_Year")
            ->group_by("internshipstud_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
            ->get()
            ->result_array();
    }
 
    public function getSingleYearData($yearId, $branches = [])
    {
        $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("internshipstud_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = internshipstud_master.finicial_Year")
            ->where("internshipstud_master.finicial_Year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('internshipstud_master.fkbranch_id', (array)$branches);
        }

        $this->db->group_by("internshipstud_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
    }
 
    public function getYearwiseTypes($yearId, $branches = [])
    {
        $this->db->select("internshipstud_master.*,
                          branch_master.branch_name,
                          classmaster.classname AS class_name,
                          company_category.category_name,
                          company_master.comp_name,
                          internshiptype_master.internship_type,
                          internduration_master.duration_type,
                          finiyear_master.fini_Label as year")
            ->from("internshipstud_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = internshipstud_master.finicial_Year", "left")
            ->join("branch_master", "branch_master.branch_id = internshipstud_master.fkbranch_id", "left")
            ->join("classmaster", "classmaster.class_id = internshipstud_master.fkclass_id", "left")
            ->join("company_category", "company_category.compCat_id = internshipstud_master.fkcompCat_id", "left")
            ->join("company_master", "company_master.ID = internshipstud_master.fkcomp_Id", "left")
            ->join("internshiptype_master", "internshiptype_master.inter_id = internshipstud_master.fkinter_id", "left")
            ->join("internduration_master", "internduration_master.duration_id = internshipstud_master.fkduration_id", "left")
            ->where("internshipstud_master.finicial_Year", $yearId);
       
        if (!empty($branches)) {
            $this->db->where_in('internshipstud_master.fkbranch_id', (array)$branches);
        }
        return $this->db->get()->result_array();
    }
 
    // Add these methods to your VAPReport_model class
    public function getBranchwiseCount($institu = null, $branches = [], $year = null, $start_date = null, $end_date = null)
    {
        $this->db->select('branch_master.branch_id,
                           branch_master.branch_name,
                           COUNT(internshipstud_master.intern_id ) as internship_count');
        $this->db->from('branch_master');
        $this->db->join('internshipstud_master', 'branch_master.branch_id = internshipstud_master.fkbranch_id', 'left');
 
        if (!empty($institu)) {
            $this->db->where('internshipstud_master.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('branch_master.branch_id', (array)$branches);
        }
        if (!empty($year) && $year != 0) {
            $this->db->where('internshipstud_master.finicial_Year', $year);
        }
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("internshipstud_master.created_at BETWEEN '$start_date' AND '$end_date'");
        }
 
        $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
        $this->db->order_by('branch_master.branch_name', 'ASC');
 
        return $this->db->get()->result();
    }
 
    public function getBranchDetailsData($branch_id, $institu = null, $year = null, $start_date = null, $end_date = null)
    {
        $this->db->select('internshipstud_master.*,
            branch_master.branch_name,
            classmaster.classname AS class_name,
            company_category.category_name,
            company_master.comp_name,
            internshiptype_master.internship_type,
            internduration_master.duration_type,
            finiyear_master.fini_Label');
        $this->db->from('internshipstud_master');
        $this->db->join('branch_master', 'branch_master.branch_id = internshipstud_master.fkbranch_id', 'left');
        $this->db->join('classmaster', 'classmaster.class_id = internshipstud_master.fkclass_id', 'left');
        $this->db->join('company_category', 'company_category.compCat_id = internshipstud_master.fkcompCat_id', 'left');
        $this->db->join('company_master', 'company_master.ID = internshipstud_master.fkcomp_Id', 'left');
        $this->db->join('internshiptype_master', 'internshiptype_master.inter_id = internshipstud_master.fkinter_id', 'left');
        $this->db->join('internduration_master', 'internduration_master.duration_id = internshipstud_master.fkduration_id', 'left');
        $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = internshipstud_master.finicial_Year', 'left');
 
        if (is_array($branch_id)) {
            $this->db->where_in('internshipstud_master.fkbranch_id', $branch_id);
        } else {
            $this->db->where('internshipstud_master.fkbranch_id', $branch_id);
        }
 
        if (!empty($institu)) {
            $this->db->where('internshipstud_master.institute', $institu);
        }
        if (!empty($year) && $year != 0) {
            $this->db->where('internshipstud_master.finicial_Year', $year);
        }
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("internshipstud_master.created_at BETWEEN '$start_date' AND '$end_date'");
        }
 
        return $this->db->get()->result();
    }
 
    public function getCombinedData($institu = null, $branches = [], $years = [], $start_date = null, $end_date = null)
    {
        $response = [];
 
        // --- 1. Branchwise Count ---
        $this->db->select('b.branch_id, b.branch_name, COUNT(sr.intern_id ) as internship_count');
        $this->db->from('branch_master b');
        $this->db->join('internshipstud_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
 
        if (!empty($institu)) {
            $this->db->where('sr.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('b.branch_id', (array)$branches);
        }
        if (!empty($years)) {
            $this->db->where_in('sr.finicial_Year', (array)$years);
        }
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("sr.created_at BETWEEN '$start_date' AND '$end_date'");
        }
 
        $this->db->group_by('b.branch_id, b.branch_name');
        $this->db->order_by('b.branch_name', 'ASC');
        $response['branchData'] = $this->db->get()->result();
 
        // --- 2. Yearwise Count ---
        $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.intern_id ) as count");
        $this->db->from("internshipstud_master sr");
        $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
 
        if (!empty($institu)) {
            $this->db->where('sr.institute', $institu);  // Fixed case sensitivity
        }
        if (!empty($branches)) {
            $this->db->where_in('sr.fkbranch_id', (array)$branches);
        }
        if (!empty($years)) {
            $this->db->where_in('sr.finicial_Year', (array)$years);
        }
        if (!empty($start_date) && !empty($end_date)) {
            $this->db->where("sr.created_at BETWEEN '$start_date' AND '$end_date'");
        }
 
        $this->db->group_by("fy.finiYear_id, fy.fini_Label");
        $this->db->order_by("fy.finiYear_id", "ASC");
        $response['yearData'] = $this->db->get()->result();
 
        return $response;
    }
}