<?php
class Internship_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // Insert parent data to maininternship_master → return inserted main_id
    public function insertMain($data) {
        $this->db->insert('maininternship_master', $data);
        return $this->db->insert_id();
    }
    
    // Insert child data to internshipstud_master
    public function insertChild($data) {
        return $this->db->insert('internshipstud_master', $data);
    }
    
    // Get methods for dropdowns
    public function getDuration() {
        $this->db->select('duration_id, duration_type');
        $this->db->from('internduration_master');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getIntertype() {
        $this->db->select('inter_id, internship_type');
        $this->db->from('internshiptype_master');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getClass() {
        $this->db->select('class_id, classname');
        $this->db->from('classmaster');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getCompany() {
        $this->db->select('ID, comp_name');
        $this->db->from('company_master');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getCompanyCat() {
        $this->db->select('compCat_id, category_name');
        $this->db->from('company_category');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getBranch() {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getYearData() {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

       public function getActiveYear()
{
    $this->db->select('*');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}


    
    // Get by name methods (for Excel import)
    public function getBranchByName($name) {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $this->db->where('LOWER(branch_name)', strtolower(trim($name)));
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getClassByName($name) {
        $this->db->select('class_id, classname');
        $this->db->from('classmaster');
        $this->db->where('LOWER(classname)', strtolower(trim($name)));
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getCompanyCatByName($name) {
        $this->db->select('compCat_id, category_name');
        $this->db->from('company_category');
        $this->db->where('LOWER(category_name)', strtolower(trim($name)));
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getCompanyByName($name) {
        $this->db->select('ID, comp_name');
        $this->db->from('company_master');
        $this->db->where('LOWER(comp_name)', strtolower(trim($name)));
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getDurationByName($name) {
        $this->db->select('duration_id, duration_type');
        $this->db->from('internduration_master');
        $this->db->where('LOWER(duration_type)', strtolower(trim($name)));
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getIntertypeByName($name) {
        $this->db->select('inter_id, internship_type');
        $this->db->from('internshiptype_master');
        $this->db->where('LOWER(internship_type)', strtolower(trim($name)));
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getYearByLabel($label) {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('LOWER(fini_Label)', strtolower(trim($label)));
        $query = $this->db->get();
        return $query->row();
    }
    
    // Insert methods for new master entries
    public function insertBranch($data) {
        $this->db->insert('branch_master', $data);
        return $this->db->insert_id();
    }
    
    public function insertClass($data) {
        $this->db->insert('classmaster', $data);
        return $this->db->insert_id();
    }
    
    public function insertCompanyCat($data) {
        $this->db->insert('company_category', $data);
        return $this->db->insert_id();
    }
    
    public function insertCompany($data) {
        $this->db->insert('company_master', $data);
        return $this->db->insert_id();
    }
    
    public function insertDuration($data) {
        $this->db->insert('internduration_master', $data);
        return $this->db->insert_id();
    }
    
    public function insertIntertype($data) {
        $this->db->insert('internshiptype_master', $data);
        return $this->db->insert_id();
    }
    
    public function insertYear($data) {
        $this->db->insert('finiyear_master', $data);
        return $this->db->insert_id();
    }
    
   // Other existing methods
    public function getAllInternships() {
        $this->db->select('
        maininternship_master.main_id,
        maininternship_master.excel_file,
        maininternship_master.Common_pdf,
        maininternship_master.finicial_Year,
        finiyear_master.fini_Label
       
        
    ');
        $this->db->from('maininternship_master');
       
    // $this->db->join('branch_master', 'branch_master.branch_id = internshipstud_master.fkbranch_id', 'left');
    // $this->db->join('classmaster', 'classmaster.class_id = internshipstud_master.fkclass_id', 'left');
    // $this->db->join('company_category', 'company_category.compCat_id = internshipstud_master.fkcompCat_id', 'left');
    // $this->db->join('company_master', 'company_master.ID = internshipstud_master.fkcomp_Id', 'left');
    // $this->db->join('internshiptype_master', 'internshiptype_master.inter_id = internshipstud_master.fkinter_id', 'left');
    // $this->db->join('internduration_master', 'internduration_master.duration_id = internshipstud_master.fkduration_id', 'left');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = maininternship_master.finicial_Year');
    $this->db->order_by('maininternship_master.main_id', 'DESC');
   

        $query = $this->db->get();
        return $query->result();
    }
    
    
    
    public function getMainById($id) {
        $this->db->select('*');
        $this->db->from('maininternship_master');
        $this->db->where('main_id', $id);
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getChildByMainId($main_id) {
        $this->db->select('*');
        $this->db->from('internshipstud_master');
        $this->db->where('main_id', $main_id);
        $query = $this->db->get();
        return $query->result();
    }

public function updateMain($main_id, $data) {
    $this->db->where('main_id', $main_id);
    return $this->db->update('maininternship_master', $data);
}

public function deleteChildByMainId($main_id) {
    $this->db->where('main_id', $main_id);
    return $this->db->delete('internshipstud_master');
}


}