<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Library_IN_Out_model extends CI_Model {
    
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Insert batch data
    public function insert_batch($data) 
    {
        if (empty($data)) {
            return false;
        }
        return $this->db->insert_batch('libinout_master', $data);
    }

    // Get all entries for detail view
    public function getdetailview() 
    {
        $this->db->select('
            li.*,
            lm.Name,
            lm.Class,
            lm.Department,
            ld.LibDep_Name
        ');
        $this->db->from('libinout_master li');
        $this->db->join('library_master lm', 'lm.CardNo = li.Cardnumber', 'left');
        $this->db->join('librarydept_master ld', 'ld.Libdep_id = li.fkLibDept_id', 'left');
        $this->db->order_by('li.library_ID', 'DESC');
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->result();
        }
        
        return [];
    }

    // Get student details by card number
    public function getStudentByCard($card_no)
    {
        if (empty($card_no)) {
            return false;
        }

        $this->db->where('CardNo', $card_no);
        $query = $this->db->get('library_master');
        
        if ($query->num_rows() > 0) {
            return $query->row();
        }

        return false;
    }

    // ✅ UPDATED: Check for pending out-time entry for a card number (includes WorkingType)
    public function getPendingEntryByCard($card_no, $date)
    {
        if (empty($card_no)) {
            return false;
        }

        $this->db->select('
            li.*,
            lm.Name,
            lm.Class,
            lm.Department,
            ld.LibDep_Name
        ');
        $this->db->from('libinout_master li');
        $this->db->join('library_master lm', 'lm.CardNo = li.Cardnumber', 'left');
        $this->db->join('librarydept_master ld', 'ld.Libdep_id = li.fkLibDept_id', 'left');
        $this->db->where('li.Cardnumber', $card_no);
        $this->db->where('li.Date', $date);
        $this->db->where('(li.Out_Time IS NULL OR li.Out_Time = "")');
        $this->db->order_by('li.library_ID', 'DESC');
        $this->db->limit(1);
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->row();
        }

        return false;
    }

    // ✅ UPDATED: Get entries by date with all details (includes WorkingType)
    public function getEntriesByDate($date)
    {
        if (empty($date)) {
            return [];
        }

        $this->db->select('
            li.library_ID,
            li.Date,
            li.Cardnumber,
            li.WorkingType,
            li.fkLibDept_id,
            li.In_Time,
            li.Out_Time,
            li.Hours,
            lm.Name,
            lm.Class,
            lm.Department,
            ld.LibDep_Name
        ');
        $this->db->from('libinout_master li');
        $this->db->join('library_master lm', 'lm.CardNo = li.Cardnumber', 'left');
        $this->db->join('librarydept_master ld', 'ld.Libdep_id = li.fkLibDept_id', 'left');
        $this->db->where('li.Date', $date);
        $this->db->order_by('li.library_ID', 'DESC');
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            return $query->result();
        }
        
        return [];
    }

    // Check if entry exists
    public function checkExistingEntry($date, $cardNo, $libDeptId)
    {
        $this->db->where('Date', $date);
        $this->db->where('Cardnumber', $cardNo);
        $this->db->where('fkLibDept_id', $libDeptId);
        $query = $this->db->get('libinout_master');
        
        if ($query->num_rows() > 0) {
            return $query->row();
        }
        
        return false;
    }

    // Update entry (for out-time)
    public function updateEntry($library_ID, $data)
    {
        $this->db->where('library_ID', $library_ID);
        return $this->db->update('libinout_master', $data);
    }

    // Insert single entry
    public function insertEntry($data)
    {
        return $this->db->insert('libinout_master', $data);
    }
    public function searchWorkingTypes($search)
{
    if (empty($search)) {
        return [];
    }

    // Get working types with usage count and last used date
    $this->db->select('
        WorkingType,
        COUNT(*) as usage_count,
        MAX(Date) as last_used,
        MAX(library_ID) as latest_id
    ');
    $this->db->from('libinout_master');
    $this->db->where('WorkingType IS NOT NULL');
    $this->db->where('WorkingType !=', '');
    
    // Search filter
    $this->db->group_start();
    $this->db->like('WorkingType', $search);
    $this->db->group_end();
    
    $this->db->group_by('WorkingType');
    $this->db->order_by('usage_count', 'DESC');
    $this->db->order_by('last_used', 'DESC');
    $this->db->limit(15);
    
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        $results = $query->result_array();
        
        // Add metadata for UI (recent vs frequent)
        $today = date('Y-m-d');
        $lastWeek = date('Y-m-d', strtotime('-7 days'));
        
        foreach ($results as &$row) {
            // Mark as recent if used in last 7 days
            $row['is_recent'] = ($row['last_used'] >= $lastWeek);
            
            // Format last used date
            if ($row['last_used'] == $today) {
                $row['last_used'] = 'Today';
            } else {
                $dateObj = new DateTime($row['last_used']);
                $row['last_used'] = $dateObj->format('d/m/Y');
            }
        }
        
        return $results;
    }
    
    return [];
}

/**
 * Get all unique working types (for initial load or showing all options)
 * 
 * @param int $limit - Number of results to return
 * @return array
 */
public function getAllWorkingTypes($limit = 20)
{
    $this->db->select('
        WorkingType,
        COUNT(*) as usage_count,
        MAX(Date) as last_used
    ');
    $this->db->from('libinout_master');
    $this->db->where('WorkingType IS NOT NULL');
    $this->db->where('WorkingType !=', '');
    $this->db->group_by('WorkingType');
    $this->db->order_by('usage_count', 'DESC');
    $this->db->order_by('last_used', 'DESC');
    $this->db->limit($limit);
    
    $query = $this->db->get();
    
    if ($query->num_rows() > 0) {
        return $query->result_array();
    }
    
    return [];
}
}

?>