<?php
class Library_Report_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // Get all departments (from library_master.Department column)
    public function getBranches()
    {
        $this->db->distinct();
        $this->db->select('Department as branch_name');
        $this->db->from('library_master');
        $this->db->where('Department IS NOT NULL');
        $this->db->where('Department !=', '');
        $this->db->where('is_active', 1);
        $this->db->order_by('Department', 'ASC');
        return $this->db->get()->result();
    }

    // Get all card types
    public function getCards()
    {
        $this->db->select('mainuser_id, mainuser_name');
        $this->db->from('mainuser_master');
        $this->db->order_by('mainuser_name', 'ASC');
        return $this->db->get()->result();
    }

    // Get all library departments (from libinout_master)
    public function getLibDep()
    {
        $this->db->select('Libdep_id, LibDep_Name');
        $this->db->from('librarydept_master');
        // $this->db->where('is_on', 1);
        $this->db->order_by('LibDep_Name', 'ASC');
        return $this->db->get()->result();
    }

    // Get active year
    public function getActiveYear()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    // Get all years
    public function getYears()
    {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        return $this->db->get()->result();
    }
public function getLibraryDataFiltered($branch_ids = null, $card_type_ids = null, $dept_ids = null, $year_ids = null, $start_date = null, $end_date = null)
{
    // Modified to show each library department record separately
    $this->db->select('
        lm.Lib_Id,
        lm.CardNo as card_number,
        lm.Name as student_name,
        lm.Class,
        lm.Department as branch_name,
        lm.Date,
        lm.ContactNO,
        mu.mainuser_name as card_type,
        fm.fini_Label as year_label,
        ldm.LibDep_Name,
        lio.Date as latest_library_date,
        lio.In_Time,
        lio.Out_Time,
        lio.Hours
    ', FALSE);
    
    $this->db->from('library_master lm');
    $this->db->join('mainuser_master mu', 'mu.mainuser_id = lm.fkCardType', 'left');
    $this->db->join('finiyear_master fm', 'fm.finiYear_id = lm.FiniYear', 'left');
    $this->db->join('libinout_master lio', 'lio.Cardnumber = lm.CardNo AND lio.is_active = 1', 'left');
    $this->db->join('librarydept_master ldm', 'ldm.Libdep_id = lio.fkLibDept_id', 'left');
    
    $this->db->where('lm.is_active', 1);
    
    if (!empty($branch_ids) && is_array($branch_ids)) {
        $this->db->where_in('lm.Department', $branch_ids);
    }
    
    if (!empty($card_type_ids) && is_array($card_type_ids)) {
        $this->db->where_in('lm.fkCardType', $card_type_ids);
    }
    
    if (!empty($dept_ids) && is_array($dept_ids)) {
        $this->db->group_start();
        foreach ($dept_ids as $dept_id) {
            $this->db->or_where('lio.fkLibDept_id', $dept_id);
        }
        $this->db->group_end();
    }
    
    if (!empty($year_ids) && is_array($year_ids)) {
        $this->db->where_in('lm.FiniYear', $year_ids);
    }
    
    if (!empty($start_date) && !empty($end_date)) {
        $this->db->where('lio.Date >=', $start_date);
        $this->db->where('lio.Date <=', $end_date);
    } elseif (!empty($start_date)) {
        $this->db->where('lio.Date >=', $start_date);
    } elseif (!empty($end_date)) {
        $this->db->where('lio.Date <=', $end_date);
    }
    
    // Removed GROUP BY - now each library department will show separately
    $this->db->order_by('lm.Name', 'ASC');
    $this->db->order_by('lio.Date', 'DESC');
    
    $query = $this->db->get();
    log_message('debug', 'Library Filter Query: ' . $this->db->last_query());
    
    return $query->result();
}
    // Get departmentwise count with filters (using Department column)
    // Verify this method applies BOTH branch AND year filters
public function getBranchwiseCount($branches = [], $years = [])
{
    $this->db->select('
        lm.Department as dept_name,
        COUNT(DISTINCT lm.Lib_Id) as library_count
    ');
    $this->db->from('library_master lm');
    
    // Filter by branches/departments
    if (!empty($branches) && is_array($branches)) {
        $this->db->where_in('lm.Department', $branches);
    }
    
    // CRITICAL: Filter by years - this must be applied!
    if (!empty($years) && is_array($years)) {
        $this->db->where_in('lm.FiniYear', $years);
    }
    
    $this->db->where('lm.is_active', 1);
    $this->db->where('lm.Department IS NOT NULL');
    $this->db->where('lm.Department !=', '');
    $this->db->group_by('lm.Department');
    $this->db->having('COUNT(DISTINCT lm.Lib_Id) >', 0);
    $this->db->order_by('lm.Department', 'ASC');
    
    // Debug: Log the query
    log_message('debug', 'getBranchwiseCount Query: ' . $this->db->get_compiled_select('', FALSE));
    
    return $this->db->get()->result();
}
// Get yearwise count with filters
public function getYearwiseCount($branches = [], $years = [])
{
    $this->db->select('
        fm.finiYear_id as year_id,
        fm.fini_Label as year,
        COUNT(lm.Lib_Id) as count
    ');
    $this->db->from('finiyear_master fm');
    $this->db->join('library_master lm', 'fm.finiYear_id = lm.FiniYear AND lm.is_active = 1', 'left');
    
    // FIX: Apply branch/department filter
    if (!empty($branches) && is_array($branches)) {
        $this->db->where_in('lm.Department', $branches);
    }
    
    if (!empty($years) && is_array($years)) {
        $this->db->where_in('fm.finiYear_id', $years);
    }
    
    $this->db->group_by('fm.finiYear_id, fm.fini_Label');
    $this->db->having('COUNT(lm.Lib_Id) >', 0);
    $this->db->order_by('fm.finiYear_id', 'ASC');
    
    return $this->db->get()->result();
}
    // Get combined chart data
    public function getCombinedData($branches = [], $years = [])
    {
        return [
            'branchData' => $this->getBranchwiseCount($branches, $years),
            'yearData' => $this->getYearwiseCount($branches, $years)
        ];
    }

public function getBranchDetailsData($branch_id, $years = [])
{
    $this->db->select('
        lm.Lib_Id,
        lm.CardNo,
        lm.Name as student_name,
        lm.Class,
        lm.Department,
        mu.mainuser_name as card_type,
        fm.fini_Label as year_label,
        (SELECT lio2.In_Time 
         FROM libinout_master lio2 
         WHERE lio2.Cardnumber = lm.CardNo 
         AND lio2.is_active = 1 
         ORDER BY lio2.Date DESC, lio2.library_ID DESC 
         LIMIT 1) as In_Time,
        (SELECT lio3.Out_Time 
         FROM libinout_master lio3 
         WHERE lio3.Cardnumber = lm.CardNo 
         AND lio3.is_active = 1 
         ORDER BY lio3.Date DESC, lio3.library_ID DESC 
         LIMIT 1) as Out_Time,
        (SELECT lio4.Hours 
         FROM libinout_master lio4 
         WHERE lio4.Cardnumber = lm.CardNo 
         AND lio4.is_active = 1 
         ORDER BY lio4.Date DESC, lio4.library_ID DESC 
         LIMIT 1) as Hours
    ', FALSE);
    
    $this->db->from('library_master lm');
    $this->db->join('mainuser_master mu', 'mu.mainuser_id = lm.fkCardType', 'left');
    $this->db->join('finiyear_master fm', 'fm.finiYear_id = lm.FiniYear', 'left');
    
    if (is_array($branch_id)) {
        $this->db->where_in('lm.Department', $branch_id);
    } else {
        $this->db->where('lm.Department', $branch_id);
    }
    
    if (!empty($years) && is_array($years)) {
        $this->db->where_in('lm.FiniYear', $years);
    }
    
    $this->db->where('lm.is_active', 1);
    $this->db->order_by('lm.Name', 'ASC');
    
    log_message('debug', 'getBranchDetailsData Query: ' . $this->db->get_compiled_select('', FALSE));
    
    return $this->db->get()->result();
}
public function getYearDetailsData($year_id, $branches = [])
{
    $this->db->select('
        lm.Lib_Id,
        lm.CardNo,
        lm.Name as student_name,
        lm.Class,
        lm.Department,
        mu.mainuser_name as card_type,
        fm.fini_Label as year_label,
        (SELECT lio2.In_Time 
         FROM libinout_master lio2 
         WHERE lio2.Cardnumber = lm.CardNo 
         AND lio2.is_active = 1 
         ORDER BY lio2.Date DESC, lio2.library_ID DESC 
         LIMIT 1) as In_Time,
        (SELECT lio3.Out_Time 
         FROM libinout_master lio3 
         WHERE lio3.Cardnumber = lm.CardNo 
         AND lio3.is_active = 1 
         ORDER BY lio3.Date DESC, lio3.library_ID DESC 
         LIMIT 1) as Out_Time,
        (SELECT lio4.Hours 
         FROM libinout_master lio4 
         WHERE lio4.Cardnumber = lm.CardNo 
         AND lio4.is_active = 1 
         ORDER BY lio4.Date DESC, lio4.library_ID DESC 
         LIMIT 1) as Hours
    ', FALSE);
    
    $this->db->from('library_master lm');
    $this->db->join('mainuser_master mu', 'mu.mainuser_id = lm.fkCardType', 'left');
    $this->db->join('finiyear_master fm', 'fm.finiYear_id = lm.FiniYear', 'left');
    
    if (is_array($year_id)) {
        $this->db->where_in('lm.FiniYear', $year_id);
    } else {
        $this->db->where('lm.FiniYear', $year_id);
    }
    
    if (!empty($branches) && is_array($branches)) {
        $this->db->where_in('lm.Department', $branches);
    }
    
    $this->db->where('lm.is_active', 1);
    $this->db->order_by('lm.Name', 'ASC');
    
    return $this->db->get()->result();
}
    // Get print headings
    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}