<?php
  class MaintanceReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  

      public function getFilteredData($institu, $branches = [], $maintype = [], $mainsubtype = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('maintance_master.Maintance_id,
                       maintance_master.fkbranch_id,
                       branch_master.branch_name,
                       maintance_master.fkMainsub_id,
                       maintance_subtype_master.Mainsub_name,
                       maintance_master.fkMaintype_id,
                       maintance_type_master.Maintype_name,
                        maintance_master.Maintance_date,
                       maintance_master.person_name,
                       maintance_master.person_contact,    
                       maintance_master.Maintance_details,
                        maintance_master.Photo_url,     
                        maintance_master.Document,  
                       maintance_master.finicial_Year,
                       finiyear_master.fini_Label');
    $this->db->from('maintance_master');
    $this->db->join('branch_master', 'maintance_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('maintance_subtype_master', 'maintance_master.fkMainsub_id = maintance_subtype_master.Mainsub_id ', 'left');
     $this->db->join('maintance_type_master', 'maintance_master.fkMaintype_id = maintance_type_master.Maintype_id ', 'left');
    $this->db->join('finiyear_master', 'maintance_master.finicial_Year = finiyear_master.finiYear_id', 'left');

    // Institute filter
    if (!empty($institu)) {
        $this->db->where('maintance_master.institute', $institu);
    }

    // Branch filter
    if (!empty($branches) && is_array($branches) && count($branches) > 0) {
        $this->db->where_in('maintance_master.fkbranch_id', $branches);
    }

    // Maintenance type filter
    if (!empty($maintype) && is_array($maintype) && count($maintype) > 0) {
        $this->db->where_in('maintance_master.fkMaintype_id', $maintype);
    }

    // Maintenance subtype filter ✅ Added this
    if (!empty($mainsubtype) && is_array($mainsubtype) && count($mainsubtype) > 0) {
        $this->db->where_in('maintance_master.fkMainsub_id', $mainsubtype);
    }

    // Year filter
    if (!empty($year) && $year != 0 && $year != '0') {
        $this->db->where('maintance_master.finicial_Year', $year);
    }

    // Date range filter
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("DATE(maintance_master.Maintance_date) BETWEEN '$startDate' AND '$endDate'");
    } elseif (!empty($startDate)) {
        $this->db->where("DATE(maintance_master.Maintance_date) >=", $startDate);
    } elseif (!empty($endDate)) {
        $this->db->where("DATE(maintance_master.Maintance_date) <=", $endDate);
    }

    $this->db->order_by('maintance_master.Maintance_id', 'DESC');
    
    return $this->db->get()->result();
}
  
 
   
     public function getbranch()
     {
      $this->db->select('branch_id, branch_name');
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }
 
     public function getMaintypetype() 
    {
        $this->db->select('Maintype_id, Maintype_name');
        $this->db->from('maintance_type_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    public function getMaintypesubtype() 
    {
        $this->db->select('Mainsub_id , Mainsub_name');
        $this->db->from('maintance_subtype_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    
      public function getyear()
     {
      $this->db->select('finiYear_id, fini_Label');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
       public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }
 
   
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
} 
   




public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(maintance_master.Maintance_id) as count")
        ->from("maintance_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = maintance_master.finicial_Year")
        ->group_by("maintance_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(maintance_master.Maintance_id) as count")
        ->from("maintance_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = maintance_master.finicial_Year")
        ->where("maintance_master.finicial_Year", $yearId);

        if (!empty($branches)) {
                $this->db->where_in('maintance_master.fkbranch_id', (array)$branches);
            }

        $this->db->group_by("maintance_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
}
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("maintance_master.Maintance_id,
                       maintance_master.fkbranch_id,
                       branch_master.branch_name,
                       maintance_master.fkMaintype_id,
                       maintance_type_master.Maintype_name,
                       maintance_master.fkMainsub_id,
                       maintance_subtype_master.Mainsub_name,
                       maintance_master.Maintance_date,
                       maintance_master.person_name,
                       maintance_master.person_contact,
                       maintance_master.Maintance_details,
                       maintance_master.Photo_url,    
                       maintance_master.Document,
                        maintance_master.finicial_Year,        
                       finiyear_master.fini_Label as year")
        ->from("maintance_master")
        
    ->join('branch_master', 'maintance_master.fkbranch_id = branch_master.branch_id', 'left')
   ->join('maintance_type_master', 'maintance_master.fkMaintype_id = maintance_type_master.Maintype_id', 'left')
    ->join('maintance_subtype_master', 'maintance_master.fkMainsub_id = maintance_subtype_master.Mainsub_id', 'left')
    ->join('finiyear_master', 'maintance_master.finicial_Year = finiyear_master.finiYear_id', 'left')

        ->where("maintance_master.finicial_Year", $yearId);

        
    if (!empty($branches)) {
        $this->db->where_in('maintance_master.fkbranch_id', (array)$branches);
       }
        return $this->db->get()->result_array();
}
 
 

 


  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(maintance_master.Maintance_id) as Maint_count');
    $this->db->from('branch_master');
    $this->db->join('maintance_master', 'branch_master.branch_id = maintance_master.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('maintance_master.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('maintance_master.finicial_Year', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("maintance_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('maintance_master.Maintance_id,
                       maintance_master.fkbranch_id,
                       branch_master.branch_name,
                        maintance_master.fkMaintype_id,
                       maintance_type_master.Maintype_name,
                       maintance_master.fkMainsub_id,
                       maintance_subtype_master.Mainsub_name,
                       maintance_master.Maintance_date,
                       maintance_master.person_name,    
                       maintance_master.person_contact,
                       maintance_master.Maintance_details,
                        maintance_master.Photo_url,
                         maintance_master.Document,
                         maintance_master.finicial_Year,
                       finiyear_master.fini_Label'); // ✅ ADD THIS LINE
    $this->db->from('maintance_master');
    $this->db->join('branch_master', 'maintance_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('maintance_type_master', 'maintance_master.fkMaintype_id = maintance_type_master.Maintype_id', 'left');
      $this->db->join('maintance_subtype_master', 'maintance_master.fkMainsub_id = maintance_subtype_master.Mainsub_id', 'left');
    $this->db->join('finiyear_master', 'maintance_master.finicial_Year = finiyear_master.finiYear_id', 'left'); // ✅ ADD THIS JOIN
    
    if (is_array($branch_id)) {
        $this->db->where_in('maintance_master.fkbranch_id', $branch_id);
    } else {
        $this->db->where('maintance_master.fkbranch_id', $branch_id);
    }
 
    if (!empty($institu)) {
        $this->db->where('maintance_master.institute', $institu);
    }

    if (!empty($year)) {
        if (is_array($year)) {
            $this->db->where_in('maintance_master.finicial_Year', $year);
        } else {
            $this->db->where('maintance_master.finicial_Year', $year);
        }
    }
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("maintance_master.Maintance_date BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}

 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.Maintance_id) as Maint_count');
    $this->db->from('branch_master b');
    $this->db->join('maintance_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sr.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.Maintance_id) as count");
    $this->db->from("maintance_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sr.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkbranch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
   


}