<?php
class Maintance_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
  
    public function insertdata($model)
    {
        return $this->db->insert('maintance_master', $model);
    } 

    public function getdetailview()
    {      
        $this->db->select('maintance_master.*,
                          branch_master.branch_name,
                          maintance_type_master.Maintype_name,
                          maintance_subtype_master.Mainsub_name');
        
        $this->db->from('maintance_master');
        $this->db->join('branch_master', 'maintance_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('maintance_type_master', 'maintance_master.fkMaintype_id = maintance_type_master.Maintype_id', 'left');
        $this->db->join('maintance_subtype_master', 'maintance_master.fkMainsub_id = maintance_subtype_master.Mainsub_id', 'left');
        $this->db->where('maintance_master.is_active', 1);
        $this->db->order_by('maintance_master.Maintance_id', 'DESC');
        
        $query = $this->db->get();
        return $query->result();      
    }

    public function getbyid($id)
    {
        $this->db->select('maintance_master.*,
                          branch_master.branch_name,
                          maintance_type_master.Maintype_name,
                          maintance_subtype_master.Mainsub_name');
        
        $this->db->from('maintance_master');
        $this->db->join('branch_master', 'maintance_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('maintance_type_master', 'maintance_master.fkMaintype_id = maintance_type_master.Maintype_id', 'left');
        $this->db->join('maintance_subtype_master', 'maintance_master.fkMainsub_id = maintance_subtype_master.Mainsub_id', 'left');
        $this->db->where('Maintance_id', $id);
        
        $query = $this->db->get();
        return $query->result();
    }
    
    public function update($model)
    {
        return $this->db->where('Maintance_id', $model['Maintance_id'])->update('maintance_master', $model); 
    }

    public function getBranches()
    {
        $this->db->select('*');
        $this->db->from('branch_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Search Maintenance Type
    public function searchMaintenanceType($query)
    {
        $this->db->select('Maintype_id, Maintype_name');
        $this->db->from('maintance_type_master');
        $this->db->like('Maintype_name', $query);
        $this->db->where('is_active', 1);
        $this->db->order_by('Maintype_name', 'ASC');
        $this->db->limit(10);
        
        $result = $this->db->get();
        return $result->result();
    }

    // Search Maintenance Sub Type
    public function searchMaintenanceSubType($query)
    {
        $this->db->select('Mainsub_id, Mainsub_name');
        $this->db->from('maintance_subtype_master');
        $this->db->like('Mainsub_name', $query);
        $this->db->where('is_active', 1);
        $this->db->order_by('Mainsub_name', 'ASC');
        $this->db->limit(10);
        
        $result = $this->db->get();
        return $result->result();
    }

    // Check if Maintenance Type exists
    public function checkMaintenanceTypeExists($name)
    {
        $this->db->select('Maintype_id');
        $this->db->from('maintance_type_master');
        $this->db->where('LOWER(Maintype_name)', strtolower($name));
        $this->db->where('is_active', 1);
        
        $query = $this->db->get();
        return $query->num_rows() > 0;
    }

    // Check if Maintenance Sub Type exists
    public function checkMaintenanceSubTypeExists($name)
    {
        $this->db->select('Mainsub_id');
        $this->db->from('maintance_subtype_master');
        $this->db->where('LOWER(Mainsub_name)', strtolower($name));
        $this->db->where('is_active', 1);
        
        $query = $this->db->get();
        return $query->num_rows() > 0;
    }

    // Add new Maintenance Type
    public function addMaintenanceType($data)
    {
        $this->db->insert('maintance_type_master', $data);
        return $this->db->insert_id();
    }

    // Add new Maintenance Sub Type
    public function addMaintenanceSubType($data)
    {
        $this->db->insert('maintance_subtype_master', $data);
        return $this->db->insert_id();
    }
}