<?php
  class Mega_participation_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		 $this->db->insert('mega_participation',$model);
			return $this->db->insert_id();
	} 

      public function insertChild($model)
	{
		return $this->db->insert('audit_member',$model);
			//return $sql->result();
	} 


     public function getdetailview()
     {      
      
        $this->db->select('mega_participation.*,branch_master.branch_name,rank_master.rank_name,
        level_master.leval_name,finiyear_master.fini_Label,master_one.project_title,master_two.group_no,');
        $this->db->from('mega_participation');
       $this->db->join('rank_master', 'mega_participation.fk_rank = rank_master.rank_id', 'left');
    $this->db->join('branch_master', 'mega_participation.fk_branch = branch_master.branch_id', 'left');
        $this->db->join('finiyear_master', 'mega_participation.Financial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->join('level_master', 'mega_participation.fk_level = level_master.level_id', 'left');
        $this->db->join('miniproject_master as master_one', 'mega_participation.fk_projectitle = master_one.project_id', 'left');
        $this->db->join('miniproject_master as master_two', 'mega_participation.fk_groupno = master_two.project_id', 'left');
         // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->order_by('mega_participation.part_id','DESC');
        $query = $this->db->get();
        return $query->result();
             
     }

public function getlevel()
     {
      $this->db->select('level_master.level_id,level_master.leval_name');
      $this->db->from('level_master');
       $query = $this->db->get();
        return $query->result();
     }


     public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getActiveYear()
{
    $this->db->select('*');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}

public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     


      public function getproject()
     {
      $this->db->select('miniproject_master.project_id,miniproject_master.project_title,');
      $this->db->from('miniproject_master');
      $this->db->group_by('miniproject_master.project_title');
       $query = $this->db->get();
        return $query->result();
     }

public function getgroup()
     {
      $this->db->select('miniproject_master.project_id,miniproject_master.group_no,');
      $this->db->from('miniproject_master');
      $this->db->group_by('miniproject_master.group_no');
       $query = $this->db->get();
        return $query->result();
     }


     public function getrank()
     {
      $this->db->select('rank_master.rank_id,rank_master.rank_name,');
      $this->db->from('rank_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getbyid($id)
		{
		  $this->db->select("mega_participation.*,");
	    $this->db->where('part_id',$id);
      $query = $this->db->get('mega_participation');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('part_id',$model['part_id'])->update('mega_participation',$model); 
    } 



  public function getProjectsByGroupNo($filters = [])
{
    $group_no_text = null;
    $project_title_text = null;
    
    // ✅ Step 1: Agar group dropdown se select kiya hai
    if (!empty($filters['group_id'])) {
        $group_data = $this->db->select('group_no')
                               ->where('project_id', $filters['group_id'])
                               ->get('miniproject_master')
                               ->row();
        
        if ($group_data) {
            $group_no_text = $group_data->group_no;
        }
    }
    
    // ✅ Step 2: Agar project title dropdown se select kiya hai
    if (!empty($filters['project_id'])) {
        $project_data = $this->db->select('project_title')
                                 ->where('project_id', $filters['project_id'])
                                 ->get('miniproject_master')
                                 ->row();
        
        if ($project_data) {
            $project_title_text = $project_data->project_title;
        }
    }
    
    // ✅ Step 3: Main query - miniproject_master se students fetch karo
    $this->db->select('mp.*, 
                      mp.student_name as student_name_text,
                      mp.roll_no,
                      mp.prn,
                      mp.group_no,
                      cm.classname as class_name,
                      dm.div_name as division_name,
                      tm.type_name as sponsorship_name,
                      rm.rank_name,
                      mp.project_title,
                      mp.guide_name');
    
    $this->db->from('miniproject_master as mp');
    $this->db->join('classmaster as cm', 'mp.class = cm.class_id', 'left');
    $this->db->join('division_master as dm', 'mp.division = dm.div_id', 'left');
    $this->db->join('type_master as tm', 'mp.fk_sponser = tm.type_id', 'left');
    $this->db->join('rank_master as rm', 'mp.rank = rm.rank_id', 'left');
    
    // ✅ Mandatory filters
    if (!empty($filters['branch_id'])) {
        $this->db->where('mp.fkBranch_id', $filters['branch_id']);
    }
    
    if (!empty($filters['year'])) {
        $this->db->where('mp.FiniYear', $filters['year']);
    }
    
    // ✅ Optional filters - project title se
    if (!empty($project_title_text)) {
        $this->db->where('mp.project_title', $project_title_text);
    }
    
    // ✅ Optional filters - group no se
    if (!empty($group_no_text)) {
        $this->db->where('mp.group_no', $group_no_text);
    }
    
    $result = $this->db->get()->result();
    
    // ✅ Debug logs
    log_message('debug', '=== Filter Debug ===');
    log_message('debug', 'Input Filters: ' . json_encode($filters));
    log_message('debug', 'Resolved Project Title: ' . ($project_title_text ?? 'NULL'));
    log_message('debug', 'Resolved Group No: ' . ($group_no_text ?? 'NULL'));
    log_message('debug', 'SQL Query: ' . $this->db->last_query());
    log_message('debug', 'Result Count: ' . count($result));
    log_message('debug', '==================');
    
    return $result;
}

// public function getProjectsByGroupNo($selected_project_id, $branch_id, $year)
// {
//     // Option 1: Agar dropdown me project_id hai (current scenario)
//     // To pehle project_master se group_no text nikalo
//     $this->db->select('group_no');
//     $this->db->from('miniproject_master');
//     $this->db->where('project_id', $selected_project_id);
//     $project = $this->db->get()->row();
    
//     if (!$project) {
//         return [];
//     }
    
//     $group_no_text = $project->group_no;
    
//     // Ab miniproject_master se us group_no ke students fetch karo
//     $this->db->select('mp.*, 
//                       mp.student_name as student_name_text,
//                       mp.roll_no,
//                       mp.prn,
//                       cm.classname as class_name,
//                       dm.div_name as division_name,
//                       tm.type_name as sponsorship_name,
//                       rm.rank_name,
//                       mp.project_title,
//                       mp.guide_name,
//                       mpp.fk_groupno');
    
//     $this->db->from('miniproject_master as mp');
//     $this->db->join('classmaster as cm', 'mp.class = cm.class_id', 'left');
//     $this->db->join('division_master as dm', 'mp.division = dm.div_id', 'left');
//     $this->db->join('type_master as tm', 'mp.fk_sponser = tm.type_id', 'left');
//     $this->db->join('rank_master as rm', 'mp.rank = rm.rank_id', 'left');
//     $this->db->join('mega_participation as mpp', 'mpp.fk_groupno = mp.project_id', 'left');
//     $this->db->where('mp.group_no', $group_no_text);
//     $this->db->where('mp.fkBranch_id', $branch_id);
//     $this->db->where('mp.FiniYear', $year);
    
//     return $this->db->get()->result();
// }

}