<?php
if(!defined('BASEPATH')) exit('No direct script access allowed');

class MenuLogin_model extends CI_Model 
{
    public function __construct()
    {
        parent::__construct();
    } 
    
    /**
     * Check user login credentials
     * @param string $userName
     * @param string $password
     * @return array|false Returns user data if found, false otherwise
     */
public function can_login($userName, $password)
{
    // ✅ Specific columns select karo instead of *
    $this->db->select('user_master.*');
    $this->db->from('user_master');
    $this->db->where('UserName', $userName);
    $this->db->where('Password', $password);
    $this->db->where('is_active', 1);
    
    $query = $this->db->get();
    if($query->num_rows() > 0)
    {
        return $query->result();
    }
    else
    {
        return false;
    }
}
    
    /**
     * Get all heading data including logo and slider images
     * @param int $id
     * @return object
     */
    public function get_heading_data($id = 1)
{
    // subHead4 column add kiya gaya hai
    $this->db->select('head, subHead2, subHead3, subHead4, subhead5, logo, slider_img1, slider_img2, slider_img3, erpText');
    $this->db->from('heading_master');
    $this->db->where('ID', $id);
    $this->db->where('is_active', 1);
    $query = $this->db->get();
    return $query->row();
}
    
    /**
     * Get slider images as array
     * @param int $id
     * @return array
     */
    public function get_slider_images($id = 1)
    {
        $this->db->select('slider_img1, slider_img2, slider_img3');
        $this->db->from('heading_master');
        $this->db->where('ID', $id);
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        
        $result = $query->row();
        $images = [];
        
        if($result) {
            if(!empty($result->slider_img1)) $images[] = $result->slider_img1;
            if(!empty($result->slider_img2)) $images[] = $result->slider_img2;
            if(!empty($result->slider_img3)) $images[] = $result->slider_img3;
        }
        
        return $images;
    }
    
    /**
     * Insert forgot password request
     * @param array $model
     * @return bool
     */
    public function insert($model)
    {
        return $this->db->insert('forgotpassword', $model);
    }  
    
    /**
     * Get user by recovery email for forgot password
     * @param string $recoveryEmail
     * @return array
     */
    public function forgotpassword($recoveryEmail)
    {
        $this->db->select('UserName, Password');
        $this->db->from('user_master');
        $this->db->where('RecoveryMail_ID', $recoveryEmail);
        $this->db->where('is_active', 1);
        
        $query = $this->db->get();
        return $query->result_array(); 
    } 
}
?>