<?php
if( ! defined('BASEPATH')) exit('No direct script access allowed');

class MenuLogin_model extends CI_Model 
{
	public function __construct()
	{
		parent::__construct();
	} 

	/**
	 * Check user login credentials
	 * @param string $userName
	 * @param string $password
	 * @return array|false Returns user data if found, false otherwise
	 */
	public function can_login($userName, $password)
	{
		$this->db->select('user_master.*');
		$this->db->from('user_master');
		$this->db->where('UserName', $userName);  // Matching database field name
		$this->db->where('Password', $password);   // Matching database field name
		$this->db->where('is_active', 1);          // Only allow active users
		
		$query = $this->db->get();

		if($query->num_rows() > 0)
		{
			return $query->result();
		}
		else
		{
			return false;
		}
	}

	/**
	 * Insert forgot password request
	 * @param array $model
	 * @return bool
	 */
	public function insert($model)
	{
		return $this->db->insert('forgotpassword', $model);
	}  

	/**
	 * Get user by recovery email for forgot password
	 * @param string $recoveryEmail
	 * @return array
	 */
	public function forgotpassword($recoveryEmail)
	{
		$this->db->select('UserName, Password');
		$this->db->from('user_master');
		$this->db->where('RecoveryMail_ID', $recoveryEmail);
		$this->db->where('is_active', 1);
		
		$query = $this->db->get();
		return $query->result_array(); 
	} 
}
?>