<?php
class NPTL_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function insertMainData($data)
    {
        $this->db->insert('nptl_main_master', $data);
        return $this->db->insert_id();
    }

    public function insertChildData($data)
    {
        return $this->db->insert('nptl_master', $data);
    }

    public function updateMainData($id, $data)
    {
        $this->db->where('nptlmain_id', $id);
        return $this->db->update('nptl_main_master', $data);
    }

    public function updateChildData($id, $data)
    {
        $this->db->where('NPTL_id', $id);
        return $this->db->update('nptl_master', $data);
    }

    public function getMainById($id)
    {
        $this->db->where('nptlmain_id', $id);
        $query = $this->db->get('nptl_main_master');
        return $query->result();
    }

    public function getChildByMainId($id)
    {
        $this->db->where('fknptlmain_id', $id);
        $query = $this->db->get('nptl_master');
        return $query->result();
    }

    public function getdetailview()
    {
        $this->db->select('nptl_main_master.*, 
                          GROUP_CONCAT(DISTINCT nptl_master.Course_name SEPARATOR ", ") as courses');
        $this->db->from('nptl_main_master');
        $this->db->join('nptl_master', 'nptl_main_master.nptlmain_id = nptl_master.fknptlmain_id', 'left');
        $this->db->group_by('nptl_main_master.nptlmain_id');
        $this->db->order_by('nptl_main_master.nptlmain_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getduration()
    {
        $this->db->select('duration_id, duration_type');
        $this->db->from('internduration_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getActiveYear()
{
    $this->db->select('*');
    $this->db->from('finiyear_master');
    $this->db->where('Active_Deactive', 1);
    return $this->db->get()->row(); // returns single active year
}
}
?>