<?php
  class NSS_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
public function insert_batch($data) {
    return $this->db->insert_batch('nss_master', $data);
}


 public function getdetailview()
     {      
      
        $this->db->select('nss_master.*,');
        $this->db->from('nss_master');
        $this->db->order_by('nss_master.NssAct_ID','DESC');
        $query = $this->db->get();
        return $query->result();
             
     }


      public function getbyid($id)
		{
		  $this->db->select("nss_master.*,");
	    $this->db->where('NssAct_ID',$id);
      $query = $this->db->get('nss_master');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('NssAct_ID',$model['NssAct_ID'])->update('nss_master',$model); 
    } 

// public function getDistinctDepartments()
// {
//     $this->db->select('Department');
//     $this->db->from('nss_master');
//     $this->db->group_by('Department');
//     $this->db->order_by('Department', 'ASC'); // optional sorting
//     return $this->db->get()->result();
// }

     public function get_all_institute()
{
    return $this->db->get('institute_master')->result();
}
public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }

   public function getDataByInstitute($institute_id, $startdate = null, $enddate = null, $activities = [], $year = [])
{
    $this->db->select('
        nss_master.NssActName,
        nss_master.PlaceOFAct,
        nss_master.SPOCName,
        nss_master.Month,
        nss_master.ActDate,
        nss_master.StudPart,
        nss_master.Report_Flag,
        nss_master.Report_pdf,
        nss_master.Activity_Status,
        nss_master.Financial_Year,
        institute_master.Institu_name
    ');
    $this->db->from('nss_master');
    $this->db->join('institute_master', 'nss_master.Institute_id = institute_master.Institu_id', 'left');

    // 🔹 Filter by financial year (stored as ID)
    if (!empty($year)) {
        if (is_array($year) && count($year) > 0) {
            $this->db->where_in('nss_master.Financial_Year', $year);
        } else {
            $this->db->where('nss_master.Financial_Year', $year);
        }
    }

    // 🔹 Filter by institute
    if (!empty($institute_id)) {
        $this->db->where('nss_master.Institute_id', $institute_id);
    }

    // 🔹 Filter by date
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('nss_master.ActDate >=', $startdate);
        $this->db->where('nss_master.ActDate <=', $enddate);
    }

    // 🔹 Filter by activities
    if (!empty($activities) && is_array($activities) && count($activities) > 0) {
        $this->db->where_in('nss_master.NssActName', $activities);
    }

    $this->db->order_by('nss_master.ActDate', 'DESC');
    $query = $this->db->get();

    return $query->result();
}

 public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}



public function getAllYearsData($institu = null, $startDate = null, $endDate = null)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, finiyear_master.fini_Label as year, COUNT(nss_master.NssAct_ID) as count");
    $this->db->from("nss_master");
    $this->db->join("finiyear_master", "finiyear_master.finiYear_id = nss_master.Financial_Year", "left");

    if (!empty($institu)) {
        $this->db->where('nss_master.Institute_id', $institu);
    }
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("nss_master.ActDate >=", $startDate);
        $this->db->where("nss_master.ActDate <=", $endDate);
    }

    $this->db->group_by("nss_master.Financial_Year, finiyear_master.finiYear_id, finiyear_master.fini_Label");
    $this->db->order_by("finiyear_master.finiYear_id", "ASC");
    
    return $this->db->get()->result_array();
}

public function getSingleYearData($yearId, $institu = null, $startDate = null, $endDate = null) 
{
    $this->db->select("finiyear_master.finiYear_id as year_id, finiyear_master.fini_Label as year, COUNT(nss_master.NssAct_ID) as count");
    $this->db->from("nss_master");
    $this->db->join("finiyear_master", "finiyear_master.finiYear_id = nss_master.Financial_Year", "left");

    $this->db->where("nss_master.Financial_Year", $yearId);

    if (!empty($institu)) {
        $this->db->where('nss_master.Institute_id', $institu);
    }
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("nss_master.ActDate >=", $startDate);
        $this->db->where("nss_master.ActDate <=", $endDate);
    }

    $this->db->group_by("nss_master.Financial_Year, finiyear_master.fini_Label, finiyear_master.finiYear_id");

    return $this->db->get()->result_array();
}
public function getYearwiseTypes($yearId, $institu = null, $startDate = null, $endDate = null) 
{
    $this->db->select("nss_master.NssActName, nss_master.Department,nss_master.Report_pdf, finiyear_master.fini_Label as year");
    $this->db->from("nss_master");
    $this->db->join("finiyear_master", "finiyear_master.finiYear_id = nss_master.Financial_Year", "left");
    
    $this->db->where("nss_master.Financial_Year", $yearId);

    if (!empty($institu)) {
        $this->db->where('nss_master.Institute_id', $institu);
    }
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("nss_master.ActDate >=", $startDate);
        $this->db->where("nss_master.ActDate <=", $endDate);
    }

    $this->db->order_by("nss_master.NssActName", "ASC");
    
    return $this->db->get()->result_array();
}

public function getCombinedData($institu = null, $years = [], $startDate = null, $endDate = null)
{
    $response = [];

    $this->db->select("
        finiyear_master.finiYear_id as year_id,
        finiyear_master.fini_Label as year,
        COUNT(nss_master.NssAct_ID) as count
    ");
    $this->db->from("nss_master");
    $this->db->join("finiyear_master", "finiyear_master.finiYear_id = nss_master.Financial_Year", "left");

    if (!empty($institu)) {
        $this->db->where('nss_master.Institute_id', $institu);
    }

    // ✅ Only apply year filter if array has values
    if (!empty($years) && is_array($years) && count($years) > 0) {
        $this->db->where_in('nss_master.Financial_Year', $years);
    }

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("nss_master.ActDate >=", $startDate);
        $this->db->where("nss_master.ActDate <=", $endDate);
    }

    $this->db->group_by("finiyear_master.finiYear_id, finiyear_master.fini_Label");
    $this->db->order_by("finiyear_master.finiYear_id", "ASC");

    $query = $this->db->get();
    $response['yearData'] = $query->result();

    // Return with success flag for your JS
    $response['status'] = count($response['yearData']) > 0 ? 'success' : 'error';

    return $response;
}

public function getActivity()
{
    $this->db->select('NssActName');
    $this->db->from('nss_master');
    $this->db->group_by('NssActName');
    $this->db->order_by('NssActName', 'ASC'); // optional sorting
    return $this->db->get()->result();
}
}