<?php
class Ni_Report1_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // Method to get year-wise MOU count
    public function getYearWiseMOUCount($institu_id, $branch_ids = null, $year = null)
    {
        $this->db->select("
            finiyear_master.finiYear_id,
            finiyear_master.fini_Label as year,
            COUNT(mou_master.mou_id) as count
        ");
        $this->db->from('mou_master');
        $this->db->join('branch_master','mou_master.Branch_id = branch_master.branch_id','left');
        $this->db->join('finiyear_master','mou_master.fkYear_id = finiyear_master.finiYear_id','left');

        if (!empty($branch_ids) && is_array($branch_ids)) {
            $this->db->where_in('mou_master.Branch_id', $branch_ids);
        }

        if (!empty($year) && is_array($year)) {
            $this->db->where_in('mou_master.fkYear_id', $year);
        }

        $this->db->group_by('mou_master.fkYear_id');
        $this->db->order_by('mou_master.fkYear_id', 'ASC');

        $query = $this->db->get();
        return $query->result();
    }

    public function getMOUDataFiltered($institu_id, $branch_ids = null, $year = null, $specific_year_id = null)
    {
        $this->db->select('
            mou_master.mou_id,
            mou_master.Indu_Name,
            mou_master.SignDate,
            mou_master.StartDate,
            mou_master.EndDate,
            mou_master.fkDuration_id,
            mou_master.Highlight_Detail,
            mou_master.Branch_id,
            branch_master.branch_name,
            mou_master.Certificate,
            mou_master.Training,
            mou_master.Intership,
            mou_master.Guest_Lec,
            mou_master.Industry_visit,
            mou_master.VAP,
            mou_master.Consultancy,
            mou_master.fkYear_id,
            finiyear_master.fini_Label
        ');
        $this->db->from('mou_master');
        $this->db->join('branch_master','mou_master.Branch_id = branch_master.branch_id','left');
        $this->db->join('finiyear_master','mou_master.fkYear_id = finiyear_master.finiYear_id','left');
        
        if (!empty($branch_ids) && is_array($branch_ids)) {
            $this->db->where_in('mou_master.Branch_id', $branch_ids);
        }

        if (!empty($specific_year_id)) {
            $this->db->where('mou_master.fkYear_id', $specific_year_id);
        } else {
            if (!empty($year)) {
                if (is_array($year) && count($year) > 0) {
                    $this->db->where_in('mou_master.fkYear_id', $year);
                } else if (!is_array($year)) {
                    $this->db->where('mou_master.fkYear_id', $year);
                }
            }
        }

        $this->db->order_by('mou_master.SignDate', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // CORRECTED - Get all branches that exist in mou_master
    public function getbranch()
    {
        $this->db->select('branch_master.branch_id, branch_master.branch_name');
        $this->db->from('mou_master');
        $this->db->join('branch_master', 'mou_master.Branch_id = branch_master.branch_id', 'inner');
        $this->db->where('branch_master.branch_id IS NOT NULL');
        $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
        $this->db->order_by('branch_master.branch_name', 'ASC');
        
        $query = $this->db->get();
        
        // Debug - temporarily uncomment to check
        // log_message('debug', 'Branch Query: ' . $this->db->last_query());
        // log_message('debug', 'Branch Count: ' . $query->num_rows());
        
        return $query->result();
    }

    

    // CORRECTED - Get all years that exist in mou_master
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('mou_master');
        $this->db->join('finiyear_master', 'mou_master.fkYear_id = finiyear_master.finiYear_id', 'inner');
        $this->db->where('finiyear_master.finiYear_id IS NOT NULL');
        $this->db->group_by('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->order_by('finiyear_master.fini_Label', 'ASC');
        
        $query = $this->db->get();
        
        // Debug - temporarily uncomment to check
        // log_message('debug', 'Year Query: ' . $this->db->last_query());
        // log_message('debug', 'Year Count: ' . $query->num_rows());
        
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}