<?php
class OutwardReport_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function getFilteredData($institu, $department = [], $mainuser = [], $category = [], $item = [], $year = null, $startDate = null, $endDate = null)
    {
        // Select outward main data with related tables
        $this->db->select('
            outward_main_master.Outward_main_id,
            outward_main_master.fkdepartment_id,
            outward_department_master.Department_name,
            outward_main_master.fkmainuser_id,
            mainuser_master.mainuser_name,
            outward_main_master.Applicant_name,
            outward_main_master.Applicant_id,
            outward_main_master.Date,
            outward_main_master.Grand_Total,
            outward_main_master.finicial_Year,
            finiyear_master.fini_Label,
            outward_master.fkItem_id,
            store_item_master.Item_name,
            store_item_master.fkCategory_ID,
            itemcategory_master.Category_name,
            outward_master.fkUnit_ID,
            unit_master.Unit_name,
            outward_master.Quantity,
            outward_master.Rate,
            outward_master.Total
        ');
        
        $this->db->from('outward_main_master');
        $this->db->join('outward_master','outward_master.fkOutward_main_id = outward_main_master.Outward_main_id','left');
        $this->db->join('store_item_master','outward_master.fkItem_id = store_item_master.Item_id','left');
        $this->db->join('itemcategory_master','store_item_master.fkCategory_ID = itemcategory_master.Category_id','left');
        $this->db->join('unit_master','outward_master.fkUnit_ID = unit_master.Unit_ID','left');
        $this->db->join('outward_department_master','outward_main_master.fkdepartment_id = outward_department_master.department_id','left');
        $this->db->join('mainuser_master','outward_main_master.fkmainuser_id = mainuser_master.mainuser_id','left');
        $this->db->join('finiyear_master','outward_main_master.finicial_Year = finiyear_master.finiYear_id','left');

        // Institute filter
        if (!empty($institu)) {
            $this->db->where('outward_main_master.institute', $institu);
        }

        // Department filter (multiple)
        if (!empty($department)) {
            if (is_array($department) && count($department) > 0) {
                $this->db->where_in('outward_main_master.fkdepartment_id', $department);
            } else if (!is_array($department)) {
                $this->db->where('outward_main_master.fkdepartment_id', $department);
            }
        }

        // Main User / Applicant Type filter (multiple)
        if (!empty($mainuser)) {
            if (is_array($mainuser) && count($mainuser) > 0) {
                $this->db->where_in('outward_main_master.fkmainuser_id', $mainuser);
            } else if (!is_array($mainuser)) {
                $this->db->where('outward_main_master.fkmainuser_id', $mainuser);
            }
        }

        // Category filter (multiple)
        if (!empty($category)) {
            if (is_array($category) && count($category) > 0) {
                $this->db->where_in('store_item_master.fkCategory_ID', $category);
            } else if (!is_array($category)) {
                $this->db->where('store_item_master.fkCategory_ID', $category);
            }
        }

        // Item filter (multiple)
        if (!empty($item)) {
            if (is_array($item) && count($item) > 0) {
                $this->db->where_in('outward_master.fkItem_id', $item);
            } else if (!is_array($item)) {
                $this->db->where('outward_master.fkItem_id', $item);
            }
        }

        // Year filter
        if (!empty($year) && $year != 0 && $year != '0') {
            $this->db->where('outward_main_master.finicial_Year', $year);
        }

        // Date range filter
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(outward_main_master.Date) BETWEEN '$startDate' AND '$endDate'");
        } elseif (!empty($startDate)) {
            $this->db->where("DATE(outward_main_master.Date) >= '$startDate'");
        } elseif (!empty($endDate)) {
            $this->db->where("DATE(outward_main_master.Date) <= '$endDate'");
        }

        // Active records only
        $this->db->where('outward_main_master.is_active', 1);

        $this->db->order_by('outward_main_master.Date', 'DESC');
        $this->db->order_by('outward_main_master.Outward_main_id', 'DESC');
        
        return $this->db->get()->result();
    }

    // ... rest of the methods remain the same ...


    public function getdepart()
    {
        $this->db->select('department_id, Department_name');
        $this->db->from('outward_department_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Department_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getmainuser() 
    {
        $this->db->select('mainuser_id, mainuser_name');
        $this->db->from('mainuser_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getCategory()
    {
        $this->db->select('Category_id, Category_name');
        $this->db->from('itemcategory_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Category_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getItems()
    {
        $this->db->select('store_item_master.Item_id, store_item_master.Item_name, store_item_master.fkCategory_ID, itemcategory_master.Category_name');
        $this->db->from('store_item_master');
        $this->db->join('itemcategory_master', 'store_item_master.fkCategory_ID = itemcategory_master.Category_id', 'left');
        $this->db->where('store_item_master.is_active', 1);
        $this->db->order_by('store_item_master.Item_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getItemsByCategory($category_id)
    {
        $this->db->select('Item_id, Item_name');
        $this->db->from('store_item_master');
        $this->db->where('fkCategory_ID', $category_id);
        $this->db->where('is_active', 1);
        $this->db->order_by('Item_name', 'ASC');
        return $this->db->get()->result();
    }

    // NEW: Get item details for modal
    public function getItemDetails($main_id)
    {
        $this->db->select('
            outward_master.fkItem_id,
            store_item_master.Item_name,
            store_item_master.fkCategory_ID,
            itemcategory_master.Category_name,
            outward_master.fkUnit_ID,
            unit_master.Unit_name,
            outward_master.Quantity,
            outward_master.Rate,
            outward_master.Total,
            finiyear_master.fini_Label
        ');
        
        $this->db->from('outward_master');
        $this->db->join('store_item_master', 'outward_master.fkItem_id = store_item_master.Item_id', 'left');
        $this->db->join('itemcategory_master', 'store_item_master.fkCategory_ID = itemcategory_master.Category_id', 'left');
        $this->db->join('unit_master', 'outward_master.fkUnit_ID = unit_master.Unit_ID', 'left');
        $this->db->join('outward_main_master', 'outward_master.fkOutward_main_id = outward_main_master.Outward_main_id', 'left');
        $this->db->join('finiyear_master', 'outward_main_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        
        $this->db->where('outward_master.fkOutward_main_id', $main_id);
        $this->db->where('outward_master.is_active', 1);
        
        return $this->db->get()->result();
    }

    public function getyear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getinstitu()
    {
        $this->db->select('*');
        $this->db->from('institute_master');
        $this->db->order_by('Institu_name', 'ASC');
        return $this->db->get()->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}