<?php
class PO_Mapping_model extends CI_Model {

    public function __construct()
    {
        $this->load->database();
    }

    public function insertdata($model)
    {
        $this->db->insert('co_po_mapping', $model);
        return $this->db->insert_id();
    }

    public function getbranch()
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('finiYear_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getCoursesByBranchAndYear($branchId, $yearId)
    {
        $this->db->select('Course_id, Course_code, Course_title');
        $this->db->from('course_master');
        $this->db->where('fkbranch_id', $branchId);
        $this->db->where('finicial_Year', $yearId);
        // $this->db->where('is_active', 1);
        // $this->db->order_by('Course_code', 'ASC');
        // $query = $this->db->get();
        
        $this->db->where('status', 1);
        $this->db->order_by('Order_no', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getdetailview()
{      
    $this->db->select('co_po_mapping.mapping_id,
                     co_po_mapping.fkPO_lable_id,
                      po_lable_master.Po_lable_name,
                      co_po_mapping.fkCourse_id,
                     course_master.Course_code,
                     course_master.Course_title,
                       co_po_mapping.mapping_value,
                       co_po_mapping.fkbranch_id,
                        branch_master.branch_name,
                       co_po_mapping.finicial_Year,
                       finiyear_master.fini_Label
                      
                     
                       ');

    $this->db->from('co_po_mapping');
     $this->db->join('branch_master', 'co_po_mapping.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('finiyear_master', 'co_po_mapping.finicial_Year = finiyear_master.finiYear_id', 'left');
     $this->db->join('course_master','co_po_mapping.fkCourse_id = course_master.Course_id','left');
      $this->db->join('po_lable_master','co_po_mapping.fkPO_lable_id = po_lable_master.PO_lable_id','left');


     

   

    $this->db->order_by('co_po_mapping.mapping_id','DESC');

    $query = $this->db->get();
    return $query->result();      
}

    // ============================================================
    // NEW: yearwise_po_master se PO labels fetch karta hai
    //      branch + year ke hisaab se
    // ============================================================
    // public function getPOLabelsByBranchAndYear($branchId, $yearId)
    // {
    //     $this->db->select('ypm.YearwisePO_id AS PO_lable_id, ypm.Description AS Po_lable_name, ypm.Order_no');
    //     $this->db->from('yearwise_po_master ypm');
    //     $this->db->where('ypm.fkbranch_id', $branchId);
    //     $this->db->where('ypm.finicial_Year', $yearId);
    //     $this->db->where('ypm.status', 1);         // active check (agar hai to)
    //     $this->db->order_by('ypm.Order_no', 'ASC'); // Order_no se sort hoga — PO1, PO2... sahi order mein
    //     $query = $this->db->get();
    //     return $query->result();
    // }


    public function getPOLabelsByBranchAndYear($branchId, $yearId)
{
    $this->db->select('ypm.YearwisePO_id AS PO_lable_id, plm.PO_lable_name AS Po_lable_name, ypm.Order_no');
    $this->db->from('yearwise_po_master ypm');
    $this->db->join('po_lable_master plm', 'ypm.fkPO_lable_id = plm.PO_lable_id', 'left');
    $this->db->where('ypm.fkbranch_id', $branchId);
    $this->db->where('ypm.finicial_Year', $yearId);
    $this->db->where('ypm.status', 1);
    $this->db->order_by('ypm.Order_no', 'ASC');
    $query = $this->db->get();
    return $query->result();
}

    // Existing mappings fetch (edit mode ke liye)
    public function getExistingMappings($branchId, $yearId)
    {
        $this->db->select('fk_course_id, fk_po_label_id, mapping_value');
        $this->db->from('co_po_mapping');
        $this->db->where('fkbranch_id', $branchId);
        $this->db->where('finicial_Year', $yearId);
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    // Save mapping
    public function saveMappings($branchId, $yearId, $mappingData, $submenuId)
    {
        // Pehle purana data delete karo (same branch + year ka)
        $this->db->where('fkbranch_id', $branchId);
        $this->db->where('finicial_Year', $yearId);
        $this->db->delete('co_po_mapping');

        // Naya data insert karo
        foreach ($mappingData as $course) {
            foreach ($course['mappings'] as $mapping) {
                $data = array(
                    'fkbranch_id'      => $branchId,
                    'finicial_Year'    => $yearId,
                    'fk_course_id'     => $course['courseId'],
                    'fk_po_label_id'   => $mapping['poLabelId'],
                    'mapping_value'    => $mapping['value'],
                    'fk_submenuId'     => $submenuId,
                    'created_date'     => date('Y-m-d H:i:s'),
                    'created_by'       => $this->session->userdata('user_id')
                );
                $this->db->insert('co_po_mapping', $data);
            }
        }
        return true;
    }
}