<?php
  class ParentMeet_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		$this->db->insert('parentmeet_master',$model);
			return $this->db->insert_id();
	} 
public function getdetailview()
{      
    $this->db->select('parentmeet_master.*, branch_master.branch_name, finiyear_master.fini_Label,semester_master.Sem_Name,');
    $this->db->from('parentmeet_master');
    $this->db->join('branch_master', 'parentmeet_master.fkBranch_id = branch_master.branch_id', 'left');
    $this->db->join('finiyear_master','parentmeet_master.FiniYear =finiyear_master.finiYear_id','left');
     $this->db->join('semester_master', 'parentmeet_master.fk_sem = semester_master.SemID', 'left');
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    
    $this->db->order_by('parentmeet_master.Meet_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}

      public function get_all_Branch()
{
    return $this->db->get('branch_master')->result();
}


public function get_students_by_meet($meet_id)
{
    $this->db->where('meet_id', $meet_id);
    $query = $this->db->get('parentmeet_students');
    return $query->result();
}

public function getsem()
     {
      $this->db->select('semester_master.*,');
      $this->db->from('semester_master');
       $query = $this->db->get();
        return $query->result();
     }


      public function getbyid($id)
		{
		  $this->db->select("parentmeet_master.*,");
	    $this->db->where('Meet_id',$id);
      $query = $this->db->get('parentmeet_master');
			return $query->result();
		}
		
    public function update($model)
    {
       return $sql = $this->db->where('Meet_id',$model['Meet_id'])->update('parentmeet_master',$model); 
    } 

    
      public function get_all_institute()
{
    return $this->db->get('institute_master')->result();
}

public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }

public function getDataByInstitute($institute_id, $startdate = null, $enddate = null, $branches = [])
{
    $this->db->select('parentmeet_master.*, 
                       branch_master.branch_name,
                       institute_master.Institu_name');
    $this->db->from('parentmeet_master');
    $this->db->join('branch_master', 'parentmeet_master.fkBranch_id = branch_master.branch_id', 'left');
    $this->db->join('institute_master', 'parentmeet_master.Institute_id = institute_master.Institu_id', 'left');

    // ✅ filter by institute
    if (!empty($institute_id)) {
        $this->db->where('parentmeet_master.Institute_id', $institute_id);
    }

    // ✅ filter by MeetingDate between
    if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('parentmeet_master.MeetDate >=', $startdate);
        $this->db->where('parentmeet_master.MeetDate <=', $enddate);
    }

    // ✅ filter by multi-select branch
    if (!empty($branches)) {
        $this->db->where_in('parentmeet_master.fkBranch_id', $branches);
    }

    $this->db->order_by('parentmeet_master.Meet_id', 'ASC');
    $query = $this->db->get();
    return $query->result();
}



 public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}



    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("parentmeet_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = parentmeet_master.FiniYear")
        ->group_by("parentmeet_master.FiniYear, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}

public function getSingleYearData($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("parentmeet_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = parentmeet_master.FiniYear")
        ->where("parentmeet_master.FiniYear", $yearId);

    if (!empty($institu)) {
        $this->db->where('parentmeet_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('parentmeet_master.fkBranch_id', (array)$branches);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("parentmeet_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("parentmeet_master.FiniYear, fini_Label, finiyear_master.finiYear_id");

    return $this->db->get()->result_array();
}


public function getYearwiseTypes($yearId, $institu = null, $branches = [], $startDate = null, $endDate = null)
{
    $this->db->select("
        parentmeet_master.Meet_id,
        parentmeet_master.MeetingAgenda,
        parentmeet_master.fkBranch_id,
        parentmeet_master.MeetDate,
        parentmeet_master.NoStudent,
        parentmeet_master.NoParent,
        parentmeet_master.SuggestionParents,
        parentmeet_master.ActionTaken,
        branch_master.branch_name,
        finiyear_master.fini_Label as year
    ")
    ->from("parentmeet_master")
    ->join("finiyear_master", "finiyear_master.finiYear_id = parentmeet_master.FiniYear")
    ->join("branch_master", "branch_master.branch_id = parentmeet_master.fkBranch_id", "left")
    ->where("parentmeet_master.FiniYear", $yearId);

    if (!empty($institu)) {
        $this->db->where('parentmeet_master.fkInstitName_id', $institu);
    }

    if (!empty($branches)) {
        $this->db->where_in('parentmeet_master.fkBranch_id', $branches);
    }

    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("parentmeet_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    // Removed unnecessary branch_id block

    return $this->db->get()->result_array();
}



     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
       $query = $this->db->get();
        return $query->result();
     }
  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(parentmeet_master.Meet_id) as meet_count');
    $this->db->from('branch_master');
    $this->db->join('parentmeet_master', 'branch_master.branch_id = parentmeet_master.fkBranch_id', 'left');

    if (!empty($institu)) {
        $this->db->where('parentmeet_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('parentmeet_master.FiniYear', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("parentmeet_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');

    return $this->db->get()->result();
}

public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
   $this->db->select('parentmeet_master.MeetingAgenda,
                   parentmeet_master.Meet_id,
                   parentmeet_master.fkBranch_id,
                   parentmeet_master.MeetDate,
                   parentmeet_master.NoStudent,
                   parentmeet_master.NoParent,
                   parentmeet_master.SuggestionParents,
                   parentmeet_master.ActionTaken,
                   branch_master.branch_name');

    $this->db->from('parentmeet_master');
    $this->db->join('branch_master', 'branch_master.branch_id = parentmeet_master.fkBranch_id', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('parentmeet_master.fkBranch_id', $branch_id);
} else {
    $this->db->where('parentmeet_master.fkBranch_id', $branch_id);
}


    if (!empty($institu)) {
        $this->db->where('parentmeet_master.fkInstitName_id', $institu);
    }
    if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('parentmeet_master.FiniYear', $year);
    } else {
        $this->db->where('parentmeet_master.FiniYear', $year);
    }
}
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('parentmeet_master.FiniYear', $year);
    // }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("parentmeet_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    return $this->db->get()->result();
}

 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];

    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.Meet_id) as meet_count');
    $this->db->from('branch_master b');
    $this->db->join('parentmeet_master sr', 'b.branch_id = sr.fkBranch_id', 'left');

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sr.FiniYear', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();

    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.Meet_id) as count");
    $this->db->from("parentmeet_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.FiniYear");

    if (!empty($institu)) {
        $this->db->where('sr.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkBranch_id', (array)$branches);
    }
    if (!empty($years)) {
        $this->db->where_in('sr.FiniYear', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();

    return $response;
}

public function getStudentsByMeetId($meet_id)
{
    return $this->db->select('prn, student_name, parent_name, mobile_no, occupation')
                    ->from('parentmeet_students')
                    ->where('meet_id', $meet_id)
                    ->get()
                    ->result_array();
}


}