<?php
  class Patent_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		 $this->db->insert('patent_master',$model);
return $this->db->insert_id();
	} 

   public function getdetailview()
{      
    $this->db->select('
        patent_master.patent_id,
        patent_master.patent_name,
        patent_master.fkmainuser_id,
        mainuser_master.mainuser_name,
        patent_master.fkbranch_id,
        branch_master.branch_name,
        patent_master.fkpatenttpye_id,
        patenttpye_master.patenttpye_name,
        patent_master.ApplicNo,
        patent_master.PRN,
        patent_master.Published,
        patent_master.PublicDate,
        patent_master.Granted,
        patent_master.GrantDate,
        patent_master.applicant_id,
        patent_master.applicant_type,
        patent_master.applicant_name');

    $this->db->from('patent_master');
    $this->db->join('branch_master','patent_master.fkbranch_id = branch_master.branch_id','left');
    $this->db->join('mainuser_master','patent_master.fkmainuser_id = mainuser_master.mainuser_id','left');
    $this->db->join('patenttpye_master','patent_master.fkpatenttpye_id = patenttpye_master.patenttpye_id','left');
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    $this->db->order_by('patent_master.patent_id','DESC');

    $query = $this->db->get();
    return $query->result();      
}



     public function getbranch() 
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $query = $this->db->get();
        return $query->result();
    }

    public function getFac() 
    {
        $this->db->select('fac_id,fac_Fullname');
        $this->db->from('faculty_master');
        $query = $this->db->get();
        return $query->result();
    }
    
     public function getstudent() 
    {
        $this->db->select('Student_id, FullName');
        $this->db->from('student_reg');
        $query = $this->db->get();
        return $query->result();
    }
     public function getmainuser() 
    {
        $this->db->select('mainuser_id,mainuser_name');
        $this->db->from('mainuser_master');
        $query = $this->db->get();
        return $query->result();
    }
     public function getpatent() 
    {
        $this->db->select('patenttpye_id,patenttpye_name');
        $this->db->from('patenttpye_master');
        $query = $this->db->get();
        return $query->result();
    }


      public function getbyid($id)
{
    $this->db->select("patent_master.*,
        CASE 
            WHEN patent_master.applicant_type = 'faculty' 
                THEN patent_master.applicant_id
            WHEN patent_master.applicant_type = 'student'
                THEN patent_master.applicant_id
            ELSE NULL
        END AS applicant_real_id
    ");
    $this->db->where('patent_id', $id);
    $query = $this->db->get('patent_master');
    return $query->result();
}

		
  public function update($model)
{
   return $this->db->where('patent_id',$model['patent_id'])->update('patent_master',$model); 
}


}