<?php
class Photolink_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    public function insertdata($model)
    {
         $this->db->insert('multiphoto_master', $model);
         return $this->db->insert_id();
    }

    public function insertgallery($model)
    {
        return $this->db->insert('multiphoto_child', $model);
    }

   
    // In Photolink_model (admin/Photolink_model.php)
public function getdetailview($id = null)
{
    $this->db->select('multiphoto_master.*,
                        branch_master.branch_name,
                       finiyear_master.fini_Label');
    $this->db->from('multiphoto_master');
    $this->db->join('finiyear_master', 'multiphoto_master.year = finiyear_master.finiYear_id', 'left');
    $this->db->join('branch_master', 'multiphoto_master.fkbranch_id = branch_master.branch_id', 'left');
    
    // Filter by ID if provided
    if ($id) {
        $this->db->where('multiphoto_master.fkForm_id', $id);
    }
    
    $this->db->order_by('multiphoto_master.multi_id', 'DESC');
    $query = $this->db->get();
    return $query->result();
}


     public function getbranch() 
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }



    public function getbyid($id)
    {
        $this->db->select("multiphoto_master.*");
        $this->db->where('multi_id', $id);
        $query = $this->db->get('multiphoto_master');
        return $query->result();
    }

    public function update($model)
    {
        return $this->db->where('multi_id', $model['multi_id'])
                        ->update('multiphoto_master', $model);
    }

    // ⭐ UPDATED: Return photos separated by type
    public function getSelectedPhotos($master_id)
    {
        $this->db->select('photos, photo_type');
        $this->db->from('multiphoto_child');
        $this->db->where('fk_multiID', $master_id);
        $this->db->order_by('childID', 'ASC');
        $query = $this->db->get();

        $photos = ['local' => [], 'google' => [], 'all' => []];

        foreach ($query->result() as $row) {
            if ($row->photo_type == 'local') {
                $photos['local'][] = $row->photos;
            } elseif ($row->photo_type == 'google') {
                $photos['google'][] = $row->photos;
            }
            $photos['all'][] = $row->photos;
        }

        return $photos;
    }

    public function getPhotoCount($master_id)
    {
        return $this->db->where('fk_multiID', $master_id)
                        ->from('multiphoto_child')
                        ->count_all_results();
    }

    public function deletePhoto($child_id)
    {
        $this->db->where('childID', $child_id);
        return $this->db->delete('multiphoto_child');
    }

    public function getChildByFilename($master_id, $filename)
    {
        $this->db->where('fk_multiID', $master_id);
        $this->db->where('photos', $filename);
        $query = $this->db->get('multiphoto_child');
        return $query->row();
    }
}