<?php
  class PracticedReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
public function getFilteredData($mainuser_ids = [], $platform_ids = [], $duration_ids = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('pm.Practiced_id,
                       pm.fkmainuser_id,
                       mm.mainuser_name,
                       pm.fkPlatform_id,
                       plat.Platform_name,
                       pm.fkduration_id,
                       dur.duration_type,
                       pm.Applicant_name,
                       pm.Applicant_id,
                       pm.Course_name,
                       pm.Practice_prece,
                       pm.fkGrade_id,
                       gm.Grade_name,
                       pm.Certi_photo,
                       pm.finicial_Year,
                       fy.fini_Label,
                       pm.fkStatus_id,
                       sm.Status_name,
                       pm.StartDate,
                       pm.EndDate');
    
    $this->db->from('practiced_master pm');
    $this->db->join('mainuser_master mm', 'pm.fkmainuser_id = mm.mainuser_id', 'left');
    $this->db->join('platform_master plat', 'pm.fkPlatform_id = plat.Platform_id', 'left');
    $this->db->join('internduration_master dur', 'pm.fkduration_id = dur.duration_id', 'left');
    $this->db->join('grade_master gm', 'pm.fkGrade_id = gm.Grade_id', 'left');
    $this->db->join('finiyear_master fy', 'pm.finicial_Year = fy.finiYear_id', 'left');
    $this->db->join('status_master sm', 'pm.fkStatus_id = sm.Status_id', 'left');

    // 🔹 Applicants Type filter (multiple)
    if (!empty($mainuser_ids)) {
        if (is_array($mainuser_ids)) {
            $this->db->where_in('pm.fkmainuser_id', $mainuser_ids);
        } else {
            $this->db->where('pm.fkmainuser_id', $mainuser_ids);
        }
    }

    // 🔹 Platform filter (multiple)
    if (!empty($platform_ids)) {
        if (is_array($platform_ids)) {
            $this->db->where_in('pm.fkPlatform_id', $platform_ids);
        } else {
            $this->db->where('pm.fkPlatform_id', $platform_ids);
        }
    }

    // 🔹 Duration filter (multiple)
    if (!empty($duration_ids)) {
        if (is_array($duration_ids)) {
            $this->db->where_in('pm.fkduration_id', $duration_ids);
        } else {
            $this->db->where('pm.fkduration_id', $duration_ids);
        }
    }

    // 🔹 Year filter
    if (!empty($year) && $year != 0) {
        $this->db->where('pm.finicial_Year', $year);
    }

    // 🔹 Date range filter using StartDate and EndDate columns
    if (!empty($startDate) && !empty($endDate)) {
        // Filter where the practiced_master date range overlaps with selected range
        $this->db->group_start();
        $this->db->where("DATE(pm.StartDate) <= '$endDate'");
        $this->db->where("DATE(pm.EndDate) >= '$startDate'");
        $this->db->group_end();
    } elseif (!empty($startDate)) {
        $this->db->where("DATE(pm.EndDate) >= '$startDate'");
    } elseif (!empty($endDate)) {
        $this->db->where("DATE(pm.StartDate) <= '$endDate'");
    }

    $this->db->order_by('pm.Practiced_id', 'DESC');
    return $this->db->get()->result();
}
 
   
     public function getmainuser()
     {
      $this->db->select('mainuser_id, mainuser_name');
      $this->db->from('mainuser_master');
       $query = $this->db->get();
        return $query->result();
     }
 
     public function getplatfrom() 
    {
        $this->db->select('Platform_id, Platform_name');
        $this->db->from('platform_master');
        $query = $this->db->get();
        return $query->result();
    }
    public function getDuration() 
    {
        $this->db->select('duration_id, duration_type');
        $this->db->from('internduration_master');
        $query = $this->db->get();
        return $query->result();
    }
    
      public function getyear()
     {
      $this->db->select('finiYear_id, fini_Label');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
       public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }
 
   
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
} 
   


// Replace these methods in your PracticedReport_model.php

public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(practiced_master.Practiced_id) as count")
        ->from("practiced_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = practiced_master.finicial_Year")
        ->group_by("practiced_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}

// public function getSingleYearData($yearId, $mainusers = [])
// {
//     $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(practiced_master.Practiced_id) as count")
//         ->from("practiced_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = practiced_master.finicial_Year")
//         ->where("practiced_master.finicial_Year", $yearId);

//     if (!empty($mainusers)) {
//         $this->db->where_in('practiced_master.fkmainuser_id', (array)$mainusers);
//     }

//     $this->db->group_by("practiced_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
//     return $this->db->get()->result_array();
// }


// Replace these methods in PracticedReport_model.php

public function getYearwiseTypes($yearId)
{
    // NO FILTERS - Just year-based data
    $this->db->select("practiced_master.Practiced_id,
                       practiced_master.fkmainuser_id,
                       mainuser_master.mainuser_name,
                       practiced_master.fkPlatform_id,
                       platform_master.Platform_name,
                       practiced_master.Applicant_name,
                       practiced_master.Applicant_id,
                       practiced_master.Course_name,
                       practiced_master.Practice_prece,
                       practiced_master.fkGrade_id,
                       grade_master.Grade_name,
                       practiced_master.Certi_photo,
                       finiyear_master.fini_Label as year")
        ->from("practiced_master")
        ->join('mainuser_master', 'practiced_master.fkmainuser_id = mainuser_master.mainuser_id', 'left')
        ->join('platform_master', 'practiced_master.fkPlatform_id = platform_master.Platform_id', 'left')
        ->join('grade_master', 'practiced_master.fkGrade_id = grade_master.Grade_id', 'left')
        ->join('finiyear_master', 'practiced_master.finicial_Year = finiyear_master.finiYear_id', 'left')
        ->where("practiced_master.finicial_Year", $yearId);
    
    return $this->db->get()->result_array();
}

public function getSingleYearData($yearId)
{
    // NO FILTERS - Just year count
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(practiced_master.Practiced_id) as count")
        ->from("practiced_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = practiced_master.finicial_Year")
        ->where("practiced_master.finicial_Year", $yearId)
        ->group_by("practiced_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
    
    return $this->db->get()->result_array();
}

public function getBranchwiseCount($institu = null, $mainusers = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('mainuser_master.mainuser_id,
                       mainuser_master.mainuser_name,
                       COUNT(practiced_master.Practiced_id) as Practice_count');
    $this->db->from('mainuser_master');
    $this->db->join('practiced_master', 'mainuser_master.mainuser_id = practiced_master.fkmainuser_id', 'left');

    if (!empty($mainusers)) {
        $this->db->where_in('mainuser_master.mainuser_id', (array)$mainusers);
    }
    if (!empty($year) && $year != 0) {
        $this->db->where('practiced_master.finicial_Year', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->group_start();
        $this->db->where("DATE(practiced_master.StartDate) <= '$endDate'");
        $this->db->where("DATE(practiced_master.EndDate) >= '$startDate'");
        $this->db->group_end();
    }

    $this->db->group_by('mainuser_master.mainuser_id, mainuser_master.mainuser_name');
    $this->db->order_by('mainuser_master.mainuser_name', 'ASC');

    return $this->db->get()->result();
}

public function getBranchDetailsData($mainuser_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('practiced_master.Practiced_id,
                       practiced_master.fkmainuser_id,
                       mainuser_master.mainuser_name,
                       practiced_master.fkPlatform_id,
                       platform_master.Platform_name,
                       practiced_master.Applicant_name,
                       practiced_master.Applicant_id,
                       practiced_master.Course_name,
                       practiced_master.Practice_prece,
                       practiced_master.fkGrade_id,
                       grade_master.Grade_name,
                       practiced_master.fkStatus_id,
                       status_master.Status_name,
                       practiced_master.Certi_photo,
                       finiyear_master.fini_Label');
    $this->db->from('practiced_master');
    $this->db->join('mainuser_master', 'practiced_master.fkmainuser_id = mainuser_master.mainuser_id', 'left');
    $this->db->join('platform_master', 'practiced_master.fkPlatform_id = platform_master.Platform_id', 'left');
    $this->db->join('grade_master', 'practiced_master.fkGrade_id = grade_master.Grade_id', 'left');
    $this->db->join('status_master', 'practiced_master.fkStatus_id = status_master.Status_id', 'left');
    $this->db->join('finiyear_master', 'practiced_master.finicial_Year = finiyear_master.finiYear_id', 'left');
    
    if (is_array($mainuser_id)) {
        $this->db->where_in('practiced_master.fkmainuser_id', $mainuser_id);
    } else {
        $this->db->where('practiced_master.fkmainuser_id', $mainuser_id);
    }

    if (!empty($year)) {
        if (is_array($year)) {
            $this->db->where_in('practiced_master.finicial_Year', $year);
        } else {
            $this->db->where('practiced_master.finicial_Year', $year);
        }
    }
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->group_start();
        $this->db->where("DATE(practiced_master.StartDate) <= '$endDate'");
        $this->db->where("DATE(practiced_master.EndDate) >= '$startDate'");
        $this->db->group_end();
    }

    return $this->db->get()->result();
}


 public function getCombinedData($mainuser_ids = [], $platform_ids = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Mainuser Type Count (replacing branch) ---
    $this->db->select('mm.mainuser_id, mm.mainuser_name, COUNT(pm.Practiced_id) as practice_count');
    $this->db->from('mainuser_master mm');
    $this->db->join('practiced_master pm', 'mm.mainuser_id = pm.fkmainuser_id', 'left');
 
    if (!empty($mainuser_ids)) {
        $this->db->where_in('mm.mainuser_id', (array)$mainuser_ids);
    }
    if (!empty($platform_ids)) {
        $this->db->where_in('pm.fkPlatform_id', (array)$platform_ids);
    }
    if (!empty($years)) {
        $this->db->where_in('pm.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->group_start();
        $this->db->where("DATE(pm.StartDate) <= '$endDate'");
        $this->db->where("DATE(pm.EndDate) >= '$startDate'");
        $this->db->group_end();
    }
 
    $this->db->group_by('mm.mainuser_id, mm.mainuser_name');
    $this->db->order_by('mm.mainuser_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(pm.Practiced_id) as count");
    $this->db->from("practiced_master pm");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = pm.finicial_Year");
 
    if (!empty($mainuser_ids)) {
        $this->db->where_in('pm.fkmainuser_id', (array)$mainuser_ids);
    }
    if (!empty($platform_ids)) {
        $this->db->where_in('pm.fkPlatform_id', (array)$platform_ids);
    }
    if (!empty($years)) {
        $this->db->where_in('pm.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->group_start();
        $this->db->where("DATE(pm.StartDate) <= '$endDate'");
        $this->db->where("DATE(pm.EndDate) >= '$startDate'");
        $this->db->group_end();
    }
 
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
   


}