<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Question_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // ==================== MASTER DATA FUNCTIONS ====================

    // Get feedback for dropdown
    public function getFeedbackFor()
    {
        $this->db->select('feedbackfor_master.feedbackid, feedbackfor_master.feedbackforname');
        $this->db->from('feedbackfor_master');
        $this->db->where('feedbackfor_master.is_active', 1);
        $this->db->order_by('feedbackfor_master.feedbackforname', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get answer type dropdown
    public function getAnswerType()
    {
        $this->db->select('answertypehead_master.ansswertypehead_id, answertypehead_master.ansswertypehead_name');
        $this->db->from('answertypehead_master');
        $this->db->where('answertypehead_master.is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    // ==================== CRUD FUNCTIONS ====================

    // Get by ID (for edit/update page)
    public function getbyid($id)
    {
        $this->db->select("question_master.*");
        $this->db->where('questionid', $id);
        $query = $this->db->get('question_master');
        return $query->result();
    }

    // Insert Question
    public function insertQuestion($data)
    {
        $insert_data = array(
            'question_name'    => $data['question_name'],
            'feedbackid'       => $data['feedbackid'],
            'isanswerortext'   => $data['isanswerortext'],
            'is_default'       => isset($data['is_default']) ? $data['is_default'] : 0,
            'is_on'            => isset($data['is_on']) ? $data['is_on'] : 0,
            'is_active'        => isset($data['is_active']) ? $data['is_active'] : 1,
            'created_date'     => date('Y-m-d H:i:s'),
            'created_by'       => $this->session->userdata('user_id')
        );
        
        if ($this->db->insert('question_master', $insert_data)) {
            return array(
                'status'      => true,
                'question_id' => $this->db->insert_id()
            );
        }
        
        return array('status' => false);
    }

    // Update Question
    public function updateQuestion($question_id, $data)
    {
        $update_data = array(
            'question_name'    => $data['question_name'],
            'feedbackid'       => $data['feedbackid'],
            'isanswerortext'   => $data['isanswerortext'],
            'is_default'       => isset($data['is_default']) ? $data['is_default'] : 0,
            'is_on'            => isset($data['is_on']) ? $data['is_on'] : 0,
            'is_active'        => isset($data['is_active']) ? $data['is_active'] : 1,
            'modified_date'    => date('Y-m-d H:i:s'),
            'modified_by'      => $this->session->userdata('user_id')
        );
        
        $this->db->where('questionid', $question_id);
        return $this->db->update('question_master', $update_data);
    }

    // Delete Question
    public function deleteQuestion($question_id)
    {
        $this->db->where('questionid', $question_id);
        return $this->db->delete('question_master');
    }

    // Toggle Active Status
    public function toggleActiveStatus($question_id, $is_active)
    {
        $data = array(
            'is_active'     => $is_active == 1 ? 1 : 0,
            'modified_date' => date('Y-m-d H:i:s'),
            'modified_by'   => $this->session->userdata('user_id')
        );
        $this->db->where('questionid', $question_id);
        return $this->db->update('question_master', $data);
    }

    // ==================== LIST FUNCTIONS ====================

    // Get all questions with JOIN
    public function getAllQuestions()
    {
        $this->db->select('question_master.*, 
                          feedbackfor_master.feedbackforname,
                          answertypehead_master.ansswertypehead_name');
        $this->db->from('question_master');
        $this->db->join('feedbackfor_master', 'question_master.feedbackid = feedbackfor_master.feedbackid', 'left');
        $this->db->join('answertypehead_master', 'question_master.isanswerortext = answertypehead_master.ansswertypehead_id', 'left');
        $this->db->order_by('question_master.questionid', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get questions by feedback for
    public function getQuestionsByFeedbackFor($feedbackfor_id)
    {
        $this->db->select('question_master.*, answertypehead_master.answertypename');
        $this->db->from('question_master');
        $this->db->join('answertypehead_master', 'question_master.isanswerortext = answertypehead_master.ansswertypehead_id', 'left');
        $this->db->where('question_master.feedbackid', $feedbackfor_id);
        $this->db->where('question_master.is_active', 1);
        $this->db->order_by('question_master.questionid', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Check duplicate question
    public function checkDuplicateQuestion($question_name, $feedbackid, $question_id = null)
    {
        $this->db->select('questionid');
        $this->db->from('question_master');
        $this->db->where('question_name', $question_name);
        $this->db->where('feedbackid', $feedbackid);
        
        if ($question_id) {
            $this->db->where('questionid !=', $question_id);
        }
        
        $query = $this->db->get();
        return $query->num_rows() > 0;
    }
}
?>