<?php
class Report_Patent_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // New method to get year-wise count
    public function getYearWisePatentCount($institu_id, $branch_ids = null, $year = null)
    {
        $this->db->select("
            YEAR(patent_master.PublicDate) as year,
            COUNT(patent_master.patent_id) as count
        ");
        $this->db->from('patent_master');
        $this->db->join('branch_master','patent_master.fkbranch_id = branch_master.branch_id','left');

        if (!empty($institu_id)) {
            $this->db->where('patent_master.institute', $institu_id);
        }

        if (!empty($branch_ids)) {
            $this->db->where_in('patent_master.fkbranch_id', $branch_ids);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }

        // FIX: Handle year array properly
        if (!empty($year) && $year != 0) {
            if (is_array($year)) {
                // If year is array, use where_in
                $this->db->where_in('patent_master.finicial_Year', $year);
            } else {
                // If single value
                $this->db->where('patent_master.finicial_Year', $year);
            }
        }

        $this->db->where('patent_master.PublicDate IS NOT NULL');
        $this->db->group_by('YEAR(patent_master.PublicDate)');
        $this->db->order_by('year', 'DESC');
        $this->db->limit(5);

        $query = $this->db->get();
        return $query->result();
    }

    public function getPatenttDataFiltered($institu_id, $branch_ids = null, $year = null, $startdate = null, $enddate = null, $specific_year = null)
    {
        $this->db->select('
            patent_master.patent_id,
            patent_master.patent_name,
            patent_master.fkmainuser_id,
            mainuser_master.mainuser_name,
            patent_master.fkbranch_id,
            branch_master.branch_name,
            patent_master.fkpatenttpye_id,
            patenttpye_master.patenttpye_name,
            patent_master.ApplicNo,
            patent_master.PRN,
            patent_master.Published,
            patent_master.PublicDate,
            patent_master.Granted,
            patent_master.GrantDate,
            patent_master.finicial_Year,
            patent_master.institute,
            patent_master.applicant_id,
            patent_master.applicant_type,
            patent_master.applicant_name
        ');
        $this->db->from('patent_master');
        $this->db->join('branch_master','patent_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('mainuser_master','patent_master.fkmainuser_id = mainuser_master.mainuser_id','left');
        $this->db->join('patenttpye_master','patent_master.fkpatenttpye_id = patenttpye_master.patenttpye_id','left');

        if (!empty($institu_id)) {
            $this->db->where('patent_master.institute', $institu_id);
        }
        
        if (!empty($branch_ids)) {
            $this->db->where_in('patent_master.fkbranch_id', $branch_ids);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }

        // If specific_year is provided (when clicking on year), filter by PublicDate year
        if (!empty($specific_year)) {
            $this->db->where('YEAR(patent_master.PublicDate)', $specific_year);
        } else {
            // FIX: Handle year array properly
            if (!empty($year) && $year != 0) {
                if (is_array($year)) {
                    // If year is array, use where_in
                    $this->db->where_in('patent_master.finicial_Year', $year);
                } else {
                    // If single value
                    $this->db->where('patent_master.finicial_Year', $year);
                }
            }
        }
        
        if (!empty($startdate) && !empty($enddate)) {
            $this->db->where("patent_master.PublicDate BETWEEN '$startdate' AND '$enddate'");
        }

        $this->db->order_by('patent_master.PublicDate', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!empty($branchIds)) {
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }
        
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}