<?php
class Si_Report1_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // Method to get year-wise count
    public function getYearWisePatentCount($institu_id, $branch_ids = null, $year = null)
    {
        $this->db->select("
            finiyear_master.finiYear_id,
            finiyear_master.fini_Label as year,
            COUNT(patent_master.patent_id) as count
        ");
        $this->db->from('patent_master');
        $this->db->join('branch_master','patent_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('finiyear_master','patent_master.finicial_Year = finiyear_master.finiYear_id','left');

        if (!empty($institu_id)) {
            $this->db->where('patent_master.institute', $institu_id);
        }

        if (!empty($branch_ids) && is_array($branch_ids)) {
            $this->db->where_in('patent_master.fkbranch_id', $branch_ids);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }

        // Selected year filter - only show selected years
        if (!empty($year) && is_array($year)) {
            $this->db->where_in('patent_master.finicial_Year', $year);
        }

        $this->db->where('patent_master.PublicDate IS NOT NULL');
        $this->db->group_by('patent_master.finicial_Year');
        $this->db->order_by('patent_master.finicial_Year', 'ASC');

        $query = $this->db->get();
        return $query->result();
    }

    public function getPatenttDataFiltered($institu_id, $branch_ids = null, $year = null, $specific_year_id = null)
    {
        $this->db->select('
            patent_master.patent_id,
            patent_master.patent_name,
            patent_master.fkmainuser_id,
            mainuser_master.mainuser_name,
            patent_master.fkbranch_id,
            branch_master.branch_name,
            patent_master.fkpatenttpye_id,
            patenttpye_master.patenttpye_name,
            patent_master.ApplicNo,
            patent_master.PRN,
            patent_master.Published,
            patent_master.PublicDate,
            patent_master.Granted,
            patent_master.GrantDate,
            patent_master.finicial_Year,
            finiyear_master.fini_Label,
            patent_master.institute,
            patent_master.applicant_id,
            patent_master.applicant_type,
            patent_master.applicant_name
        ');
        $this->db->from('patent_master');
        $this->db->join('branch_master','patent_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('mainuser_master','patent_master.fkmainuser_id = mainuser_master.mainuser_id','left');
        $this->db->join('patenttpye_master','patent_master.fkpatenttpye_id = patenttpye_master.patenttpye_id','left');
        $this->db->join('finiyear_master','patent_master.finicial_Year = finiyear_master.finiYear_id','left');

        if (!empty($institu_id)) {
            $this->db->where('patent_master.institute', $institu_id);
        }
        
        if (!empty($branch_ids) && is_array($branch_ids)) {
            $this->db->where_in('patent_master.fkbranch_id', $branch_ids);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }

        // If specific_year_id is provided (when clicking on year), filter by that financial year ID
        if (!empty($specific_year_id)) {
            $this->db->where('patent_master.finicial_Year', $specific_year_id);
        } else {
            // Handle year array properly
            if (!empty($year)) {
                if (is_array($year) && count($year) > 0) {
                    $this->db->where_in('patent_master.finicial_Year', $year);
                } else if (!is_array($year)) {
                    $this->db->where('patent_master.finicial_Year', $year);
                }
            }
        }

        $this->db->where('patent_master.PublicDate IS NOT NULL');
        $this->db->order_by('patent_master.PublicDate', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get branches from patent_master table only
    public function getbranch()
    {
        $this->db->select('branch_master.branch_id, branch_master.branch_name');
        $this->db->from('patent_master');
        $this->db->join('branch_master', 'patent_master.fkbranch_id = branch_master.branch_id', 'inner');
        $this->db->where('patent_master.is_active', 1);
        
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!empty($branchIds)) {
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }
        
        $this->db->group_by('branch_master.branch_id');
        $this->db->order_by('branch_master.branch_name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get years from patent_master table only
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('patent_master');
        $this->db->join('finiyear_master', 'patent_master.finicial_Year = finiyear_master.finiYear_id', 'inner');
        $this->db->where('patent_master.is_active', 1);
        
        $this->db->group_by('finiyear_master.finiYear_id');
        $this->db->order_by('finiyear_master.fini_Label', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}