<?php
class Si_Report2_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // Method to get year-wise count
    public function getYearWiseCount($institu_id, $branch_ids = null, $year = null)
    {
        $this->db->select("
            finiyear_master.finiYear_id,
            finiyear_master.fini_Label as year,
            COUNT(guestlectures_master.Guest_id) as count
        ");
        $this->db->from('guestlectures_master');
        $this->db->join('branch_master','guestlectures_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('finiyear_master','guestlectures_master.finicial_Year = finiyear_master.finiYear_id','left');

        if (!empty($institu_id)) {
            $this->db->where('guestlectures_master.institute', $institu_id);
        }

        if (!empty($branch_ids) && is_array($branch_ids)) {
            $this->db->where_in('guestlectures_master.fkbranch_id', $branch_ids);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }

        // Selected year filter - only show selected years
        if (!empty($year) && is_array($year)) {
            $this->db->where_in('guestlectures_master.finicial_Year', $year);
        }

        // $this->db->where('guestlectures_master.PublicDate IS NOT NULL');
        $this->db->group_by('guestlectures_master.finicial_Year');
        $this->db->order_by('guestlectures_master.finicial_Year', 'ASC');

        $query = $this->db->get();
        return $query->result();
    }

    public function gettDataFiltered($institu_id, $branch_ids = null, $year = null, $specific_year_id = null)
{
    $this->db->select('
        guestlectures_master.Guest_id,
        guestlectures_master.Expert_topic,
        guestlectures_master.Guest_name,
        designation_master.desig_name,
        guestlectures_master.oraganization,
        guestlectures_master.location,
        guestlectures_master.Talk_date,
        classmaster.classname,
        semester_master.Sem_Name,
        branch_master.branch_name,
        guestlectures_master.No_benefit,
        faculty_master.fac_Fullname,
        guestlectures_master.start_date,
        guestlectures_master.end_date,
        finiyear_master.fini_Label,
        guestlectures_master.finicial_Year
    ');
    
    $this->db->from('guestlectures_master');
    $this->db->join('branch_master', 'guestlectures_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('classmaster', 'classmaster.class_id = guestlectures_master.fkclass_id', 'left');
    $this->db->join('semester_master', 'guestlectures_master.fkSemID = semester_master.SemID', 'left');
    $this->db->join('faculty_master', 'guestlectures_master.fkfac_id = faculty_master.fac_id', 'left');
    $this->db->join('designation_master', 'designation_master.desig_id = guestlectures_master.fkdesig_id', 'left');
    $this->db->join('finiyear_master', 'guestlectures_master.finicial_Year = finiyear_master.finiYear_id', 'left');

    if (!empty($institu_id)) {
        $this->db->where('guestlectures_master.institute', $institu_id);
    }
    
    if (!empty($branch_ids) && is_array($branch_ids)) {
        $this->db->where_in('guestlectures_master.fkbranch_id', $branch_ids);
    } else {
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
        $this->db->where_in('branch_master.branch_id', $branchIds);
    }

    if (!empty($specific_year_id)) {
        $this->db->where('guestlectures_master.finicial_Year', $specific_year_id);
    } else {
        if (!empty($year)) {
            if (is_array($year) && count($year) > 0) {
                $this->db->where_in('guestlectures_master.finicial_Year', $year);
            } else if (!is_array($year)) {
                $this->db->where('guestlectures_master.finicial_Year', $year);
            }
        }
    }

    $this->db->order_by('guestlectures_master.Talk_date', 'DESC');
    $query = $this->db->get();
    return $query->result();
}

    // Get branches from guestlectures_master table only
    public function getbranch()
    {
        $this->db->select('branch_master.branch_id, branch_master.branch_name');
        $this->db->from('guestlectures_master');
        $this->db->join('branch_master', 'guestlectures_master.fkbranch_id = branch_master.branch_id', 'inner');
        $this->db->where('guestlectures_master.is_active', 1);
        
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!empty($branchIds)) {
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }
        
        $this->db->group_by('branch_master.branch_id');
        $this->db->order_by('branch_master.branch_name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get years from guestlectures_master table only
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('guestlectures_master');
        $this->db->join('finiyear_master', 'guestlectures_master.finicial_Year = finiyear_master.finiYear_id', 'inner');
        $this->db->where('guestlectures_master.is_active', 1);
        
        $this->db->group_by('finiyear_master.finiYear_id');
        $this->db->order_by('finiyear_master.fini_Label', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}