<?php
class Si_Report3_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // Method to get year-wise count
    public function getYearWiseCount($institu_id, $branch_ids = null, $year = null)
    {
        $this->db->select("
            finiyear_master.finiYear_id,
            finiyear_master.fini_Label as year,
            COUNT(vap_master.vap_id) as count
        ");
        $this->db->from('vap_master');
        $this->db->join('branch_master','vap_master.fkbranch_id = branch_master.branch_id','left');
        $this->db->join('finiyear_master','vap_master.finicial_Year = finiyear_master.finiYear_id','left');

        if (!empty($institu_id)) {
            $this->db->where('vap_master.institute', $institu_id);
        }

        if (!empty($branch_ids) && is_array($branch_ids)) {
            $this->db->where_in('vap_master.fkbranch_id', $branch_ids);
        } else {
            $branchIds = $this->session->userdata('fkBranch_Id');
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }

        // Selected year filter - only show selected years
        if (!empty($year) && is_array($year)) {
            $this->db->where_in('vap_master.finicial_Year', $year);
        }

        // $this->db->where('vap_master.PublicDate IS NOT NULL');
        $this->db->group_by('vap_master.finicial_Year');
        $this->db->order_by('vap_master.finicial_Year', 'ASC');

        $query = $this->db->get();
        return $query->result();
    }

    public function gettDataFiltered($institu_id, $branch_ids = null, $year = null, $specific_year_id = null)
{
    $this->db->select('vap_master.vap_id,
                    vap_master.prn,
                    vap_master.Student_name,
                    vap_master.fkbranch_id,
                    branch_master.branch_name,
                    vap_master.fkclass_id,
                    classmaster.classname,
                    vap_master.Division,
                    vap_master.Vap_tittle,
                    vap_master.resource_person_name,
                    vap_master.resource_person_contact,
                    vap_master.Company_name,
                    company_master.comp_name,
                    vap_master.Address, 
                    vap_master.finicial_Year,
                    finiyear_master.fini_Label,
                    vap_master.Feedback,
                    vap_master.Vap_Start,
                    vap_master.Vap_End');
                       
    $this->db->from('vap_master');
    $this->db->join('branch_master', 'vap_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('classmaster', 'vap_master.fkclass_id = classmaster.class_id', 'left');
    $this->db->join('company_master', 'vap_master.Company_name = company_master.ID', 'left');
    $this->db->join('finiyear_master', 'vap_master.finicial_Year = finiyear_master.finiYear_id', 'left');
   

    if (!empty($institu_id)) {
        $this->db->where('vap_master.institute', $institu_id);
    }
    
    if (!empty($branch_ids) && is_array($branch_ids)) {
        $this->db->where_in('vap_master.fkbranch_id', $branch_ids);
    } else {
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
        $this->db->where_in('branch_master.branch_id', $branchIds);
    }

    if (!empty($specific_year_id)) {
        $this->db->where('vap_master.finicial_Year', $specific_year_id);
    } else {
        if (!empty($year)) {
            if (is_array($year) && count($year) > 0) {
                $this->db->where_in('vap_master.finicial_Year', $year);
            } else if (!is_array($year)) {
                $this->db->where('vap_master.finicial_Year', $year);
            }
        }
    }

    // $this->db->order_by('vap_master.Talk_date', 'DESC');
    $query = $this->db->get();
    return $query->result();
}

    // Get branches from vap_master table only
    public function getbranch()
    {
        $this->db->select('branch_master.branch_id, branch_master.branch_name');
        $this->db->from('vap_master');
        $this->db->join('branch_master', 'vap_master.fkbranch_id = branch_master.branch_id', 'inner');
        $this->db->where('vap_master.is_active', 1);
        
        $branchIds = $this->session->userdata('fkBranch_Id');
        if (!empty($branchIds)) {
            if (!is_array($branchIds)) {
                $branchIds = explode(',', $branchIds);
            }
            $this->db->where_in('branch_master.branch_id', $branchIds);
        }
        
        $this->db->group_by('branch_master.branch_id');
        $this->db->order_by('branch_master.branch_name', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    // Get years from vap_master table only
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('vap_master');
        $this->db->join('finiyear_master', 'vap_master.finicial_Year = finiyear_master.finiYear_id', 'inner');
        $this->db->where('vap_master.is_active', 1);
        
        $this->db->group_by('finiyear_master.finiYear_id');
        $this->db->order_by('finiyear_master.fini_Label', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}