<?php
class Si_Report4_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    // Method to get year-wise count (removed branch filter)
    public function getYearWiseCount($institu_id, $year = null)
    {
        $this->db->select("
            finiyear_master.finiYear_id,
            finiyear_master.fini_Label as year,
            COUNT(nss_master.NssAct_ID) as count
        ");
        $this->db->from('nss_master');
        $this->db->join('finiyear_master','nss_master.Financial_Year = finiyear_master.finiYear_id','left');

        if (!empty($institu_id)) {
            $this->db->where('nss_master.Institute_id', $institu_id);
        }

        // Selected year filter - only show selected years
        if (!empty($year) && is_array($year)) {
            $this->db->where_in('nss_master.Financial_Year', $year);
        }

        $this->db->where('nss_master.ActDate IS NOT NULL');
        $this->db->group_by('nss_master.Financial_Year');
        $this->db->order_by('nss_master.Financial_Year', 'ASC');

        $query = $this->db->get();
        return $query->result();
    }

    public function getDataFiltered($institu_id, $year = null, $specific_year_id = null)
    {
        $this->db->select('
        nss_master.NssAct_ID,
        nss_master.NssActName,
        nss_master.PlaceOFAct,
        nss_master.SPOCName,
        nss_master.Month,
        nss_master.ActDate,
        nss_master.StudPart,
        nss_master.Report_Flag,
        nss_master.Report_pdf,
        nss_master.Activity_Status,
        nss_master.Department,
        nss_master.Financial_Year,
        branch_master.branch_name,
        finiyear_master.fini_Label,
        institute_master.Institu_name
    ');
        $this->db->from('nss_master');
        $this->db->join('branch_master','nss_master.Department = branch_master.branch_id','left');
        $this->db->join('institute_master','nss_master.Institute_id = institute_master.Institu_id','left');
        $this->db->join('finiyear_master','nss_master.Financial_Year = finiyear_master.finiYear_id','left');

        if (!empty($institu_id)) {
            $this->db->where('nss_master.Institute_id', $institu_id);
        }

        // If specific_year_id is provided (when clicking on year), filter by that financial year ID
        if (!empty($specific_year_id)) {
            $this->db->where('nss_master.Financial_Year', $specific_year_id);
        } else {
            // Handle year array properly
            if (!empty($year)) {
                if (is_array($year) && count($year) > 0) {
                    $this->db->where_in('nss_master.Financial_Year', $year);
                } else if (!is_array($year)) {
                    $this->db->where('nss_master.Financial_Year', $year);
                }
            }
        }

        $this->db->where('nss_master.ActDate IS NOT NULL');
        $this->db->order_by('nss_master.ActDate', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get years from nss_master table only
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('nss_master');
        $this->db->join('finiyear_master', 'nss_master.Financial_Year = finiyear_master.finiYear_id', 'inner');
        $this->db->where('nss_master.is_active', 1);
        
        $this->db->group_by('finiyear_master.finiYear_id');
        $this->db->order_by('finiyear_master.fini_Label', 'ASC');
        
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }
}