<?php
  class Soft_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
      public function insertdata($model)
	{
		return $this->db->insert('software_master',$model);
			//return $sql->result();
	} 


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');
 
    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getduration()
     {
      $this->db->select('internduration_master.*,');
      $this->db->from('internduration_master');
       $query = $this->db->get();
        return $query->result();
     }
    


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


     



public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $duration_ids = [], $startdate = null, $enddate = null,
$licence_withlicence = null)
{
    $this->db->select('
        software_master.*, 
        branch_master.branch_name, 
internduration_master.duration_type');

    $this->db->from('software_master');
    $this->db->join('branch_master', 'branch_master.branch_id = software_master.fk_branch', 'left');
       $this->db->join('internduration_master', 'software_master.fk_duration = internduration_master.duration_id', 'left');
   

    $this->db->where('software_master.Institute', $institute_id);

    if (!empty($branch_ids)) {
        $this->db->where_in('software_master.fk_branch', $branch_ids);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
   
    }
// new code end
 

if (!empty($duration_ids)) {
    $this->db->where_in('software_master.fk_duration', $duration_ids);
}

    
    if (!empty($year_id)) {
    $this->db->where('software_master.Financial_Year', $year_id);
}

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('software_master.Insta_date >=', $startdate);
        $this->db->where('software_master.Insta_date <=', $enddate);
    }

      if (!empty($licence_withlicence)) {  
        $this->db->where('software_master.licence_withlicence', $licence_withlicence);
    }

        $this->db->order_by('software_master.Insta_date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

  // chart code
 
 
    public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("software_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = software_master.Financial_Year")
        ->group_by("software_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
// public function getSingleYearData($yearId)
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
//         ->from("software_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = software_master.Financial_Year")
//         ->where("software_master.Financial_Year", $yearId)
//         ->group_by("software_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 
// public function getYearwiseTypes($yearId)
// {
//     return $this->db->select("software_master.soft_id, software_master.soft_name, finiyear_master.fini_Label as year,")
//         ->from("software_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = software_master.Financial_Year")
//      ->where("software_master.Financial_Year", $yearId)
//         ->get()
//         ->result_array();
// }
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
        ->from("software_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = software_master.Financial_Year")
        ->where("software_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('software_master.fk_branch', (array)$branches);
    }
   else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('software_master.fk_branch', explode(',', $branchIds));
    }
}
 
    $this->db->group_by("software_master.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}
 
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("software_master.soft_id, software_master.soft_name, finiyear_master.fini_Label as year,")
        ->from("software_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = software_master.Financial_Year")
                // ->join('student_reg', 'student_reg.Student_id = software_master.fk_student')
        ->where("software_master.Financial_Year", $yearId);
 
    
    if (!empty($branches)) {
        $this->db->where_in('software_master.fk_branch', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('software_master.fk_branch', explode(',', $branchIds));
    }
}
    
 
    return $this->db->get()->result_array();
}

  public function getBranchwiseCount($institu = null, $branches = [], $year = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(software_master.soft_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('software_master', 'branch_master.branch_id = software_master.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('software_master.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
     // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');
 
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }
 
        $this->db->where_in('branch_master.branch_id', $branchIds);
   
    }
// new code end
 
    if (!empty($year) && $year != 0) {
        $this->db->where('software_master.Financial_Year', $year);
    }
    
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null)
{
    $this->db->select('software_master.soft_name,
                       software_master.soft_id,
                       software_master.fk_branch,
                       branch_master.branch_name,
                        ');
    $this->db->from('software_master');
    $this->db->join('branch_master', 'branch_master.branch_id = software_master.fk_branch', 'left');

   if (is_array($branch_id)) {
    $this->db->where_in('software_master.fk_branch', $branch_id);
} else {
    $this->db->where('software_master.fk_branch', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('software_master.fkInstitName_id', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('software_master.Financial_Year', $year);
    // }

  if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('software_master.Financial_Year', $year);
    } else {
        $this->db->where('software_master.Financial_Year', $year);
    }
}
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("software_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.soft_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('software_master sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.soft_id) as count");
    $this->db->from("software_master sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.fkInstitName_id', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
    

}