<?php
  class Sttp_Fdp_report_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
    


     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }

     public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }

      public function getduration()
     {
      $this->db->select('internduration_master.*,');
      $this->db->from('internduration_master');
       $query = $this->db->get();
        return $query->result();
     }
    


      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }


     public function gettype()
     {
      $this->db->select('type_sttp.typeID,type_sttp.type_name,');
      $this->db->from('type_sttp');
       $query = $this->db->get();
        return $query->result();
     }

public function getFormTypes()
{
    return $this->db
        ->select('DISTINCT(form_type) as form_type')
        ->from('sttp_master')
        ->where('is_active', 1)
        ->get()
        ->result();
}


public function getDataByInstitute($institute_id,  $year_id, $branch_ids = [], $duration_ids = [], $typeIDs = [], $startdate = null, $enddate = null, $form_type = null
)
{
    $this->db->select('
        sttp_master.*, 
        branch_master.branch_name, 
internduration_master.duration_type,
type_sttp.type_name,');

    $this->db->from('sttp_master');
    $this->db->join('branch_master', 'branch_master.branch_id = sttp_master.fk_branch', 'left');
       $this->db->join('internduration_master', 'sttp_master.fk_duration = internduration_master.duration_id', 'left');
     $this->db->join('type_sttp', 'sttp_master.fk_typest = type_sttp.typeID', 'left');

    $this->db->where('sttp_master.Institute', $institute_id);

    if (!empty($form_type)) {
    $this->db->where('sttp_master.form_type', $form_type);
}


    if (!empty($branch_ids)) {
        $this->db->where_in('sttp_master.fk_branch', $branch_ids);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

if (!empty($duration_ids)) {
    $this->db->where_in('sttp_master.fk_duration', $duration_ids);
}


if (!empty($typeIDs)) {
    $this->db->where_in('sttp_master.fk_typest', $typeIDs);
}
    
    if (!empty($year_id)) {
    $this->db->where('sttp_master.Financial_Year', $year_id);
}

if (!empty($startdate) && !empty($enddate)) {
        $this->db->where('sttp_master.start_date >=', $startdate);
        $this->db->where('sttp_master.end_date <=', $enddate);
    }

    
        $this->db->order_by('sttp_master.start_date','DESC');
    $query = $this->db->get();
    return $query->result();
}

// for print
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}

public function getAllYearsData($form_type = null)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(sttp_master.stt_id) as count")
        ->from("sttp_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = sttp_master.Financial_Year");
    
    if (!empty($form_type)) {
        $this->db->where('sttp_master.form_type', $form_type);
    }
    
    return $this->db->group_by("sttp_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}

public function getSingleYearData($yearId, $branches = [], $form_type = null)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(sttp_master.stt_id) as count")
        ->from("sttp_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = sttp_master.Financial_Year")
        ->where("sttp_master.Financial_Year", $yearId);
 
    if (!empty($branches)) {
        $this->db->where_in('sttp_master.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sttp_master.fk_branch', explode(',', $branchIds));
    }
}
    
    if (!empty($form_type)) {
        $this->db->where('sttp_master.form_type', $form_type);
    }
 
    $this->db->group_by("sttp_master.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
    return $this->db->get()->result_array();
}

public function getYearwiseTypes($yearId, $branches = [], $form_type = null)
{
    $this->db->select("sttp_master.stt_id, sttp_master.sttp_name, sttp_master.document, finiyear_master.fini_Label as year,
    sttp_master.start_date,
                       sttp_master.end_date,
internduration_master.duration_type,type_sttp.type_name,branch_master.branch_name,")
        ->from("sttp_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = sttp_master.Financial_Year")
        ->join('type_sttp', 'sttp_master.fk_typest = type_sttp.typeID', 'left')
        ->join('internduration_master', 'sttp_master.fk_duration = internduration_master.duration_id', 'left')
       ->join('branch_master', 'branch_master.branch_id = sttp_master.fk_branch', 'left')
        ->where("sttp_master.Financial_Year", $yearId);
 
    if (!empty($branches)) {
        $this->db->where_in('sttp_master.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sttp_master.fk_branch', explode(',', $branchIds));
    }
}
    
    if (!empty($form_type)) {
        $this->db->where('sttp_master.form_type', $form_type);
    }
 
    return $this->db->get()->result_array();
}

public function getBranchwiseCount($institu = null, $branches = [], $year = null, $form_type = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(sttp_master.stt_id) as student_count');
    $this->db->from('branch_master');
    $this->db->join('sttp_master', 'branch_master.branch_id = sttp_master.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sttp_master.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('sttp_master.Financial_Year', $year);
    }
    if (!empty($form_type)) {
        $this->db->where('sttp_master.form_type', $form_type);
    }
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}

public function getBranchDetailsData($branch_id, $institu = null, $year = null, $form_type = null)
{
    $this->db->select('sttp_master.sttp_name,
                       sttp_master.stt_id,
                       sttp_master.fk_branch,
                       sttp_master.start_date,
                       sttp_master.end_date,
                       sttp_master.document,
internduration_master.duration_type,type_sttp.type_name,
                       branch_master.branch_name');
    $this->db->from('sttp_master');
    $this->db->join('branch_master', 'branch_master.branch_id = sttp_master.fk_branch', 'left');
    $this->db->join('internduration_master', 'sttp_master.fk_duration = internduration_master.duration_id', 'left');
    $this->db->join('type_sttp', 'sttp_master.fk_typest = type_sttp.typeID', 'left');

    if (is_array($branch_id)) {
        $this->db->where_in('sttp_master.fk_branch', $branch_id);
    } else {
        $this->db->where('sttp_master.fk_branch', $branch_id);
    }
 
    if (!empty($institu)) {
        $this->db->where('sttp_master.Institute', $institu);
    }
    
    if (!empty($year)) {
        if (is_array($year)) {
            $this->db->where_in('sttp_master.Financial_Year', $year);
        } else {
            $this->db->where('sttp_master.Financial_Year', $year);
        }
    }
    
    if (!empty($form_type)) {
        $this->db->where('sttp_master.form_type', $form_type);
    }
 
    return $this->db->get()->result();
}

public function getCombinedData($institu = null, $branches = [], $years = [], $form_type = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sp.stt_id) as student_count');
    $this->db->from('branch_master b');
    $this->db->join('sttp_master sp', 'b.branch_id = sp.fk_branch', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sp.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
    if (!empty($form_type)) {
        $this->db->where('sp.form_type', $form_type);
    }
   
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.stt_id) as count");
    $this->db->from("sttp_master sp");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sp.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sp.fk_branch', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_branch', explode(',', $branchIds));
    }
}

    if (!empty($years)) {
        $this->db->where_in('sp.Financial_Year', (array)$years);
    }
    if (!empty($form_type)) {
        $this->db->where('sp.form_type', $form_type);
    }
   
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}

  // chart code
 
 
//     public function getAllYearsData()
// {
//     return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(sttp_master.stt_id) as count")
//         ->from("sttp_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = sttp_master.Financial_Year")
//         ->group_by("sttp_master.Financial_Year, fini_Label, finiyear_master.finiYear_id")
//         ->get()
//         ->result_array();
// }
 

 
// public function getSingleYearData($yearId, $branches = [],)
// {
//     $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(sttp_master.stt_id) as count")
//         ->from("sttp_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = sttp_master.Financial_Year")
//         ->where("sttp_master.Financial_Year", $yearId);
 
    
//     if (!empty($branches)) {
//         $this->db->where_in('sttp_master.fk_branch', (array)$branches);
//     }
  
 
//     $this->db->group_by("sttp_master.Financial_Year, fini_Label, finiyear_master.finiYear_id");
 
//     return $this->db->get()->result_array();
// }
 
 
// public function getYearwiseTypes($yearId, $branches = [],)
// {
//     $this->db->select("sttp_master.stt_id, sttp_master.sttp_name, finiyear_master.fini_Label as year,
//     sttp_master.start_date,
//                        sttp_master.end_date,
// internduration_master.duration_type,type_sttp.type_name,branch_master.branch_name,")
//         ->from("sttp_master")
//         ->join("finiyear_master", "finiyear_master.finiYear_id = sttp_master.Financial_Year")
//         ->join('type_sttp', 'sttp_master.fk_typest = type_sttp.typeID', 'left')
//         ->join('internduration_master', 'sttp_master.fk_duration = internduration_master.duration_id', 'left')
//        ->join('branch_master', 'branch_master.branch_id = sttp_master.fk_branch', 'left')
//         ->where("sttp_master.Financial_Year", $yearId);
 
    
//     if (!empty($branches)) {
//         $this->db->where_in('sttp_master.fk_branch', (array)$branches);
//     }
    
 
//     return $this->db->get()->result_array();
// }

//   public function getBranchwiseCount($institu = null, $branches = [], $year = null)
// {
//     $this->db->select('branch_master.branch_id,
//                        branch_master.branch_name,
//                        COUNT(sttp_master.stt_id) as student_count');
//     $this->db->from('branch_master');
//     $this->db->join('sttp_master', 'branch_master.branch_id = sttp_master.fk_branch', 'left');
 
//     if (!empty($institu)) {
//         $this->db->where('sttp_master.fkInstitName_id', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('branch_master.branch_id', (array)$branches);
//     }
//     if (!empty($year) && $year != 0) {
//         $this->db->where('sttp_master.Financial_Year', $year);
//     }
    
 
//     $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
//     $this->db->order_by('branch_master.branch_name', 'ASC');
 
//     return $this->db->get()->result();
// }
 
// public function getBranchDetailsData($branch_id, $institu = null, $year = null)
// {
//     $this->db->select('sttp_master.sttp_name,
//                        sttp_master.stt_id,
//                        sttp_master.fk_branch,
//                        sttp_master.start_date,
//                        sttp_master.end_date,
// internduration_master.duration_type,type_sttp.type_name,
//                        branch_master.branch_name,
                       
//                         ');
//     $this->db->from('sttp_master');
//     $this->db->join('branch_master', 'branch_master.branch_id = sttp_master.fk_branch', 'left');
//  $this->db->join('internduration_master', 'sttp_master.fk_duration = internduration_master.duration_id', 'left');
//          $this->db->join('type_sttp', 'sttp_master.fk_typest = type_sttp.typeID', 'left');

//    if (is_array($branch_id)) {
//     $this->db->where_in('sttp_master.fk_branch', $branch_id);
// } else {
//     $this->db->where('sttp_master.fk_branch', $branch_id);
// }
 
 
//     if (!empty($institu)) {
//         $this->db->where('sttp_master.fkInstitName_id', $institu);
//     }
//     // if (!empty($year) && $year != 0) {
//     //     $this->db->where('sttp_master.Financial_Year', $year);
//     // }

//   if (!empty($year)) {
//     if (is_array($year)) {
//         $this->db->where_in('sttp_master.Financial_Year', $year);
//     } else {
//         $this->db->where('sttp_master.Financial_Year', $year);
//     }
// }
    
//     if (!empty($startDate) && !empty($endDate)) {
//         $this->db->where("sttp_master.created_at BETWEEN '$startDate' AND '$endDate'");
//     }
 
//     return $this->db->get()->result();
// }
 
//  public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
// {
//     $response = [];
 
//     // --- 1. Branchwise Count ---
//     $this->db->select('b.branch_id, b.branch_name, COUNT(sp.stt_id) as student_count');
//     $this->db->from('branch_master b');
//     $this->db->join('sttp_master sp', 'b.branch_id = sp.fk_branch', 'left');
 
//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitName_id', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('b.branch_id', (array)$branches);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sp.Financial_Year', (array)$years);
//     }
   
//     $this->db->group_by('b.branch_id, b.branch_name');
//     $this->db->order_by('b.branch_name', 'ASC');
//     $response['branchData'] = $this->db->get()->result();
 
//     // --- 2. Yearwise Count ---
//     $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.stt_id) as count");
//     $this->db->from("sttp_master sp");
//     $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.Financial_Year");
 
//     if (!empty($institu)) {
//         $this->db->where('sp.fkInstitName_id', $institu);
//     }
//     if (!empty($branches)) {
//         $this->db->where_in('sp.fk_branch', (array)$branches);
//     }
//     if (!empty($years)) {
//         $this->db->where_in('sp.Financial_Year', (array)$years);
//     }
   
//     $this->db->group_by("fy.finiYear_id, fy.fini_Label");
//     $this->db->order_by("fy.finiYear_id", "ASC");
//     $response['yearData'] = $this->db->get()->result();
 
//     return $response;
// }
    
// public function getStudentsByMeetId($fk_sttID)
// {
//     return $this->db->select('fac_name, fac_thumb')
//                     ->from('sttp_faculty')
//                     ->where('fk_sttID', $fk_sttID)
//                     ->get()
//                     ->result_array();
// }
 

}