<?php
  class StudComp_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  
  public function insertdata($data) {
    $this->db->insert('studcomp_master', $data);
    return $this->db->insert_id();
}


 public function getdetailStudComp()
{
    $this->db->select('
        studcomp_master.*,
        department_master.dep_name,
        branch_master.branch_name,
        complaintcat_master.Comp_name,
         gender_master.gender_name
    ');
    $this->db->from('studcomp_master');
    $this->db->join('department_master', 'department_master.dep_id = studcomp_master.fkdep_id', 'left');
    $this->db->join('branch_master', 'branch_master.branch_id = studcomp_master.fkbranch_id', 'left');
    $this->db->join('gender_master', 'gender_master.gender_id = studcomp_master.fkgender_id', 'left');
    $this->db->join('complaintcat_master', 'complaintcat_master.Comp_id = studcomp_master.fkComp_id', 'left');
    $this->db->where('studcomp_master.is_active', '1');
    $this->db->order_by('studcomp_master.StudComp_id', 'ASC');
    $query = $this->db->get();
    return $query->result();
}

  
 public function getbyid($id)
{
    $this->db->select('
        studcomp_master.*,
        department_master.dep_name,
        branch_master.branch_name,
        complaintcat_master.Comp_name,
          gender_master.gender_name
    ');
    $this->db->from('studcomp_master');
    $this->db->join('department_master', 'department_master.dep_id = studcomp_master.fkdep_id', 'left');
    $this->db->join('branch_master', 'branch_master.branch_id = studcomp_master.fkbranch_id', 'left');
    $this->db->join('gender_master', 'gender_master.gender_id = studcomp_master.fkgender_id', 'left');
    $this->db->join('complaintcat_master', 'complaintcat_master.Comp_id = studcomp_master.fkComp_id', 'left');
    $this->db->where('studcomp_master.StudComp_id', $id);
    $query = $this->db->get();
    return $query->result();
}

  
  public function update($model)
  {
     return $sql = $this->db->where('StudComp_id',$model['StudComp_id'])->update('studcomp_master',$model); 
  } 

    public function get_all_genders()
{
    return $this->db->get('gender_master')->result();
}

public function get_all_complaint_categories()
{
    return $this->db->get('complaintcat_master')->result();
}

public function get_all_Branch()
{
    return $this->db->get('branch_master')->result();
}
public function get_all_class()
{
    return $this->db->get('classmaster')->result();
}
public function getComplaintById($id) {
    return $this->db->get_where('studcomp_master', ['StudComp_id' => $id])->row();
}

public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
}



}