<?php
class StudentFeedback_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }

    // Insert basic data
    public function insertdata($model)
    {
        return $this->db->insert('student_feedback_urls', $model);
    }

    // Get institute data
    public function getinstitute()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    // Get hostel data
    public function getHostel()
    {
        $this->db->select('hostel_master.*');
        $this->db->from('hostel_master');
        $query = $this->db->get();
        return $query->result();
    }

    // Get year data
    public function getyear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('finiyear_master');
        $this->db->order_by('finiYear_id', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get active year
    public function getActiveYear()
    {
        $this->db->select('finiyear_master.finiYear_id, finiyear_master.fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        return $this->db->get()->row();
    }

    // Get by ID
    public function getbyid($id)
    {
        $this->db->select("student_feedback_urls.*");
        $this->db->where('url_id', $id);
        $query = $this->db->get('student_feedback_urls');
        return $query->result();
    }
    
    // Update data
    public function update($model)
    {
        return $this->db->where('url_id', $model['url_id'])->update('student_feedback_urls', $model); 
    }

    // ==================== NEW FUNCTIONS FOR URL MANAGEMENT ====================

    /**
     * Save generated URL
     */

    public function saveGeneratedURL($data)
{
    // Generate unique token
    $token = $this->generateUniqueToken();
    
    $insert_data = array(
        'fkInsitute_id' => $data['institute_id'],
        'fkHostelType_id' => $data['hostel_type'],
        'FiniYear' => $data['year'],
        'generated_url' => $data['url'],
        'url_token' => $token,
        'is_active' => isset($data['is_active']) ? $data['is_active'] : 1,  // Handle is_active
        'created_by' => $this->session->userdata('user_id'),
        'created_at' => date('Y-m-d H:i:s'),
        'expires_at' => isset($data['expires_at']) ? $data['expires_at'] : NULL
    );
    
    if ($this->db->insert('student_feedback_urls', $insert_data)) {
        return array(
            'status' => true,
            'url_id' => $this->db->insert_id(),
            'token' => $token
        );
    }
    
    return array('status' => false);
}
    // public function saveGeneratedURL($data)
    // {
    //     // Generate unique token
    //     $token = $this->generateUniqueToken();
        
    //     $insert_data = array(
    //         'fkInsitute_id' => $data['institute_id'],
    //         'fkHostelType_id' => $data['hostel_type'],
    //         'FiniYear' => $data['year'],
    //         'generated_url' => $data['url'],
    //         'url_token' => $token,
    //         'is_active' => 1,
    //         'created_by' => $this->session->userdata('user_id'), // assuming you have session
    //         'created_at' => date('Y-m-d H:i:s'),
    //         'expires_at' => isset($data['expires_at']) ? $data['expires_at'] : NULL
    //     );
        
    //     if ($this->db->insert('student_feedback_urls', $insert_data)) {
    //         return array(
    //             'status' => true,
    //             'url_id' => $this->db->insert_id(),
    //             'token' => $token
    //         );
    //     }
        
    //     return array('status' => false);
    // }

    /**
     * Generate unique token for URL
     */
    private function generateUniqueToken()
    {
        do {
            $token = bin2hex(random_bytes(16)); // 32 character token
            $this->db->where('url_token', $token);
            $query = $this->db->get('student_feedback_urls');
        } while ($query->num_rows() > 0);
        
        return $token;
    }

    /**
     * Check if URL already exists for hostel and year combination
     */
    public function checkExistingURL($hostel_type, $year, $institute_id = null)
    {
        $this->db->select('*');
        $this->db->from('student_feedback_urls');
        $this->db->where('fkHostelType_id', $hostel_type);
        $this->db->where('FiniYear', $year);
        $this->db->where('is_active', 1);
        
        if ($institute_id) {
            $this->db->where('fkInsitute_id', $institute_id);
        }
        
        $query = $this->db->get();
        return $query->row();
    }

    /**
     * Get all generated URLs
     */
    public function getAllGeneratedURLs()
    {
        $this->db->select('student_feedback_urls.*, 
                          institute_master.Institu_name,
                          hostel_master.Hostel_Name,
                          finiyear_master.fini_Label');
        $this->db->from('student_feedback_urls');
        $this->db->join('institute_master', 'student_feedback_urls.fkInsitute_id = institute_master.Institu_id', 'left');
        $this->db->join('hostel_master', 'student_feedback_urls.fkHostelType_id = hostel_master.Hostel_id', 'left');
        $this->db->join('finiyear_master', 'student_feedback_urls.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->order_by('student_feedback_urls.created_at', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    /**
     * Get URL by token
     */
    public function getURLByToken($token)
    {
        $this->db->select('student_feedback_urls.*, 
                          institute_master.Institu_name,
                          hostel_master.Hostel_Name,
                          finiyear_master.fini_Label');
        $this->db->from('student_feedback_urls');
        $this->db->join('institute_master', 'student_feedback_urls.fkInsitute_id = institute_master.Institu_id', 'left');
        $this->db->join('hostel_master', 'student_feedback_urls.fkHostelType_id = hostel_master.Hostel_id', 'left');
        $this->db->join('finiyear_master', 'student_feedback_urls.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->where('student_feedback_urls.url_token', $token);
        $this->db->where('student_feedback_urls.is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

    /**
     * Validate URL (check if active and not expired)
     */
    public function validateURL($token)
    {
        $this->db->select('*');
        $this->db->from('student_feedback_urls');
        $this->db->where('url_token', $token);
        $this->db->where('is_active', 1);
        
        // Check expiration
        $this->db->group_start();
        $this->db->where('expires_at IS NULL');
        $this->db->or_where('expires_at >', date('Y-m-d H:i:s'));
        $this->db->group_end();
        
        $query = $this->db->get();
        return $query->row();
    }

    /**
     * Update response count
     */
    public function incrementResponseCount($url_id)
    {
        $this->db->set('total_responses', 'total_responses + 1', FALSE);
        $this->db->where('url_id', $url_id);
        return $this->db->update('student_feedback_urls');
    }

    /**
     * Deactivate URL
     */
    public function deactivateURL($url_id)
    {
        $data = array(
            'is_active' => 0,
            'updated_at' => date('Y-m-d H:i:s')
        );
        
        $this->db->where('url_id', $url_id);
        return $this->db->update('student_feedback_urls', $data);
    }

    /**
     * Update URL
     */
 public function updateURL($url_id, $data)
{
    $data['updated_at'] = date('Y-m-d H:i:s');
    $this->db->where('url_id', $url_id);  // Make sure this matches your table column
    return $this->db->update('student_feedback_urls', $data);
}

    /**
     * Delete URL
     */
    public function deleteURL($url_id)
    {
        $this->db->where('url_id', $url_id);
        return $this->db->delete('student_feedback_urls');
    }

    /**
     * Get URLs by institute
     */
    public function getURLsByInstitute($institute_id)
    {
        $this->db->select('student_feedback_urls.*, 
                          hostel_master.Hostel_Name,
                          finiyear_master.fini_Label');
        $this->db->from('student_feedback_urls');
        $this->db->join('hostel_master', 'student_feedback_urls.fkHostelType_id = hostel_master.Hostel_id', 'left');
        $this->db->join('finiyear_master', 'student_feedback_urls.FiniYear = finiyear_master.finiYear_id', 'left');
        $this->db->where('student_feedback_urls.fkInsitute_id', $institute_id);
        $this->db->order_by('student_feedback_urls.created_at', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }

    
}
?>