<?php
class Student_Counseling_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
        // DEBUGGING: इसे उत्पादन (production) में FALSE कर दें। 
        // TRUE रखने से DB त्रुटियाँ सीधे दिखाई देंगी।
        $this->db->db_debug = TRUE; 
    }

    public function insertdata($model)
    {
        $this->db->insert('student_counseling', $model);
        return $this->db->affected_rows() > 0;
    }

    public function insertDetail($model)
    {
        $this->db->insert('student_counseling_detail', $model);
        return $this->db->affected_rows() > 0;
    }

    public function getdetailview()
    {
        $this->db->select('student_counseling.*, 
                              counseling_type_master.counseling_name,
                              branch_master.branch_name,
                              finiyear_master.fini_Label');
        $this->db->from('student_counseling');
        $this->db->join('counseling_type_master', 
                        'student_counseling.fk_counseling_type = counseling_type_master.counseling_id', 
                        'left');
        $this->db->join('branch_master', 
                        'student_counseling.fk_department = branch_master.branch_id', 
                        'left');
        $this->db->join('finiyear_master', 
                        'student_counseling.fk_year = finiyear_master.finiYear_id', 
                        'left');
// new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end

        $this->db->order_by('student_counseling.stud_counseling_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getbyid($id)
    {
        $this->db->select('student_counseling.*, 
                         counseling_type_master.counseling_name,
                         department_master.dep_name,
                         finiyear_master.fini_Label');
        $this->db->from('student_counseling');
        $this->db->join('counseling_type_master', 
                         'student_counseling.fk_counseling_type = counseling_type_master.counseling_id', 
                         'left');
        $this->db->join('department_master', 
                         'student_counseling.fk_department = department_master.dep_id', 
                         'left');
        $this->db->join('finiyear_master', 
                         'student_counseling.fk_year = finiyear_master.finiYear_id', 
                         'left');
        $this->db->where('student_counseling.stud_counseling_id', $id);
        $query = $this->db->get();
        return $query->result(); 
    }

    public function update($model)
    {
        $this->db->where('stud_counseling_id', $model['stud_counseling_id']);
        $update_data = $model;
        unset($update_data['stud_counseling_id']); 
        
        $this->db->update('student_counseling', $update_data);
        
        // यदि कोई DB Error नहीं है, तो इसे सफल मानते हैं, भले ही affected_rows 0 हो।
        if ($this->db->error()['code'] != 0) {
            return false;
        }
        return true; 
    }

    public function getDetailByMainId($counseling_id)
    {
        $this->db->select('*');
        $this->db->from('student_counseling_detail');
        $this->db->where('fk_counseling_id', $counseling_id);
        $query = $this->db->get();
        return $query->result();
    }

    public function updateDetail($id, $data)
    {
        $this->db->where('counseling_detail_id', $id);
        $this->db->update('student_counseling_detail', $data);
        return true; // केवल DB error होने पर ही false return करें, क्योंकि detail update में 0 rows affected होना सामान्य है।
    }

    public function deleteDetail($id)
    {
        $this->db->where('counseling_detail_id', $id);
        $this->db->delete('student_counseling_detail');
        return $this->db->affected_rows() > 0;
    }

    public function getCounselingTypes()
    {
        $this->db->select('counseling_type_master.*');
        $this->db->from('counseling_type_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('counseling_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function insertCounselingType($model)
    {
        $this->db->insert('counseling_type_master', $model);
        return $this->db->affected_rows() > 0;
    }

    public function getDepartments()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end

        $this->db->where('is_active', 1);
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getActiveYear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->where('Active_Deactive', 1);
        $query = $this->db->get();
        return $query->row();
    }
}