<?php
class Student_Counseling_report_model extends CI_Model
{
    public function __construct()
    {
        $this->load->database();
    }

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $query = $this->db->get();
        return $query->result();
    }

    public function getinstitu()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getCounselingTypes()
    {
        $this->db->select('counseling_type_master.*');
        $this->db->from('counseling_type_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('counseling_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // FIXED: Main method for getting data
    public function getDataByInstitute($institute_id, $year_id, $branch_ids = [], $typeIDs = [], $startdate = null, $enddate = null)
    {
        // Enable query debugging
        $this->db->select('
            student_counseling.*, 
            branch_master.branch_name, 
            counseling_type_master.counseling_name,
            student_counseling.stud_counseling_id,
            student_counseling.faculty_name,
            student_counseling.faculty_thumb,
            student_counseling.counseling_date,
            student_counseling.pdf_file
        ');

        $this->db->from('student_counseling');
        $this->db->join('branch_master', 'branch_master.branch_id = student_counseling.fk_department', 'left');
        
        // FIXED: Use consistent column name (counseling_id)
        $this->db->join('counseling_type_master', 'student_counseling.fk_counseling_type = counseling_type_master.counseling_id', 'left');

        // FIXED: Check the actual column name in your database
        // Change this based on your actual column name in student_counseling table
        if (!empty($institute_id)) {
            $this->db->where('student_counseling.fkInstitu_id', $institute_id);
        }

        if (!empty($branch_ids) && is_array($branch_ids)) {
            $this->db->where_in('student_counseling.fk_department', $branch_ids);
        }
        // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

        if (!empty($typeIDs) && is_array($typeIDs)) {
            $this->db->where_in('student_counseling.fk_counseling_type', $typeIDs);
        }

        if (!empty($year_id) && $year_id != '0') {
            $this->db->where('student_counseling.fk_year', $year_id);
        }

        if (!empty($startdate) && !empty($enddate)) {
            $this->db->where('student_counseling.counseling_date >=', $startdate);
            $this->db->where('student_counseling.counseling_date <=', $enddate);
        }

        $this->db->order_by('student_counseling.counseling_date', 'DESC');
        
        $query = $this->db->get();
        
        // Debug: Log the query
        log_message('debug', 'Query: ' . $this->db->last_query());
        
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }

    public function getAllYearsData()
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(student_counseling.stud_counseling_id) as count")
            ->from("student_counseling")
            ->join("finiyear_master", "finiyear_master.finiYear_id = student_counseling.fk_year")
            ->group_by("student_counseling.fk_year, fini_Label, finiyear_master.finiYear_id")
            ->get()
            ->result_array();
    }

    public function getSingleYearData($yearId, $branches = [])
    {
        $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(student_counseling.stud_counseling_id) as count")
            ->from("student_counseling")
            ->join("finiyear_master", "finiyear_master.finiYear_id = student_counseling.fk_year")
            ->where("student_counseling.fk_year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('student_counseling.fk_department', (array) $branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('student_counseling.fk_department', explode(',', $branchIds));
    }
}

        $this->db->group_by("student_counseling.fk_year, fini_Label, finiyear_master.finiYear_id");

        return $this->db->get()->result_array();
    }

    public function getYearwiseTypes($yearId, $branches = [])
    {
        $this->db->select("
            student_counseling.stud_counseling_id, 
            student_counseling.faculty_name, 
            student_counseling.pdf_file,
            student_counseling.faculty_thumb,
            finiyear_master.fini_Label as year,
            counseling_type_master.counseling_name,
            student_counseling.counseling_date,
            branch_master.branch_name
        ")
            ->from("student_counseling")
            ->join("finiyear_master", "finiyear_master.finiYear_id = student_counseling.fk_year")
            ->join('counseling_type_master', 'student_counseling.fk_counseling_type = counseling_type_master.counseling_id', 'left')
            ->join('branch_master', 'branch_master.branch_id = student_counseling.fk_department', 'left')
            ->where("student_counseling.fk_year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('student_counseling.fk_department', (array) $branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('student_counseling.fk_department', explode(',', $branchIds));
    }
}

        return $this->db->get()->result_array();
    }

    public function getBranchwiseCount($institu = null, $branches = [], $year = null)
    {
        $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(student_counseling.stud_counseling_id) as student_count');
        $this->db->from('branch_master');
        $this->db->join('student_counseling', 'branch_master.branch_id = student_counseling.fk_department', 'left');

        if (!empty($institu)) {
            $this->db->where('student_counseling.fkInstitu_id', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('branch_master.branch_id', (array) $branches);
        }
        // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
        if (!empty($year) && $year != 0) {
            $this->db->where('student_counseling.fk_year', $year);
        }

        $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
        $this->db->order_by('branch_master.branch_name', 'ASC');

        return $this->db->get()->result();
    }

    public function getBranchDetailsData($branch_id, $institu = null, $year = null)
    {
        $this->db->select('
            student_counseling.faculty_name,
            student_counseling.stud_counseling_id,
            student_counseling.fk_department,
            student_counseling.counseling_date,
            student_counseling.pdf_file,
            student_counseling.faculty_thumb,
            counseling_type_master.counseling_name,
            branch_master.branch_name
        ');
        $this->db->from('student_counseling');
        $this->db->join('branch_master', 'branch_master.branch_id = student_counseling.fk_department', 'left');
        $this->db->join('counseling_type_master', 'student_counseling.fk_counseling_type = counseling_type_master.counseling_id', 'left');

        if (is_array($branch_id)) {
            $this->db->where_in('student_counseling.fk_department', $branch_id);
        } else {
            $this->db->where('student_counseling.fk_department', $branch_id);
        }

        if (!empty($institu)) {
            $this->db->where('student_counseling.fkInstitu_id', $institu);
        }

        if (!empty($year)) {
            if (is_array($year)) {
                $this->db->where_in('student_counseling.fk_year', $year);
            } else {
                $this->db->where('student_counseling.fk_year', $year);
            }
        }

        return $this->db->get()->result();
    }

    public function getCombinedData($institu = null, $branches = [], $years = [])
    {
        $response = [];

        // Branchwise Count
        $this->db->select('b.branch_id, b.branch_name, COUNT(sp.stud_counseling_id) as student_count');
        $this->db->from('branch_master b');
        $this->db->join('student_counseling sp', 'b.branch_id = sp.fk_department', 'left');

        if (!empty($institu)) {
            $this->db->where('sp.fkInstitu_id', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('b.branch_id', (array) $branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
        if (!empty($years)) {
            $this->db->where_in('sp.fk_year', (array) $years);
        }

        $this->db->group_by('b.branch_id, b.branch_name');
        $this->db->order_by('b.branch_name', 'ASC');
        $response['branchData'] = $this->db->get()->result();

        // Yearwise Count
        $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sp.stud_counseling_id) as count");
        $this->db->from("student_counseling sp");
        $this->db->join("finiyear_master fy", "fy.finiYear_id = sp.fk_year");

        if (!empty($institu)) {
            $this->db->where('sp.fkInstitu_id', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('sp.fk_department', (array) $branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sp.fk_department', explode(',', $branchIds));
    }
}

        if (!empty($years)) {
            $this->db->where_in('sp.fk_year', (array) $years);
        }

        $this->db->group_by("fy.finiYear_id, fy.fini_Label");
        $this->db->order_by("fy.finiYear_id", "ASC");
        $response['yearData'] = $this->db->get()->result();

        return $response;
    }

    public function getStudentsByMeetId($fk_counseling_id)
    {
        return $this->db->select('student_counseling_detail.student_name, student_counseling_detail.prn_no, student_counseling_detail.mobile_no, student_counseling_detail.remark')
            ->from('student_counseling_detail')
            ->where('fk_counseling_id', $fk_counseling_id)
            ->get()
            ->result_array();
    }
}