<?php
class Student_transfortfrom_model extends CI_Model
{
    public function __construct()
    {
        $this->load->database();
    }

    public function getrootstop()
    {
        $this->db->select('route_master_data.*');
        $this->db->from('route_master_data');
        return $this->db->get()->result();
    }

    public function getrootstopname()
    {
        $this->db->select('route_stopmaster_data.*');
        $this->db->from('route_stopmaster_data');
        return $this->db->get()->result();
    }

    public function getusermaster()
    {
        $this->db->select('mainuser_master.*');
        $this->db->from('mainuser_master');
        return $this->db->get()->result();
    }

    public function getvehicle()
    {
        $this->db->select('vehice_registration_data.*');
        $this->db->from('vehice_registration_data');
        return $this->db->get()->result();
    }

    public function getfiniyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        return $this->db->get()->result();
    }

    public function insertdata($model)
    {
        return $this->db->insert('student_transfortfrom_data', $model);
    }

    public function update($model, $club_id)
    {
        return $this->db
            ->where('id', $club_id)
            ->update('student_transfortfrom_data', $model);
    }

    public function getbyid($id)
    {
        return $this->db
            ->select('student_transfortfrom_data.*')
            ->where('id', $id)
            ->get('student_transfortfrom_data')
            ->result();
    }

    public function getdetailview()
    {
        $this->db->select(array(
            'student_transfortfrom_data.*',
            'route_master_data.Route_name',
            'route_stopmaster_data.stop_name',
            'vehice_registration_data.vehi_name',
            'mainuser_master.mainuser_name',
            'finiyear_master.fini_Label'
        ));

        $this->db->from('student_transfortfrom_data');

        $this->db->join('route_master_data',
            'student_transfortfrom_data.fk_rootmaster = route_master_data.Route_masterid', 'left');
        $this->db->join('route_stopmaster_data',
            'student_transfortfrom_data.fk_stopname = route_stopmaster_data.routestop_id', 'left');
        $this->db->join('vehice_registration_data',
            'student_transfortfrom_data.fk_vehiclenames = vehice_registration_data.vehicle_id', 'left');
        $this->db->join('mainuser_master',
            'student_transfortfrom_data.fk_usertype = mainuser_master.mainuser_id', 'left');
        $this->db->join('finiyear_master',
            'student_transfortfrom_data.fk_finalyear = finiyear_master.finiYear_id', 'left');

        $this->db->order_by('student_transfortfrom_data.id', 'DESC');

        return $this->db->get()->result();
    }

    public function deleteById($id)
    {
        return $this->db
            ->where('id', $id)
            ->delete('student_transfortfrom_data');
    }

    public function updateById($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('student_transfortfrom_data', $data);
    }

    public function insertBatch($data)
    {
        return $this->db->insert_batch('student_transfortfrom_data', $data);
    }

    public function deleteByKeys($root,$stop,$vehicle,$user,$year)
    {
        return $this->db->where([
            'fk_rootmaster'   => $root,
            'fk_stopname'     => $stop,
            'fk_vehiclenames' => $vehicle,
            'fk_usertype'     => $user,
            'fk_finalyear'    => $year
        ])->delete('student_transfortfrom_data');
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        return $this->db->get()->result();
    }

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        return $this->db->get()->result();
    }
}