<?php
class UGfellowReport_model extends CI_Model {
    public function __construct()
    {
        $this->load->database();
    }

    public function getFilteredData($institu, $branches = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('ugfellowship_master.UG_id,
                           ugfellowship_master.fkStudent_id,
                           student_reg.FullName,
                           ugfellowship_master.prn,
                           ugfellowship_master.project_name,    
                           ugfellowship_master.gurd_name, 
                           ugfellowship_master.institute, 
                           institute_master.Institu_name,
                           ugfellowship_master.finicial_Year,       
                           finiyear_master.fini_Label');
        $this->db->from('ugfellowship_master');
        $this->db->join('branch_master', 'branch_master.branch_id = ugfellowship_master.fkbranch_id', 'left');
        $this->db->join('institute_master', 'ugfellowship_master.institute = institute_master.Institu_id', 'left');
        $this->db->join('student_reg', 'ugfellowship_master.fkStudent_id = student_reg.Student_id', 'left');
        $this->db->join('finiyear_master', 'ugfellowship_master.finicial_Year = finiyear_master.finiYear_id', 'left');

        // Institute filter
        if (!empty($institu)) {
            $this->db->where('ugfellowship_master.institute', $institu);
        }

        // Branch filter (multiple)
        if (!empty($branches)) {
            if (is_array($branches)) {
                $this->db->where_in('ugfellowship_master.fkbranch_id', $branches);
            } else {
                $this->db->where('ugfellowship_master.fkbranch_id', $branches);
            }
        }
        // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

        // Year filter
        if (!empty($year) && $year != 0) {
            $this->db->where('ugfellowship_master.finicial_Year', $year);
        }

        // Date range filter
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("DATE(ugfellowship_master.Grant_date) BETWEEN '$startDate' AND '$endDate'");
        } elseif (!empty($startDate)) {
            $this->db->where("DATE(ugfellowship_master.Grant_date) >= '$startDate'");
        } elseif (!empty($endDate)) {
            $this->db->where("DATE(ugfellowship_master.Grant_date) <= '$endDate'");
        }

        $this->db->order_by('ugfellowship_master.UG_id', 'DESC');
        return $this->db->get()->result();
    }

    public function getbranch()
    {
        $this->db->select('branch_master.*');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end

        $query = $this->db->get();
        return $query->result();
    }

    public function getyear()
    {
        $this->db->select('finiyear_master.*');
        $this->db->from('finiyear_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getinstitu()
    {
        $this->db->select('institute_master.*');
        $this->db->from('institute_master');
        $query = $this->db->get();
        return $query->result();
    }

    public function getPrintHeadings()
    {
        return $this->db->get('heading_master')->row();
    }

    public function getAllYearsData()
    {
        return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("ugfellowship_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = ugfellowship_master.finicial_Year")
            ->group_by("ugfellowship_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
            ->get()
            ->result_array();
    }

    public function getSingleYearData($yearId, $branches = [])
    {
        $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(*) as count")
            ->from("ugfellowship_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = ugfellowship_master.finicial_Year")
            ->where("ugfellowship_master.finicial_Year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('ugfellowship_master.fkbranch_id', (array)$branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('ugfellowship_master.fkbranch_id', explode(',', $branchIds));
    }
}

        $this->db->group_by("ugfellowship_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
    }

    public function getYearwiseTypes($yearId, $branches = [])
    {
        $this->db->select("ugfellowship_master.UG_id,
                           ugfellowship_master.fkStudent_id,
                           student_reg.FullName,
                           ugfellowship_master.prn,
                           ugfellowship_master.project_name,    
                           ugfellowship_master.gurd_name, 
                           ugfellowship_master.institute, 
                           institute_master.Institu_name,
                           ugfellowship_master.finicial_Year,       
                           finiyear_master.fini_Label as year")
            ->from("ugfellowship_master")
            ->join("finiyear_master", "finiyear_master.finiYear_id = ugfellowship_master.finicial_Year")
            ->join('branch_master', 'ugfellowship_master.fkbranch_id = branch_master.branch_id', 'left')
            ->join('student_reg', 'ugfellowship_master.fkStudent_id = student_reg.Student_id', 'left')
            ->join('institute_master', 'ugfellowship_master.institute = institute_master.Institu_id', 'left')
            ->where("ugfellowship_master.finicial_Year", $yearId);

        if (!empty($branches)) {
            $this->db->where_in('ugfellowship_master.fkbranch_id', (array)$branches);
        }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('ugfellowship_master.fkbranch_id', explode(',', $branchIds));
    }
}

        return $this->db->get()->result_array();
    }

    public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('branch_master.branch_id,
                           branch_master.branch_name,
                           COUNT(ugfellowship_master.UG_id) as ug_count');
        $this->db->from('branch_master');
        $this->db->join('ugfellowship_master', 'branch_master.branch_id = ugfellowship_master.fkbranch_id', 'left');

        if (!empty($institu)) {
            $this->db->where('ugfellowship_master.institute', $institu);
        }
        if (!empty($branches)) {
            $this->db->where_in('branch_master.branch_id', (array)$branches);
        }
        // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end

        if (!empty($year) && $year != 0) {
            $this->db->where('ugfellowship_master.finicial_Year', $year);
        }
        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("ugfellowship_master.created_at BETWEEN '$startDate' AND '$endDate'");
        }

        $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
        $this->db->order_by('branch_master.branch_name', 'ASC');

        return $this->db->get()->result();
    }

    public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
    {
        $this->db->select('ugfellowship_master.UG_id,
                           ugfellowship_master.fkStudent_id,
                           student_reg.FullName,
                           ugfellowship_master.prn,
                           ugfellowship_master.project_name,    
                           ugfellowship_master.gurd_name, 
                           ugfellowship_master.institute, 
                           institute_master.Institu_name,
                           ugfellowship_master.finicial_Year,       
                           finiyear_master.fini_Label,
                           ugfellowship_master.fkbranch_id,
                           branch_master.branch_name');
        $this->db->from('ugfellowship_master');
        $this->db->join('branch_master', 'branch_master.branch_id = ugfellowship_master.fkbranch_id', 'left');
        $this->db->join('institute_master', 'ugfellowship_master.institute = institute_master.Institu_id', 'left');
        $this->db->join('student_reg', 'ugfellowship_master.fkStudent_id = student_reg.Student_id', 'left');
        $this->db->join('finiyear_master', 'ugfellowship_master.finicial_Year = finiyear_master.finiYear_id', 'left');

        if (is_array($branch_id)) {
            $this->db->where_in('ugfellowship_master.fkbranch_id', $branch_id);
        } else {
            $this->db->where('ugfellowship_master.fkbranch_id', $branch_id);
        }

        if (!empty($institu)) {
            $this->db->where('ugfellowship_master.institute', $institu);
        }

        if (!empty($year)) {
            if (is_array($year)) {
                $this->db->where_in('ugfellowship_master.finicial_Year', $year);
            } else {
                $this->db->where('ugfellowship_master.finicial_Year', $year);
            }
        }

        if (!empty($startDate) && !empty($endDate)) {
            $this->db->where("ugfellowship_master.Grant_date BETWEEN '$startDate' AND '$endDate'");
        }

        return $this->db->get()->result();
    }

    public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];

    // Branchwise Count
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.UG_id) as ug_count');
    $this->db->from('branch_master b');
    $this->db->join('ugfellowship_master sr', 'b.branch_id = sr.fkbranch_id', 'left');

    if (!empty($institu)) {
        $this->db->where('sr.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("DATE(sr.Grant_date) BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();

    // Yearwise Count
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.UG_id) as count");
    $this->db->from("ugfellowship_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");

    if (!empty($institu)) {
        $this->db->where('sr.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkbranch_id', (array)$branches);
    }
    else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sr.fkbranch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("DATE(sr.Grant_date) BETWEEN '$startDate' AND '$endDate'");
    }

    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();

    return $response;
}
}