<?php
class UGfellow_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    // Insert UG Fellowship data
    public function insertICTTool($data) {
     $this->db->insert('ugfellowship_master', $data);
     return $this->db->insert_id();
    }

    // Get all UG Fellowship records with related data
    public function getdetailview()
    {      
        $this->db->select('ugfellowship_master.UG_id,
                           ugfellowship_master.fkStudent_id,
                           student_reg.FullName,
                           ugfellowship_master.fkclass_id,
                           classmaster.classname,
                           ugfellowship_master.fkbranch_id,
                           branch_master.branch_name,
                           ugfellowship_master.prn,
                           ugfellowship_master.institute,
                           institute_master.Institu_name,
                           ugfellowship_master.project_name,
                           ugfellowship_master.Division,
                           ugfellowship_master.Contact,
                           ugfellowship_master.Photo_Url,
                           ugfellowship_master.gurd_name,
                           ugfellowship_master.finicial_Year,
                           finiyear_master.fini_Label,
                           ugfellowship_master.excel_file,
                           ugfellowship_master.created_date');

        $this->db->from('ugfellowship_master');
        $this->db->join('student_reg', 'ugfellowship_master.fkStudent_id = student_reg.Student_id', 'left');
        $this->db->join('branch_master', 'ugfellowship_master.fkbranch_id = branch_master.branch_id', 'left');
        $this->db->join('classmaster', 'ugfellowship_master.fkclass_id = classmaster.class_id', 'left');
        $this->db->join('institute_master', 'ugfellowship_master.institute = institute_master.Institu_id', 'left');
        $this->db->join('finiyear_master', 'ugfellowship_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->where('ugfellowship_master.is_active', 1);
        $this->db->order_by('ugfellowship_master.UG_id','DESC');

        $query = $this->db->get();
        return $query->result();      
    }

    // Get single UG Fellowship by ID (ONLY ONE METHOD)
    public function getUGfellowById($UG_id) {
        $this->db->select('ugfellowship_master.*,
                           student_reg.FullName,
                           institute_master.Institu_name,
                           finiyear_master.fini_Label');
        $this->db->from('ugfellowship_master');
        $this->db->join('student_reg', 'ugfellowship_master.fkStudent_id = student_reg.Student_id', 'left');
        $this->db->join('institute_master', 'ugfellowship_master.institute = institute_master.Institu_id', 'left');
        $this->db->join('finiyear_master', 'ugfellowship_master.finicial_Year = finiyear_master.finiYear_id', 'left');
        $this->db->where('ugfellowship_master.UG_id', $UG_id);
        $this->db->where('ugfellowship_master.is_active', 1);
        
        $query = $this->db->get();
        return $query->row();
    }

    // Update UG Fellowship
    public function updateUGfellow($UG_id, $data) {
        $this->db->where('UG_id', $UG_id);
        return $this->db->update('ugfellowship_master', $data);
    }

    // Soft Delete UG Fellowship
    public function deleteUGfellow($UG_id) {
        $data = array(
            'is_active' => 0,
            'deleted_date' => date('Y-m-d H:i:s')
        );
        $this->db->where('UG_id', $UG_id);
        return $this->db->update('ugfellowship_master', $data);
    }

    // Hard Delete UG Fellowship (permanent delete)
    public function permanentDeleteUGfellow($UG_id) {
        $this->db->where('UG_id', $UG_id);
        return $this->db->delete('ugfellowship_master');
    }

    // ============================================
    // MASTER DATA METHODS
    // ============================================

    // Insert new student and return ID
    public function insertstudent($data) {
        if ($this->db->insert('student_reg', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new branch and return ID
public function insertbranch($data) {
    if ($this->db->insert('branch_master', $data)) {
        return $this->db->insert_id();
    }
    return false;
}

    // Also add these methods if missing:
public function insertclass($data) {
    if ($this->db->insert('classmaster', $data)) {
        return $this->db->insert_id();
    }
    return false;
}

    
    // Insert new institute and return ID
    public function insertinstitute($data) {
        if ($this->db->insert('institute_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Insert new year and return ID
    public function insertYear($data) {
        if ($this->db->insert('finiyear_master', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    // Get student data  
    public function getstudent() {
        $this->db->select('Student_id, FullName');
        $this->db->from('student_reg');
        $this->db->where('is_active', 1);
        $this->db->order_by('FullName', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    
// Get branch data  
public function getbranch() {
    $this->db->select('branch_id, branch_name');
    $this->db->from('branch_master'); // Update table name if different
    // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
    $this->db->where('is_active', 1);
    $this->db->order_by('branch_name', 'ASC');
    $query = $this->db->get();
    return $query->result();
}

    public function getclass() {
    $this->db->select('class_id, classname');
    $this->db->from('classmaster'); // Update table name if different
    $this->db->where('is_active', 1);
    $this->db->order_by('classname', 'ASC');
    $query = $this->db->get();
    return $query->result();
}

    // Get institute data
    public function getinstitute() {
        $this->db->select('Institu_id, Institu_name');
        $this->db->from('institute_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('Institu_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    // Get year data  
    public function getyear() {
        $this->db->select('finiYear_id, fini_Label');
        $this->db->from('finiyear_master');
        $this->db->where('is_active', 1);
        $this->db->order_by('fini_Label', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    // Check if student exists by name
    public function studentExists($student_name) {
        $this->db->where('LOWER(FullName)', strtolower($student_name));
        $query = $this->db->get('student_reg');
        return $query->num_rows() > 0;
    }

    // Check if branch exists by name
 public function branchExists($branch_name) {
    $this->db->where('LOWER(branch_name)', strtolower($branch_name));
    $query = $this->db->get('branch_master');
    return $query->num_rows() > 0;
}


    public function classExists($class_name) {
    $this->db->where('LOWER(classname)', strtolower($class_name));
    $query = $this->db->get('classmaster');
    return $query->num_rows() > 0;
}
    
    // Check if institute exists by name
    public function instituteExists($institute_name) {
        $this->db->where('LOWER(Institu_name)', strtolower($institute_name));
        $query = $this->db->get('institute_master');
        return $query->num_rows() > 0;
    }
    
    // Check if year exists by name
    public function yearExists($year_name) {
        $this->db->where('LOWER(fini_Label)', strtolower($year_name));
        $query = $this->db->get('finiyear_master');
        return $query->num_rows() > 0;
    }
    
    // Get student ID by name
    public function getStudentIdByName($student_name) {
        $this->db->select('Student_id');
        $this->db->where('LOWER(FullName)', strtolower($student_name));
        $query = $this->db->get('student_reg');
        if ($query->num_rows() > 0) {
            return $query->row()->Student_id;
        }
        return false;
    }

    // Get branch ID by name
public function getBranchIdByName($branch_name) {
    $this->db->select('fkbranch_id');
    $this->db->where('LOWER(branch_name)', strtolower($branch_name));
    $query = $this->db->get('branch_master');
    if ($query->num_rows() > 0) {
        return $query->row()->fkbranch_id;
    }
    return false;
}

    public function getClassIdByName($class_name) {
    $this->db->select('class_id');
    $this->db->where('LOWER(classname)', strtolower($class_name));
    $query = $this->db->get('classmaster');
    if ($query->num_rows() > 0) {
        return $query->row()->class_id;
    }
    return false;
}



    // Get institute ID by name
    public function getinstituteIdByName($institute_name) {
        $this->db->select('Institu_id');
        $this->db->where('LOWER(Institu_name)', strtolower($institute_name));
        $query = $this->db->get('institute_master');
        if ($query->num_rows() > 0) {
            return $query->row()->Institu_id;
        }
        return false;
    }
    
    // Get year ID by name
    public function getYearIdByName($year_name) {
        $this->db->select('finiYear_id');
        $this->db->where('LOWER(fini_Label)', strtolower($year_name));
        $query = $this->db->get('finiyear_master');
        if ($query->num_rows() > 0) {
            return $query->row()->finiYear_id;
        }
        return false;
    }
}
?>













