<?php
  class VAPReport_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
  

   
// Updated getFilteredData method for VAPReport_model

public function getFilteredData($institu, $branches = [], $companies = [], $year = null, $startDate = null, $endDate = null, $classes = [])
{
    $this->db->select('vap_master.vap_id,
                    vap_master.prn,
                    vap_master.Student_name,
                    vap_master.fkbranch_id,
                    branch_master.branch_name,
                    vap_master.fkclass_id,
                    classmaster.classname,
                    vap_master.Division,
                    vap_master.Vap_tittle,
                    vap_master.resource_person_name,
                    vap_master.resource_person_contact,
                    vap_master.Company_name,
                    company_master.comp_name,
                    vap_master.Address, 
                    vap_master.finicial_Year,
                    finiyear_master.fini_Label,
                    vap_master.Feedback,
                    vap_master.Vap_Start,
                    vap_master.Vap_End');
                       
    $this->db->from('vap_master');
    $this->db->join('branch_master', 'vap_master.fkbranch_id = branch_master.branch_id', 'left');
    $this->db->join('classmaster', 'vap_master.fkclass_id = classmaster.class_id', 'left');
    $this->db->join('company_master', 'vap_master.Company_name = company_master.ID', 'left');
    $this->db->join('finiyear_master', 'finiyear_master.finiYear_id = vap_master.finicial_Year', 'left');

    // 🔹 Institute filter
    if (!empty($institu) && $institu != 0) {
        $this->db->where('vap_master.institute', $institu);
    }

    // 🔹 Branch filter (multiple)
    if (!empty($branches)) {

    // case 1: branches parameter aaya hai
    if (is_array($branches)) {
        $this->db->where_in('vap_master.fkbranch_id', $branches);
    } else {
        $this->db->where('vap_master.fkbranch_id', $branches);
    }

} else {

    // case 2: branches empty hai → session se lo
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
}

    // if (!empty($branches)) {
    //     if (is_array($branches)) {
    //         $this->db->where_in('vap_master.fkbranch_id', $branches);
    //     } else {
    //         $this->db->where('vap_master.fkbranch_id', $branches);
    //     }
    // }

    // 🔹 Class filter (multiple) - NEW
    if (!empty($classes)) {
        if (is_array($classes)) {
            $this->db->where_in('vap_master.fkclass_id', $classes);
        } else {
            $this->db->where('vap_master.fkclass_id', $classes);
        }
    }

    // 🔹 Company filter (multiple)
    if (!empty($companies)) {
        if (is_array($companies)) {
            $this->db->where_in('vap_master.Company_name', $companies);
        } else {
            $this->db->where('vap_master.Company_name', $companies);
        }
    }

    // 🔹 Year filter
    if (!empty($year) && $year != 0) {
        $this->db->where('vap_master.finicial_Year', $year);
    }

    // 🔹 Simple date range filter
if (!empty($startDate) && !empty($endDate)) {
    $this->db->where("DATE(vap_master.VAP_Start) >=", $startDate);
    $this->db->where("DATE(vap_master.VAP_End) <=", $endDate);
} elseif (!empty($startDate)) {
    $this->db->where("DATE(vap_master.VAP_Start) >=", $startDate);
} elseif (!empty($endDate)) {
    $this->db->where("DATE(vap_master.VAP_End) <=", $endDate);
}

    $this->db->order_by('vap_master.vap_id', 'DESC');
    return $this->db->get()->result();
}
 
   
     public function getbranch()
     {
      $this->db->select('branch_master.*,');
      $this->db->from('branch_master');
      // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
       $query = $this->db->get();
        return $query->result();
     }
     
     public function getclass()
{
    $this->db->select('classmaster.*');
    $this->db->from('classmaster');
    $query = $this->db->get();
    return $query->result();
}
 
     public function getcompany() 
    {
        $this->db->select('ID, comp_name');
        $this->db->from('company_master');
        $query = $this->db->get();
        return $query->result();
    }
 
    
      public function getyear()
     {
      $this->db->select('finiyear_master.*,');
      $this->db->from('finiyear_master');
       $query = $this->db->get();
        return $query->result();
     }
       public function getinstitu()
     {
      $this->db->select('institute_master.*,');
      $this->db->from('institute_master');
       $query = $this->db->get();
        return $query->result();
     }
 
   
public function getPrintHeadings()
{
    return $this->db->get('heading_master')->row();
} 
   





    // b new 

public function getAllYearsData()
{
    return $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(vap_master.vap_id) as count")
        ->from("vap_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = vap_master.finicial_Year")
        ->group_by("vap_master.finicial_Year, fini_Label, finiyear_master.finiYear_id")
        ->get()
        ->result_array();
}
 
public function getSingleYearData($yearId, $branches = [],)
{
    $this->db->select("finiyear_master.finiYear_id as year_id, fini_Label as year, COUNT(vap_master.vap_id) as count")
        ->from("vap_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = vap_master.finicial_Year")
        ->where("vap_master.finicial_Year", $yearId);

        if (!empty($branches)) {
                $this->db->where_in('vap_master.fkbranch_id', (array)$branches);
            }
             else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('vap_master.fkbranch_id', explode(',', $branchIds));
    }
}

        $this->db->group_by("vap_master.finicial_Year, fini_Label, finiyear_master.finiYear_id");
        return $this->db->get()->result_array();
}
 
public function getYearwiseTypes($yearId, $branches = [],)
{
    $this->db->select("vap_master.vap_id,
                    vap_master.prn,
                    vap_master.Student_name,
                    vap_master.fkbranch_id,
                    branch_master.branch_name,
                    vap_master.fkclass_id,
                    classmaster.classname,
                    vap_master.Division,
                    vap_master.Vap_tittle,
                    vap_master.resource_person_name,
                    vap_master.resource_person_contact,
                    vap_master.Company_name,
                    company_master.comp_name,
                    vap_master.address, 
                    vap_master.Feedback,       
                    vap_master.Vap_Start,
                    vap_master.Vap_End,
                    vap_master.finicial_Year,
                       finiyear_master.fini_Label")
        ->from("vap_master")
        ->join("finiyear_master", "finiyear_master.finiYear_id = vap_master.finicial_Year")
        ->join('branch_master', 'vap_master.fkbranch_id = branch_master.branch_id', 'left')
        ->join('classmaster', 'vap_master.fkclass_id = classmaster.class_id', 'left')
    ->join('company_master', 'vap_master.Company_name = company_master.ID', 'left')
        ->where("vap_master.finicial_Year", $yearId);

        
    if (!empty($branches)) {
        $this->db->where_in('vap_master.fkbranch_id', (array)$branches);
       }
        else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('vap_master.fkbranch_id', explode(',', $branchIds));
    }
}
        return $this->db->get()->result_array();
}
 
 

 
// Add these methods to your VAPReport_model class

  public function getBranchwiseCount($institu = null, $branches = [], $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('branch_master.branch_id,
                       branch_master.branch_name,
                       COUNT(vap_master.vap_id) as Vap_count');
    $this->db->from('branch_master');
    $this->db->join('vap_master', 'branch_master.branch_id = vap_master.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('vap_master.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('branch_master.branch_id', (array)$branches);
    }
    // new code
    else{
        $branchIds = $this->session->userdata('fkBranch_Id');

        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    
    }
// new code end
    if (!empty($year) && $year != 0) {
        $this->db->where('vap_master.finicial_Year', $year);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("vap_master.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('branch_master.branch_id, branch_master.branch_name');
    $this->db->order_by('branch_master.branch_name', 'ASC');
 
    return $this->db->get()->result();
}
 
public function getBranchDetailsData($branch_id, $institu = null, $year = null, $startDate = null, $endDate = null)
{
    $this->db->select('vap_master.vap_id,
                    vap_master.prn,
                    vap_master.Student_name,
                    vap_master.fkbranch_id,
                    branch_master.branch_name,
                    vap_master.fkclass_id,
                    classmaster.classname,
                    vap_master.Division,
                    vap_master.Vap_tittle,
                    vap_master.resource_person_name,
                    vap_master.resource_person_contact,
                    vap_master.Company_name,
                    company_master.comp_name,
                    vap_master.address, 
                    vap_master.finicial_Year,
                    finiyear_master.fini_Label,
                    vap_master.Feedback,
                    vap_master.Vap_Start,
                    vap_master.Vap_End');
    $this->db->from('vap_master');
    $this->db->join('branch_master', 'branch_master.branch_id = vap_master.fkbranch_id', 'left');
    $this->db->join('company_master', 'vap_master.Company_name = company_master.ID', 'left');
    $this->db->join('classmaster', 'vap_master.fkclass_id = classmaster.class_id', 'left');
    $this->db->join("finiyear_master", "finiyear_master.finiYear_id = vap_master.finicial_Year");
 
   if (is_array($branch_id)) {
    $this->db->where_in('vap_master.fkbranch_id', $branch_id);
} else {
    $this->db->where('vap_master.fkbranch_id', $branch_id);
}
 
 
    if (!empty($institu)) {
        $this->db->where('vap_master.institute', $institu);
    }
    // if (!empty($year) && $year != 0) {
    //     $this->db->where('vap_master.finicial_Year', $year);
    // }

    if (!empty($year)) {
    if (is_array($year)) {
        $this->db->where_in('vap_master.finicial_Year', $year);
    } else {
        $this->db->where('vap_master.finicial_Year', $year);
    }
    }
    
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("vap_master.VAP_date BETWEEN '$startDate' AND '$endDate'");
    }
 
    return $this->db->get()->result();
}
 
 public function getCombinedData($institu = null, $branches = [], $years = [], $startDate = null, $endDate = null)
{
    $response = [];
 
    // --- 1. Branchwise Count ---
    $this->db->select('b.branch_id, b.branch_name, COUNT(sr.vap_id) as Vap_count');
    $this->db->from('branch_master b');
    $this->db->join('vap_master sr', 'b.branch_id = sr.fkbranch_id', 'left');
 
    if (!empty($institu)) {
        $this->db->where('sr.institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('b.branch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('b.branch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by('b.branch_id, b.branch_name');
    $this->db->order_by('b.branch_name', 'ASC');
    $response['branchData'] = $this->db->get()->result();
 
    // --- 2. Yearwise Count ---
    $this->db->select("fy.finiYear_id as year_id, fy.fini_Label as year, COUNT(sr.vap_id) as count");
    $this->db->from("vap_master sr");
    $this->db->join("finiyear_master fy", "fy.finiYear_id = sr.finicial_Year");
 
    if (!empty($institu)) {
        $this->db->where('sr.Institute', $institu);
    }
    if (!empty($branches)) {
        $this->db->where_in('sr.fkbranch_id', (array)$branches);
    }
     else {
    $branchIds = $this->session->userdata('fkBranch_Id');
    if (!empty($branchIds)) {
        $this->db->where_in('sr.fkbranch_id', explode(',', $branchIds));
    }
}
    if (!empty($years)) {
        $this->db->where_in('sr.finicial_Year', (array)$years);
    }
    if (!empty($startDate) && !empty($endDate)) {
        $this->db->where("sr.created_at BETWEEN '$startDate' AND '$endDate'");
    }
 
    $this->db->group_by("fy.finiYear_id, fy.fini_Label");
    $this->db->order_by("fy.finiYear_id", "ASC");
    $response['yearData'] = $this->db->get()->result();
 
    return $response;
}
   


}