<?php
class VAP_model extends CI_Model {
    
    public function __construct()
    {
        $this->load->database();
    }
    
    public function getdetailview()
    {
        $this->db->select('vap_master.vap_id,
                          vap_master.prn,
                          vap_master.Student_name,
                          vap_master.fkbranch_id, 
                          branch_master.branch_name,
                          vap_master.fkclass_id,
                          classmaster.classname,
                          vap_master.Division,
                          vap_master.Vap_tittle,
                          vap_master.resource_person_name,
                          vap_master.resource_person_contact,
                          vap_master.Address,
                          vap_master.Vap_Start,
                          vap_master.Vap_End,
                          vap_master.Photo_Url,
                          vap_master.Feedback,
                          vap_master.Company_name,
                          company_master.comp_name,
                          vap_master.finicial_Year,
                          finiyear_master.fini_Label,
                          ');
        $this->db->from('vap_master');
        $this->db->join('branch_master', 'branch_master.branch_id = vap_master.fkbranch_id', 'left');
        $this->db->join('classmaster', 'classmaster.class_id = vap_master.fkclass_id', 'left');
        $this->db->join('company_master', 'company_master.ID = vap_master.Company_name', 'left');
        $this->db->join('finiyear_master', 'finiyear_master.finiyear_id = vap_master.finicial_Year', 'left');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->order_by('vap_master.vap_id', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getbranch()
    {
        $this->db->select('branch_id, branch_name');
        $this->db->from('branch_master');
        // new code
    $branchIds = $this->session->userdata('fkBranch_Id');

    if (!empty($branchIds)) {
        if (!is_array($branchIds)) {
            $branchIds = explode(',', $branchIds);
        }

        $this->db->where_in('branch_master.branch_id', $branchIds);
    }
// new code end
        $this->db->order_by('branch_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getclass()
    {
        $this->db->select('class_id, classname');
        $this->db->from('classmaster');
        $this->db->order_by('classname', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }

    public function getcompany() 
    {
        $this->db->select('ID, comp_name');
        $this->db->from('company_master');
        $this->db->order_by('comp_name', 'ASC');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getyear()
    {
        $this->db->select('*');
        $this->db->from('finiyear_master');
        $this->db->order_by('fini_Label', 'DESC');
        $query = $this->db->get();
        return $query->result();
    }
    
    public function getvapmaster($id)
    {
        $this->db->select('*');
        $this->db->from('vap_master');
        $this->db->where('vap_id', $id);
        $this->db->limit(1);
        $query = $this->db->get();
        return $query->row();
    }
    
    public function getvapdetails($master_id)
    {
        $this->db->select('*');
        $this->db->from('vap_master');
        $this->db->where('vap_id', $master_id);
        $query = $this->db->get();
        return $query->result();
    }
    
    // Get ID by Name methods
    public function getBranchIdByName($name)
    {
        $this->db->select('branch_id');
        $this->db->from('branch_master');
        $this->db->where('LOWER(branch_name)', strtolower(trim($name)));
        $query = $this->db->get();
        $result = $query->row();
        return $result ? $result->branch_id : null;
    }
    
    public function getClassIdByName($name)
    {
        $this->db->select('class_id');
        $this->db->from('classmaster');
        $this->db->where('LOWER(classname)', strtolower(trim($name)));
        $query = $this->db->get();
        $result = $query->row();
        return $result ? $result->class_id : null;
    }
    
    public function getCompanyIdByName($name)
    {
        $this->db->select('ID');
        $this->db->from('company_master');
        $this->db->where('LOWER(comp_name)', strtolower(trim($name)));
        $query = $this->db->get();
        $result = $query->row();
        return $result ? $result->ID : null;
    }
    
    public function getYearIdByName($name)
    {
        $this->db->select('finiyear_id');
        $this->db->from('finiyear_master');
        $this->db->where('LOWER(fini_Label)', strtolower(trim($name)));
        $query = $this->db->get();
        $result = $query->row();
        return $result ? $result->finiyear_id : null;
    }
    
    // Insert new master data methods
    public function get_branch_by_name($name)
    {
        $this->db->where('LOWER(branch_name)', strtolower($name));
        $query = $this->db->get('branch_master');
        return $query->row();
    }
    
    public function insert_branch($name)
    {
        $data = array('branch_name' => $name);
        $this->db->insert('branch_master', $data);
        return $this->db->insert_id();
    }
    
    public function get_class_by_name($name)
    {
        $this->db->where('LOWER(classname)', strtolower($name));
        $query = $this->db->get('classmaster');
        return $query->row();
    }
    
    public function insert_class($name)
    {
        $data = array('classname' => $name);
        $this->db->insert('classmaster', $data);
        return $this->db->insert_id();
    }
    
    public function get_company_by_name($name)
    {
        $this->db->where('LOWER(comp_name)', strtolower($name));
        $query = $this->db->get('company_master');
        return $query->row();
    }
    
    public function insert_company($name)
    {
        $data = array('comp_name' => $name);
        $this->db->insert('company_master', $data);
        return $this->db->insert_id();
    }
    
    public function get_year_by_name($name)
    {
        $this->db->where('LOWER(fini_Label)', strtolower($name));
        $query = $this->db->get('finiyear_master');
        return $query->row();
    }
    
    public function insert_year($name)
    {
        $data = array('fini_Label' => $name);
        $this->db->insert('finiyear_master', $data);
        return $this->db->insert_id();
    }
    
    // Insert VAP record
    public function insertVAP($data)
    {
        $this->db->insert('vap_master', $data);
        return $this->db->insert_id();
    }

    // Add these methods to VAP_model class

public function getVAPById($vap_id)
{
    $this->db->select('*');
    $this->db->from('vap_master');
    $this->db->where('vap_id', $vap_id);
    $query = $this->db->get();
    return $query->row();
}

public function updateVAP($vap_id, $data)
{
    $this->db->where('vap_id', $vap_id);
    return $this->db->update('vap_master', $data);
}

public function deleteVAPDetails($vap_id)
{
    $this->db->where('vap_id', $vap_id);
    return $this->db->delete('vap_master');
}
}
?>